/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.exist.EXistException;
import org.exist.backup.ConsistencyCheck;
import org.exist.backup.ErrorReport;
import org.exist.backup.SystemExport;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.ArgumentUtil;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;
import org.exist.xquery.TerminatedException;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ArgumentBuilder;
import se.softhouse.jargo.ArgumentException;
import se.softhouse.jargo.Arguments;
import se.softhouse.jargo.CommandLineParser;
import se.softhouse.jargo.ParsedArguments;

public class ExportMain {
    private static final Argument<?> helpArg = Arguments.helpArgument((String)"-h", (String[])new String[]{"--help"});
    private static final Argument<Boolean> verboseArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-v", (String[])new String[]{"--verbose"}).description("print processed resources to stdout")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> noCheckArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-n", (String[])new String[]{"--nocheck"}).description("do not run a consistency check. Just export the data.")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> checkDocsArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-s", (String[])new String[]{"--check-docs"}).description("scan every document to find errors in the the nodes stored (costs time)")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> directAccessArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-D", (String[])new String[]{"--direct"}).description("use an (even more) direct access to the db, bypassing some index structures")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> exportArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-x", (String[])new String[]{"--export"}).description("export database contents while preserving as much data as possible")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> incrementalArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-i", (String[])new String[]{"--incremental"}).description("create incremental backup (use with --export|-x)")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<Boolean> zipArg = ((ArgumentBuilder.OptionArgumentBuilder)Arguments.optionArgument((String)"-z", (String[])new String[]{"--zip"}).description("write output to a ZIP instead of a file system directory")).defaultValue(Boolean.valueOf(false)).build();
    private static final Argument<File> configArg = ((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-c", "--config"}).description("the database configuration (conf.xml) file to use for launching the db.")).build();
    private static final Argument<File> outputDirArg = ((ArgumentBuilder.DefaultArgumentBuilder)((ArgumentBuilder.DefaultArgumentBuilder)Arguments.fileArgument((String[])new String[]{"-d", "--dir"}).description("the directory to which all output will be written.")).defaultValue((Object)Paths.get("export", new String[0]).toAbsolutePath().toFile())).build();

    protected static BrokerPool startDB(Optional<Path> configFile) {
        try {
            Configuration config = configFile.isPresent() ? new Configuration(configFile.get().toAbsolutePath().toString(), Optional.empty()) : new Configuration();
            config.setProperty("db-connection.emergency", Boolean.TRUE);
            BrokerPool.configure(1, 5, config);
            return BrokerPool.getInstance();
        }
        catch (EXistException | DatabaseConfigurationException e) {
            System.err.println("ERROR: Failed to open database: " + e.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
        try {
            ParsedArguments arguments = CommandLineParser.withArguments((Argument[])new Argument[]{noCheckArg, checkDocsArg, directAccessArg, exportArg, incrementalArg, zipArg}).andArguments(new Argument[]{configArg, outputDirArg}).andArguments(new Argument[]{helpArg, verboseArg}).parse(args);
            ExportMain.process(arguments);
        }
        catch (ArgumentException e) {
            System.out.println(e.getMessageAndUsage());
            System.exit(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(ParsedArguments arguments) {
        boolean verbose = ArgumentUtil.getBool(arguments, verboseArg);
        boolean noCheck = ArgumentUtil.getBool(arguments, noCheckArg);
        boolean checkDocs = ArgumentUtil.getBool(arguments, checkDocsArg);
        boolean direct = ArgumentUtil.getBool(arguments, directAccessArg);
        boolean export = ArgumentUtil.getBool(arguments, exportArg);
        boolean incremental = ArgumentUtil.getBool(arguments, incrementalArg);
        boolean zip = ArgumentUtil.getBool(arguments, zipArg);
        Optional<Path> dbConfig = ArgumentUtil.getOpt(arguments, configArg).map(File::toPath);
        Path exportTarget = ((File)arguments.get(outputDirArg)).toPath();
        BrokerPool pool = ExportMain.startDB(dbConfig);
        if (pool == null) {
            System.exit(1);
        }
        int retval = 0;
        try (DBBroker broker = pool.get(Optional.of(pool.getSecurityManager().getSystemSubject()));){
            List<ErrorReport> errors = null;
            if (!noCheck) {
                ConsistencyCheck checker = new ConsistencyCheck(broker, direct, checkDocs);
                errors = checker.checkAll(new CheckCallback());
            }
            if (errors != null && errors.size() > 0) {
                System.err.println("ERRORS FOUND.");
                retval = 1;
            } else {
                System.out.println("No errors.");
            }
            if (export) {
                if (!Files.exists(exportTarget, new LinkOption[0])) {
                    Files.createDirectories(exportTarget, new FileAttribute[0]);
                } else if (!Files.isDirectory(exportTarget, new LinkOption[0])) {
                    System.err.println("Output dir already exists and is a file: " + exportTarget.toAbsolutePath().toString());
                    System.exit(3);
                }
                SystemExport sysexport = new SystemExport(broker, new Callback(verbose), null, direct);
                sysexport.export(exportTarget.toAbsolutePath().toString(), incremental, zip, errors);
            }
        }
        catch (EXistException e) {
            System.err.println("ERROR: Failed to retrieve database broker: " + e.getMessage());
            retval = 4;
        }
        catch (TerminatedException e) {
            System.err.println("WARN: Export was terminated by db.");
            retval = 5;
        }
        catch (PermissionDeniedException pde) {
            System.err.println("ERROR: Failed to retrieve database data: " + pde.getMessage());
            retval = 6;
        }
        catch (IOException ioe) {
            System.err.println("ERROR: Failed to retrieve database data: " + ioe.getMessage());
            retval = 7;
        }
        finally {
            BrokerPool.stopAll(false);
        }
        System.exit(retval);
    }

    private static class CheckCallback
    implements ConsistencyCheck.ProgressCallback {
        private CheckCallback() {
        }

        @Override
        public void startDocument(String name, int current, int count) {
        }

        @Override
        public void startCollection(String path) {
        }

        @Override
        public void error(ErrorReport error) {
            System.out.println(error.toString());
        }
    }

    private static class Callback
    implements SystemExport.StatusCallback {
        private boolean verbose = false;

        public Callback(boolean verbose) {
            this.verbose = verbose;
        }

        @Override
        public void startCollection(String path) {
            if (this.verbose) {
                System.out.println("Entering collection " + path + " ...");
            }
        }

        @Override
        public void startDocument(String name, int count, int docsCount) {
            if (this.verbose) {
                System.out.println("Writing document " + name + " [" + (count + 1) + " of " + docsCount + ']');
            }
        }

        @Override
        public void error(String message, Throwable exception) {
            System.err.println(message);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }
}

