/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.util.EXistInputSource;
import org.exist.util.FileInputSource;
import org.exist.util.FileUtils;

public class FileSystemBackupDescriptor
extends AbstractBackupDescriptor {
    protected Path descriptor;

    public FileSystemBackupDescriptor(Path theDesc) throws FileNotFoundException {
        if (!FileUtils.fileName(theDesc).equals("__contents__.xml") || Files.isDirectory(theDesc, new LinkOption[0]) || !Files.isReadable(theDesc)) {
            throw new FileNotFoundException(theDesc.toAbsolutePath().toString() + " is not a valid collection descriptor");
        }
        this.descriptor = theDesc;
    }

    @Override
    public BackupDescriptor getChildBackupDescriptor(String describedItem) {
        Path child = this.descriptor.getParent().resolve(describedItem).resolve("__contents__.xml");
        FileSystemBackupDescriptor bd = null;
        try {
            bd = new FileSystemBackupDescriptor(child);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bd;
    }

    @Override
    public BackupDescriptor getBackupDescriptor(String describedItem) {
        String topDir = this.descriptor.getParent().getParent().toAbsolutePath().toString();
        String subDir = topDir + describedItem;
        String desc = subDir + '/' + "__contents__.xml";
        FileSystemBackupDescriptor bd = null;
        try {
            bd = new FileSystemBackupDescriptor(Paths.get(desc, new String[0]));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return bd;
    }

    @Override
    public EXistInputSource getInputSource() {
        return new FileInputSource(this.descriptor);
    }

    @Override
    public EXistInputSource getInputSource(String describedItem) {
        Path child = this.descriptor.getParent().resolve(describedItem);
        FileInputSource is = null;
        if (!Files.isDirectory(child, new LinkOption[0]) && Files.isReadable(child)) {
            is = new FileInputSource(child);
        }
        return is;
    }

    @Override
    public String getSymbolicPath() {
        return this.descriptor.toAbsolutePath().toString();
    }

    @Override
    public String getSymbolicPath(String describedItem, boolean isChildDescriptor) {
        Path resbase = this.descriptor.getParent().resolve(describedItem);
        if (isChildDescriptor) {
            resbase = resbase.resolve("__contents__.xml");
        }
        return resbase.toAbsolutePath().toString();
    }

    @Override
    public Properties getProperties() throws IOException {
        Path propFile;
        Path dir = this.descriptor.getParent();
        if (dir != null && (dir = dir.getParent()) != null && Files.exists(propFile = dir.resolve("backup.properties"), new LinkOption[0])) {
            Properties properties = new Properties();
            try (InputStream is = Files.newInputStream(propFile, new OpenOption[0]);){
                properties.load(is);
            }
            return properties;
        }
        return null;
    }

    @Override
    public Path getParentDir() {
        return this.descriptor.getParent().getParent().getParent();
    }

    @Override
    public String getName() {
        return FileUtils.fileName(this.descriptor.getParent().getParent());
    }

    @Override
    public Path getRepoBackup() throws IOException {
        Path archive = this.descriptor.getParent().getParent().resolve("expathrepo.zip");
        if (Files.exists(archive, new LinkOption[0])) {
            return archive;
        }
        return null;
    }
}

