/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.Backup;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.BackupDirectory;
import org.exist.backup.BackupHandler;
import org.exist.backup.BackupWriter;
import org.exist.backup.ErrorReport;
import org.exist.backup.FileSystemWriter;
import org.exist.backup.ZipWriter;
import org.exist.collections.Collection;
import org.exist.collections.MutableCollection;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.StoredNode;
import org.exist.management.Agent;
import org.exist.management.AgentFactory;
import org.exist.security.ACLPermission;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.internal.AccountImpl;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.ProcessMonitor;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.Value;
import org.exist.storage.index.CollectionStore;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.serializers.ChainOfReceiversFactory;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.UTF8;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.DateTimeValue;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SystemExport {
    public static final Logger LOG = LogManager.getLogger(SystemExport.class);
    private static final XmldbURI TEMP_COLLECTION = XmldbURI.createInternal("/db/system/temp");
    private static final XmldbURI CONTENTS_URI = XmldbURI.createInternal("__contents__.xml");
    private static final XmldbURI LOST_URI = XmldbURI.createInternal("__lost_and_found__");
    public static final String CONFIGURATION_ELEMENT = "backup-filter";
    public static final String CONFIG_FILTERS = "backup.serialization.filters";
    private static final int currVersion = 1;
    private final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyyMMddHHmmssS");
    private int collectionCount = -1;
    public Properties defaultOutputProperties = new Properties();
    public Properties contentsOutputProps = new Properties();
    private DBBroker broker;
    private StatusCallback callback = null;
    private boolean directAccess = false;
    private ProcessMonitor.Monitor monitor = null;
    private BackupHandler bh = null;
    private ChainOfReceiversFactory chainFactory;

    public SystemExport(DBBroker broker, StatusCallback callback, ProcessMonitor.Monitor monitor, boolean direct, ChainOfReceiversFactory chainFactory) {
        this.defaultOutputProperties.setProperty("indent", "no");
        this.defaultOutputProperties.setProperty("encoding", "UTF-8");
        this.defaultOutputProperties.setProperty("omit-xml-declaration", "no");
        this.defaultOutputProperties.setProperty("expand-xincludes", "no");
        this.defaultOutputProperties.setProperty("process-xsl-pi", "no");
        this.contentsOutputProps.setProperty("indent", "yes");
        this.broker = broker;
        this.callback = callback;
        this.monitor = monitor;
        this.directAccess = direct;
        this.chainFactory = chainFactory;
        this.bh = broker.getDatabase().getPluginsManager().getBackupHandler(LOG);
    }

    public SystemExport(DBBroker broker, StatusCallback callback, ProcessMonitor.Monitor monitor, boolean direct) {
        this(broker, callback, monitor, direct, null);
        List list = (List)broker.getConfiguration().getProperty(CONFIG_FILTERS);
        if (list != null) {
            this.chainFactory = new ChainOfReceiversFactory(list);
        }
    }

    public Path export(String targetDir, boolean incremental, boolean zip, List<ErrorReport> errorList) {
        return this.export(targetDir, incremental, -1, zip, errorList);
    }

    public Path export(String targetDir, boolean incremental, int maxInc, boolean zip, List<ErrorReport> errorList) {
        Path backupFile = null;
        try {
            BackupDirectory directory = new BackupDirectory(targetDir);
            BackupDescriptor prevBackup = null;
            if (incremental) {
                prevBackup = directory.lastBackupFile();
                LOG.info("Creating incremental backup. Prev backup: " + (prevBackup == null ? "none" : prevBackup.getSymbolicPath()));
            }
            Properties properties = new Properties();
            int seqNr = 1;
            if (incremental) {
                Properties prevProp;
                properties.setProperty("previous", prevBackup == null ? "" : prevBackup.getName());
                if (prevBackup != null && (prevProp = prevBackup.getProperties()) != null) {
                    String seqNrStr = prevProp.getProperty("nr-in-sequence", "1");
                    try {
                        seqNr = Integer.parseInt(seqNrStr);
                        if (seqNr == maxInc) {
                            seqNr = 1;
                            incremental = false;
                            prevBackup = null;
                        } else {
                            ++seqNr;
                        }
                    }
                    catch (NumberFormatException e) {
                        LOG.warn("Bad sequence number in backup descriptor: " + prevBackup.getName());
                    }
                }
            }
            properties.setProperty("nr-in-sequence", Integer.toString(seqNr));
            properties.setProperty("incremental", incremental ? "yes" : "no");
            try {
                properties.setProperty("date", new DateTimeValue(new Date()).getStringValue());
            }
            catch (XPathException prevProp) {
                // empty catch block
            }
            backupFile = directory.createBackup(incremental && prevBackup != null, zip);
            FunctionE fWriter = zip ? p -> new ZipWriter((Path)p, "/db") : FileSystemWriter::new;
            try (BackupWriter output = (BackupWriter)fWriter.apply((Object)backupFile);){
                output.setProperties(properties);
                Date date = prevBackup == null ? null : prevBackup.getDate();
                CollectionCallback cb = new CollectionCallback(output, date, prevBackup, errorList, true);
                this.broker.getCollectionsFailsafe(cb);
                this.exportOrphans(output, cb.getDocs(), errorList);
            }
            return backupFile;
        }
        catch (IOException e) {
            this.reportError("A write error occurred while exporting data: '" + e.getMessage() + "'. Aborting export.", e);
            return null;
        }
        catch (TerminatedException e) {
            if (backupFile != null) {
                FileUtils.deleteQuietly(backupFile);
            }
            return null;
        }
    }

    private void reportError(String message, Throwable e) {
        if (this.callback != null) {
            this.callback.error("EXPORT: " + message, e);
        }
        LOG.error("EXPORT: " + message, e);
    }

    private static boolean isDamaged(DocumentImpl doc, List<ErrorReport> errorList) {
        if (errorList == null) {
            return false;
        }
        for (ErrorReport report : errorList) {
            if (report.getErrcode() != 5 || ((ErrorReport.ResourceError)report).getDocumentId() != doc.getDocId()) continue;
            return true;
        }
        return false;
    }

    private static boolean isDamaged(Collection collection, List<ErrorReport> errorList) {
        if (errorList == null) {
            return false;
        }
        for (ErrorReport report : errorList) {
            if (report.getErrcode() != 4 || ((ErrorReport.CollectionError)report).getCollectionId() != collection.getId()) continue;
            return true;
        }
        return false;
    }

    private static boolean isDamagedChild(XmldbURI uri, List<ErrorReport> errorList) {
        if (errorList == null) {
            return false;
        }
        for (ErrorReport report : errorList) {
            if (report.getErrcode() != 4 || !((ErrorReport.CollectionError)report).getCollectionURI().equalsInternal(uri)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportOrphans(BackupWriter output, DocumentSet docs, List<ErrorReport> errorList) throws IOException {
        output.newCollection("/db/__lost_and_found__");
        try (Writer contents = output.newContents();){
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput(contents, this.contentsOutputProps);
            serializer.startDocument();
            serializer.startPrefixMapping("", "http://exist.sourceforge.net/NS/exist");
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", "/db/__lost_and_found__");
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "version", "version", "CDATA", String.valueOf(1));
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "owner", "owner", "CDATA", "admin");
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "group", "group", "CDATA", "dba");
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mode", "mode", "CDATA", "0771");
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "collection", attr);
            DocumentCallback docCb = new DocumentCallback(output, serializer, null, null, docs, true);
            this.broker.getResourcesFailsafe(docCb, this.directAccess);
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "collection");
            serializer.endPrefixMapping("");
            serializer.endDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.callback != null) {
                this.callback.error(e.getMessage(), e);
            }
        }
        finally {
            output.closeCollection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(BackupHandler bh, Collection current, BackupWriter output, Date date, BackupDescriptor prevBackup, List<ErrorReport> errorList, MutableDocumentSet docs) throws IOException, SAXException, TerminatedException, PermissionDeniedException {
        if (this.monitor != null && !this.monitor.proceed()) {
            throw new TerminatedException("system export terminated by db");
        }
        output.newCollection(Backup.encode(URIUtils.urlDecodeUtf8(current.getURI())));
        try {
            Writer contents = output.newContents();
            SAXSerializer serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput(contents, this.contentsOutputProps);
            Permission perm = current.getPermissionsNoLock();
            serializer.startDocument();
            serializer.startPrefixMapping("", "http://exist.sourceforge.net/NS/exist");
            XmldbURI uri = current.getURI();
            AttributesImpl attr = new AttributesImpl();
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", uri.toString());
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "version", "version", "CDATA", String.valueOf(1));
            Backup.writeUnixStylePermissionAttributes(attr, perm);
            try {
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "created", "created", "CDATA", new DateTimeValue(new Date(current.getCreationTime())).getStringValue());
            }
            catch (XPathException e) {
                e.printStackTrace();
            }
            bh.backup(current, attr);
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "collection", attr);
            if (perm instanceof ACLPermission) {
                Backup.writeACLPermission(serializer, (ACLPermission)((Object)perm));
            }
            bh.backup(current, serializer);
            int docsCount = current.getDocumentCountNoLock(this.broker);
            int count = 0;
            Iterator<Comparable<DocumentImpl>> i = current.iteratorNoLock(this.broker);
            while (i.hasNext()) {
                DocumentImpl doc = i.next();
                if (SystemExport.isDamaged(doc, errorList)) {
                    this.reportError("Skipping damaged document " + doc.getFileURI(), null);
                } else if (!doc.getFileURI().equalsInternal(CONTENTS_URI) && !doc.getFileURI().equalsInternal(LOST_URI)) {
                    this.exportDocument(bh, output, date, prevBackup, serializer, docsCount, count, doc);
                    docs.add(doc, false);
                }
                ++count;
            }
            i = current.collectionIteratorNoLock(this.broker);
            while (i.hasNext()) {
                XmldbURI childUri = (XmldbURI)i.next();
                if (childUri.equalsInternal(TEMP_COLLECTION)) continue;
                if (SystemExport.isDamagedChild(childUri, errorList)) {
                    this.reportError("Skipping damaged child collection " + childUri, null);
                    continue;
                }
                attr.clear();
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", childUri.toString());
                attr.addAttribute("http://exist.sourceforge.net/NS/exist", "filename", "filename", "CDATA", Backup.encode(URIUtils.urlDecodeUtf8(childUri.toString())));
                serializer.startElement("http://exist.sourceforge.net/NS/exist", "subcollection", "subcollection", attr);
                serializer.endElement("http://exist.sourceforge.net/NS/exist", "subcollection", "subcollection");
            }
            if (prevBackup != null) {
                CheckDeletedHandler check = new CheckDeletedHandler(current, serializer);
                try {
                    prevBackup.parse(check);
                }
                catch (Exception e) {
                    LOG.error("Caught exception while trying to parse previous backup descriptor: " + prevBackup.getSymbolicPath(), (Throwable)e);
                }
            }
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "collection");
            serializer.endPrefixMapping("");
            serializer.endDocument();
            output.closeContents();
        }
        finally {
            output.closeCollection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDocument(BackupHandler bh, BackupWriter output, Date date, BackupDescriptor prevBackup, SAXSerializer serializer, int docsCount, int count, DocumentImpl doc) throws IOException, SAXException, TerminatedException {
        boolean needsBackup;
        block22: {
            if (this.callback != null) {
                this.callback.startDocument(doc.getFileURI().toString(), count, docsCount);
            }
            if (this.monitor != null && !this.monitor.proceed()) {
                throw new TerminatedException("system export terminated by db");
            }
            boolean bl = needsBackup = prevBackup == null || date.getTime() < doc.getMetadata().getLastModified();
            if (needsBackup) {
                try {
                    OutputStream os = output.newEntry(Backup.encode(URIUtils.urlDecodeUtf8(doc.getFileURI())));
                    if (doc.getResourceType() == 1) {
                        this.broker.readBinaryResource((BinaryDocument)doc, os);
                        break block22;
                    }
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
                    try {
                        Receiver receiver;
                        SAXSerializer contentSerializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                        contentSerializer.setOutput(writer, this.defaultOutputProperties);
                        if (this.chainFactory != null) {
                            this.chainFactory.getLast().setNextInChain(contentSerializer);
                            receiver = this.chainFactory.getFirst();
                        } else {
                            receiver = contentSerializer;
                        }
                        this.writeXML(doc, receiver);
                        SerializerPool.getInstance().returnObject(contentSerializer);
                    }
                    finally {
                        ((Writer)writer).flush();
                    }
                }
                catch (Exception e) {
                    this.reportError("A write error occurred while exporting document: '" + doc.getFileURI() + "'. Continuing with next document.", e);
                    return;
                }
                finally {
                    output.closeEntry();
                }
            }
        }
        Permission perms = doc.getPermissions();
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "type", "type", "CDATA", doc.getResourceType() == 1 ? "BinaryResource" : "XMLResource");
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", doc.getFileURI().toString());
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "skip", "skip", "CDATA", needsBackup ? "no" : "yes");
        Backup.writeUnixStylePermissionAttributes(attr, perms);
        DocumentMetadata metadata = null;
        try {
            metadata = doc.getMetadata();
        }
        catch (Exception receiver) {
            // empty catch block
        }
        try {
            String modified;
            String created;
            if (metadata != null) {
                created = new DateTimeValue(new Date(metadata.getCreated())).getStringValue();
                modified = new DateTimeValue(new Date(metadata.getLastModified())).getStringValue();
            } else {
                modified = created = new DateTimeValue().getStringValue();
            }
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "created", "created", "CDATA", created);
            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "modified", "modified", "CDATA", modified);
        }
        catch (XPathException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "filename", "filename", "CDATA", Backup.encode(URIUtils.urlDecodeUtf8(doc.getFileURI())));
        String mimeType = "application/xml";
        if (metadata != null && metadata.getMimeType() != null) {
            mimeType = Backup.encode(metadata.getMimeType());
        }
        attr.addAttribute("http://exist.sourceforge.net/NS/exist", "mimetype", "mimetype", "CDATA", mimeType);
        bh.backup((Document)doc, attr);
        serializer.startElement("http://exist.sourceforge.net/NS/exist", "resource", "resource", attr);
        if (perms instanceof ACLPermission) {
            Backup.writeACLPermission(serializer, (ACLPermission)((Object)perms));
        }
        bh.backup((Document)doc, serializer);
        serializer.endElement("http://exist.sourceforge.net/NS/exist", "resource", "resource");
    }

    private void writeXML(DocumentImpl doc, Receiver receiver) {
        try {
            NamespaceSupport nsSupport = new NamespaceSupport();
            NodeList children = doc.getChildNodes();
            DocumentType docType = doc.getDoctype();
            if (docType != null) {
                receiver.documentType(docType.getName(), docType.getPublicId(), docType.getSystemId());
            }
            for (int i = 0; i < children.getLength(); ++i) {
                StoredNode child = (StoredNode)children.item(i);
                IEmbeddedXMLStreamReader reader = this.broker.getXMLStreamReader(child, false);
                while (reader.hasNext()) {
                    int status = reader.next();
                    switch (status) {
                        case 7: 
                        case 8: {
                            break;
                        }
                        case 1: {
                            int nsdecls = reader.getNamespaceCount();
                            for (int ni = 0; ni < nsdecls; ++ni) {
                                receiver.startPrefixMapping(reader.getNamespacePrefix(ni), reader.getNamespaceURI(ni));
                            }
                            AttrList attribs = new AttrList();
                            for (int j = 0; j < reader.getAttributeCount(); ++j) {
                                QName qn = new QName(reader.getAttributeLocalName(j), reader.getAttributeNamespace(j), reader.getAttributePrefix(j));
                                attribs.addAttribute(qn, reader.getAttributeValue(j));
                            }
                            receiver.startElement(new QName(reader.getLocalName(), reader.getNamespaceURI(), reader.getPrefix()), attribs);
                            break;
                        }
                        case 2: {
                            receiver.endElement(new QName(reader.getLocalName(), reader.getNamespaceURI(), reader.getPrefix()));
                            int nsdecls = reader.getNamespaceCount();
                            for (int ni = 0; ni < nsdecls; ++ni) {
                                receiver.endPrefixMapping(reader.getNamespacePrefix(ni));
                            }
                            break;
                        }
                        case 4: {
                            receiver.characters(reader.getText());
                            break;
                        }
                        case 12: {
                            char[] ch = reader.getTextCharacters();
                            receiver.cdataSection(ch, 0, ch.length);
                            break;
                        }
                        case 5: {
                            char[] ch = reader.getTextCharacters();
                            receiver.comment(ch, 0, ch.length);
                            break;
                        }
                        case 3: {
                            receiver.processingInstruction(reader.getPITarget(), reader.getPIData());
                        }
                    }
                    if (child.getNodeType() != 8 && child.getNodeType() != 7) continue;
                    break;
                }
                nsSupport.reset();
            }
        }
        catch (IOException | XMLStreamException | SAXException e) {
            e.printStackTrace();
        }
    }

    public static Path getUniqueFile(String base, String extension, String dir) {
        SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyyMMddHHmmssS");
        String filename = base + '-' + creationDateFormat.format(Calendar.getInstance().getTime());
        Path file = Paths.get(dir, filename + extension);
        int version = 0;
        while (Files.exists(file, new LinkOption[0])) {
            file = Paths.get(dir, filename + '_' + version++ + extension);
        }
        return file;
    }

    public int getCollectionCount() throws TerminatedException {
        if (this.collectionCount == -1) {
            AccountImpl.getSecurityProperties().enableCheckPasswords(false);
            try {
                CollectionCallback cb = new CollectionCallback(null, null, null, null, false);
                this.broker.getCollectionsFailsafe(cb);
                this.collectionCount = cb.collectionCount;
            }
            finally {
                AccountImpl.getSecurityProperties().enableCheckPasswords(true);
            }
        }
        return this.collectionCount;
    }

    private class CheckDeletedHandler
    extends DefaultHandler {
        private Collection collection;
        private SAXSerializer serializer;

        private CheckDeletedHandler(Collection collection, SAXSerializer serializer) {
            this.collection = collection;
            this.serializer = serializer;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (uri.equals("http://exist.sourceforge.net/NS/exist")) {
                try {
                    if ("subcollection".equals(localName)) {
                        String name = attributes.getValue("filename");
                        if (name == null) {
                            name = attributes.getValue("name");
                        }
                        if (!this.collection.hasChildCollection(SystemExport.this.broker, XmldbURI.create(name))) {
                            AttributesImpl attr = new AttributesImpl();
                            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", name);
                            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "type", "type", "CDATA", "collection");
                            this.serializer.startElement("http://exist.sourceforge.net/NS/exist", "deleted", "deleted", attr);
                            this.serializer.endElement("http://exist.sourceforge.net/NS/exist", "deleted", "deleted");
                        }
                    } else if ("resource".equals(localName)) {
                        String name = attributes.getValue("name");
                        if (!this.collection.hasDocument(SystemExport.this.broker, XmldbURI.create(name))) {
                            AttributesImpl attr = new AttributesImpl();
                            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "name", "name", "CDATA", name);
                            attr.addAttribute("http://exist.sourceforge.net/NS/exist", "type", "type", "CDATA", "resource");
                            this.serializer.startElement("http://exist.sourceforge.net/NS/exist", "deleted", "deleted", attr);
                            this.serializer.endElement("http://exist.sourceforge.net/NS/exist", "deleted", "deleted");
                        }
                    }
                }
                catch (PermissionDeniedException | LockException e) {
                    throw new SAXException("Unable to process :" + qName + ": " + e.getMessage(), e);
                }
            }
        }
    }

    private class DocumentCallback
    implements BTreeCallback {
        private DocumentSet exportedDocs;
        private Set<String> writtenDocs = null;
        private SAXSerializer serializer;
        private BackupWriter output;
        private Date date;
        private BackupDescriptor prevBackup;

        private DocumentCallback(BackupWriter output, SAXSerializer serializer, Date date, BackupDescriptor prevBackup, DocumentSet exportedDocs, boolean checkNames) {
            this.exportedDocs = exportedDocs;
            this.serializer = serializer;
            this.output = output;
            this.date = date;
            this.prevBackup = prevBackup;
            if (checkNames) {
                this.writtenDocs = new TreeSet<String>();
            }
        }

        @Override
        public boolean indexInfo(Value key, long pointer) throws TerminatedException {
            CollectionStore store = (CollectionStore)((NativeBroker)SystemExport.this.broker).getStorage((byte)0);
            int docId = CollectionStore.DocumentKey.getDocumentId(key);
            if (!this.exportedDocs.contains(docId)) {
                try {
                    byte type = key.data()[key.start() + 4 + 1];
                    VariableByteInput istream = store.getAsStream(pointer);
                    DocumentImpl doc = null;
                    doc = type == 1 ? new BinaryDocument(SystemExport.this.broker.getBrokerPool()) : new DocumentImpl(SystemExport.this.broker.getBrokerPool());
                    doc.read(istream);
                    SystemExport.this.reportError("Found an orphaned document: " + doc.getFileURI().toString(), null);
                    if (this.writtenDocs != null) {
                        String fileURI;
                        int count = 1;
                        String origURI = fileURI = doc.getFileURI().toString();
                        while (this.writtenDocs.contains(fileURI)) {
                            fileURI = origURI + "." + count++;
                        }
                        doc.setFileURI(XmldbURI.createInternal(fileURI));
                        this.writtenDocs.add(fileURI);
                    }
                    SystemExport.this.exportDocument(SystemExport.this.bh, this.output, this.date, this.prevBackup, this.serializer, 0, 0, doc);
                }
                catch (Exception e) {
                    SystemExport.this.reportError("Caught an exception while scanning documents: " + e.getMessage(), e);
                }
            }
            return true;
        }
    }

    private class CollectionCallback
    implements BTreeCallback {
        private BackupWriter writer;
        private BackupDescriptor prevBackup;
        private Date date;
        private List<ErrorReport> errors;
        private MutableDocumentSet docs = new DefaultDocumentSet();
        private int collectionCount = 0;
        private boolean exportCollection;
        private int lastPercentage = -1;
        private Agent jmxAgent = AgentFactory.getInstance();

        private CollectionCallback(BackupWriter writer, Date date, BackupDescriptor prevBackup, List<ErrorReport> errorList, boolean exportCollection) {
            this.writer = writer;
            this.errors = errorList;
            this.date = date;
            this.prevBackup = prevBackup;
            this.exportCollection = exportCollection;
        }

        @Override
        public boolean indexInfo(Value value, long pointer) throws TerminatedException {
            String uri = null;
            try {
                ++this.collectionCount;
                if (this.exportCollection) {
                    CollectionStore store = (CollectionStore)((NativeBroker)SystemExport.this.broker).getStorage((byte)0);
                    uri = UTF8.decode(value.data(), value.start() + 1, value.getLength() - 1).toString();
                    if ("__next_collection_id".equals(uri) || "__next_doc_id".equals(uri) || "__free_collection_id".equals(uri) || "__free_doc_id".equals(uri)) {
                        return true;
                    }
                    if (SystemExport.this.callback != null) {
                        SystemExport.this.callback.startCollection(uri);
                    }
                    VariableByteInput istream = store.getAsStream(pointer);
                    MutableCollection collection = MutableCollection.load(SystemExport.this.broker, XmldbURI.createInternal(uri), istream);
                    BackupDescriptor bd = null;
                    if (this.prevBackup != null) {
                        bd = this.prevBackup.getBackupDescriptor(uri);
                    }
                    int percentage = 100 * (this.collectionCount + 1) / (SystemExport.this.getCollectionCount() + 1);
                    if (this.jmxAgent != null && percentage != this.lastPercentage) {
                        this.lastPercentage = percentage;
                        this.jmxAgent.updateStatus(SystemExport.this.broker.getBrokerPool(), percentage);
                    }
                    SystemExport.this.export(SystemExport.this.bh, collection, this.writer, this.date, bd, this.errors, this.docs);
                }
            }
            catch (TerminatedException e) {
                SystemExport.this.reportError("Terminating system export upon request", e);
                throw e;
            }
            catch (Exception e) {
                SystemExport.this.reportError("Caught exception while scanning collections: " + uri, e);
            }
            return true;
        }

        public DocumentSet getDocs() {
            return this.docs;
        }
    }

    public static interface StatusCallback {
        public void startCollection(String var1) throws TerminatedException;

        public void startDocument(String var1, int var2, int var3) throws TerminatedException;

        public void error(String var1, Throwable var2);
    }
}

