/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.FileSystemBackupDescriptor;
import org.exist.backup.ZipArchiveBackupDescriptor;
import org.exist.backup.restore.SystemImportHandler;
import org.exist.backup.restore.listener.RestoreListener;
import org.exist.config.ConfigurationException;
import org.exist.security.AuthenticationException;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.util.EXistInputSource;
import org.exist.util.FileUtils;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xmldb.api.base.XMLDBException;

public class SystemImport {
    public static final Logger LOG = LogManager.getLogger(SystemImport.class);
    private Database db;

    public SystemImport(Database db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(RestoreListener listener, String username, Object credentials, String newCredentials, Path f, String uri) throws XMLDBException, IOException, SAXException, ParserConfigurationException, URISyntaxException, AuthenticationException, ConfigurationException, PermissionDeniedException {
        try (DBBroker broker = this.db.authenticate(username, credentials);){
            this.setAdminCredentials(broker, newCredentials);
            Stack<BackupDescriptor> descriptors = this.getBackupDescriptors(f);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setValidating(false);
            SAXParser sax = saxFactory.newSAXParser();
            XMLReader reader = sax.getXMLReader();
            try {
                listener.restoreStarting();
                while (!descriptors.isEmpty()) {
                    BackupDescriptor descriptor = descriptors.pop();
                    EXistInputSource is = descriptor.getInputSource();
                    is.setEncoding("UTF-8");
                    SystemImportHandler handler = new SystemImportHandler(broker, listener, uri, descriptor);
                    reader.setContentHandler(handler);
                    reader.parse(is);
                }
            }
            finally {
                listener.restoreFinished();
            }
        }
    }

    private Stack<BackupDescriptor> getBackupDescriptors(Path contents) throws XMLDBException, IOException {
        Stack<BackupDescriptor> descriptors = new Stack<BackupDescriptor>();
        do {
            String previous;
            BackupDescriptor bd = this.getBackupDescriptor(contents);
            descriptors.push(bd);
            BackupDescriptor sysDescriptor = bd.getChildBackupDescriptor("system");
            if (sysDescriptor != null) {
                descriptors.push(sysDescriptor);
                BackupDescriptor secDescriptor = sysDescriptor.getChildBackupDescriptor("security");
                if (secDescriptor != null) {
                    descriptors.push(secDescriptor);
                }
            }
            contents = null;
            Properties properties = bd.getProperties();
            if (properties == null || !"yes".equals(properties.getProperty("incremental", "no")) || (previous = properties.getProperty("previous", "")).length() <= 0 || Files.isReadable(contents = bd.getParentDir().resolve(previous))) continue;
            throw new XMLDBException(4, "Required part of incremental backup not found: " + contents.toAbsolutePath().toString());
        } while (contents != null);
        return descriptors;
    }

    private BackupDescriptor getBackupDescriptor(Path f) throws IOException {
        AbstractBackupDescriptor bd = Files.isDirectory(f, new LinkOption[0]) ? new FileSystemBackupDescriptor(f.resolve("db").resolve("__contents__.xml")) : (FileUtils.fileName(f).toLowerCase().endsWith(".zip") ? new ZipArchiveBackupDescriptor(f) : new FileSystemBackupDescriptor(f));
        return bd;
    }

    private void setAdminCredentials(DBBroker broker, String newCredentials) throws ConfigurationException, PermissionDeniedException {
        Subject subject = broker.getCurrentSubject();
        subject.setPassword(newCredentials);
        subject.save(broker);
    }
}

