/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.exist.backup.BackupWriter;

public class ZipWriter
implements BackupWriter {
    private String currentPath;
    private ZipOutputStream out;
    private StringWriter contents;
    private boolean dataWritten = false;

    public ZipWriter(String zipFile, String collection) throws IOException {
        this(Paths.get(zipFile, new String[0]), collection);
    }

    public ZipWriter(Path zipFile, String collection) throws IOException {
        this.out = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));
        this.currentPath = collection;
    }

    @Override
    public Writer newContents() throws IOException {
        this.contents = new StringWriter();
        return this.contents;
    }

    @Override
    public void closeContents() throws IOException {
        ZipEntry entry = new ZipEntry(this.mkRelative(this.currentPath) + "/__contents__.xml");
        this.out.putNextEntry(entry);
        try {
            this.out.write(this.contents.toString().getBytes("UTF-8"));
        }
        finally {
            this.out.closeEntry();
        }
        this.dataWritten = true;
    }

    @Override
    public OutputStream newEntry(String name) throws IOException {
        ZipEntry entry = new ZipEntry(this.mkRelative(this.currentPath) + '/' + name);
        this.out.putNextEntry(entry);
        this.dataWritten = true;
        return this.out;
    }

    @Override
    public void closeEntry() throws IOException {
        this.out.closeEntry();
    }

    @Override
    public void newCollection(String name) {
        this.currentPath = name.startsWith("/") ? name : this.currentPath + '/' + name;
    }

    @Override
    public void closeCollection() {
        int p = this.currentPath.lastIndexOf(47);
        if (p > 0) {
            this.currentPath = this.currentPath.substring(0, p);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void setProperties(Properties properties) throws IOException {
        if (this.dataWritten) {
            throw new IOException("Backup properties need to be set before any backup data is written");
        }
        ZipEntry entry = new ZipEntry("backup.properties");
        this.out.putNextEntry(entry);
        try {
            properties.store(this.out, "Backup properties");
        }
        finally {
            this.out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToRoot(String name, Path file) throws IOException {
        if (this.dataWritten) {
            throw new IOException("Additional files have to be added before backup data is written");
        }
        ZipEntry entry = new ZipEntry(name);
        this.out.putNextEntry(entry);
        try {
            Files.copy(file, this.out);
        }
        finally {
            this.out.closeEntry();
        }
    }

    private String mkRelative(String path) {
        if (path.length() > 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }
}

