/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.restore;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.restore.AbstractDeferredPermission;
import org.exist.backup.restore.listener.RestoreListener;
import org.exist.security.Permission;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

class ResourceDeferredPermission
extends AbstractDeferredPermission<Resource> {
    private static final Logger LOG = LogManager.getLogger(ResourceDeferredPermission.class);

    public ResourceDeferredPermission(RestoreListener listener, Resource resource, String owner, String group, Integer mode) {
        super(listener, resource, owner, group, mode);
    }

    @Override
    public void apply() {
        try {
            UserManagementService service = (UserManagementService)((Resource)this.getTarget()).getParentCollection().getService("UserManagementService", "1.0");
            Permission permissions = service.getPermissions((Resource)this.getTarget());
            service.setPermissions((Resource)this.getTarget(), this.getOwner(), this.getGroup(), this.getMode(), this.getAces());
        }
        catch (XMLDBException xe) {
            String name = "unknown";
            try {
                name = ((Resource)this.getTarget()).getId();
            }
            catch (XMLDBException x) {
                LOG.error(x.getMessage(), (Throwable)x);
            }
            String msg = "ERROR: Failed to set permissions on Document '" + name + "'.";
            LOG.error(msg, (Throwable)xe);
            this.getListener().warn(msg);
        }
    }
}

