/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.restore.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.exist.backup.restore.listener.RestoreListener;

public abstract class AbstractRestoreListener
implements RestoreListener {
    private final List<Problem> problems = new ArrayList<Problem>();
    private String currentCollectionName;
    private String currentResourceName;
    private List<Observable> observables;

    @Override
    public void restoreStarting() {
        this.info("Starting restore of backup...");
    }

    @Override
    public void restoreFinished() {
        this.info("Finished restore of backup.");
    }

    @Override
    public void createCollection(String collection) {
        this.info("Creating collection " + collection);
    }

    @Override
    public void setCurrentBackup(String currentBackup) {
        this.info("Processing backup: " + currentBackup);
    }

    @Override
    public void setCurrentCollection(String currentCollectionName) {
        this.currentCollectionName = currentCollectionName;
    }

    @Override
    public void setCurrentResource(String currentResourceName) {
        this.currentResourceName = currentResourceName;
    }

    @Override
    public void observe(Observable observable) {
        if (this.observables == null) {
            this.observables = new ArrayList<Observable>();
        }
        if (!this.observables.contains(observable)) {
            this.observables.add(observable);
        }
    }

    @Override
    public void restored(String resource) {
        this.info("Restored " + resource);
    }

    @Override
    public void warn(String message) {
        this.problems.add(new Warning(message));
    }

    @Override
    public void error(String message) {
        this.problems.add(new Error(message));
    }

    @Override
    public boolean hasProblems() {
        return this.problems.size() > 0;
    }

    @Override
    public String warningsAndErrorsAsString() {
        StringBuilder builder = new StringBuilder();
        builder.append("------------------------------------\n");
        builder.append("Problems occured found during restore:\n");
        for (Problem problem : this.problems) {
            builder.append(problem.toString());
            builder.append(System.getProperty("line.separator"));
        }
        return builder.toString();
    }

    private class Warning
    extends Problem {
        public Warning(String message) {
            super(message);
        }

        public String toString() {
            return "WARN: " + this.getMessage();
        }
    }

    private class Error
    extends Problem {
        public Error(String message) {
            super(message);
        }

        public String toString() {
            return "ERROR: " + this.getMessage();
        }
    }

    private abstract class Problem {
        private final String message;

        public Problem(String message) {
            this.message = message;
        }

        protected String getMessage() {
            return this.message;
        }
    }
}

