/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup.xquery;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.exist.backup.ZipArchiveBackupDescriptor;
import org.exist.dom.QName;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.util.FileUtils;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.response.ResponseModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class RetrieveBackup
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("retrieve", "http://exist-db.org/xquery/backups", "backups"), "Retrieves a zipped backup archive, $name, and directly streams it to the HTTP response. For security reasons, the function will only read .zip files in the specified directory, $directory.", new SequenceType[]{new FunctionParameterSequenceType("directory", 22, 2, "The path to the directory where the backup file is located."), new FunctionParameterSequenceType("name", 22, 2, "The name of the file to retrieve.")}, new SequenceType(11, 1));

    public RetrieveBackup(XQueryContext context) {
        super(context, signature);
    }

    @Override
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String name;
        Path backupFile;
        if (!this.context.getEffectiveUser().hasDbaRole()) {
            throw new XPathException("You must be a DBA to retrieve a backup");
        }
        String exportDir = args[0].getStringValue();
        Path dir = Paths.get(exportDir, new String[0]);
        if (!dir.isAbsolute()) {
            dir = ((Path)this.context.getBroker().getConfiguration().getProperty("db-connection.data-dir")).resolve(exportDir);
        }
        if (!Files.isReadable(backupFile = dir.resolve(name = args[1].getStringValue()))) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (!name.endsWith(".zip")) {
            throw new XPathException((Expression)this, "for security reasons, the function only allows reading zipped backup archives");
        }
        try {
            ZipArchiveBackupDescriptor descriptor = new ZipArchiveBackupDescriptor(backupFile);
            Properties properties = descriptor.getProperties();
            if (properties == null || properties.size() == 0) {
                throw new XPathException((Expression)this, "the file does not see to be a valid backup archive");
            }
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "the file does not see to be a valid backup archive");
        }
        ResponseModule myModule = (ResponseModule)this.context.getModule("http://exist-db.org/xquery/response");
        Variable respVar = myModule.resolveVariable(ResponseModule.RESPONSE_VAR);
        if (respVar == null) {
            throw new XPathException((Expression)this, "No response object found in the current XQuery context.");
        }
        if (respVar.getValue().getItemType() != 100) {
            throw new XPathException((Expression)this, "Variable $response is not bound to an Java object.");
        }
        JavaObjectValue respValue = (JavaObjectValue)respVar.getValue().itemAt(0);
        if (!"org.exist.http.servlets.HttpResponseWrapper".equals(respValue.getObject().getClass().getName())) {
            throw new XPathException((Expression)this, signature.toString() + " can only be used within the EXistServlet or XQueryServlet");
        }
        ResponseWrapper response = (ResponseWrapper)respValue.getObject();
        response.setContentType("application/zip");
        response.setHeader("Content-Length", String.valueOf(FileUtils.sizeQuietly(backupFile)));
        try {
            try (OutputStream os = response.getOutputStream();){
                Files.copy(backupFile, os);
            }
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "An IO error occurred while reading the backup archive");
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

