/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.exist.SystemProperties;
import org.exist.backup.Backup;
import org.exist.backup.CreateBackupDialog;
import org.exist.backup.Restore;
import org.exist.backup.restore.listener.GuiRestoreListener;
import org.exist.client.BackupContentsFilter;
import org.exist.client.ConnectionDialog;
import org.exist.client.DefaultConnectionSettings;
import org.exist.client.DocumentView;
import org.exist.client.HighlightedTableCellRenderer;
import org.exist.client.IndexDialog;
import org.exist.client.InteractiveClient;
import org.exist.client.Messages;
import org.exist.client.NewResourceDialog;
import org.exist.client.PrettyXmldbURI;
import org.exist.client.QueryDialog;
import org.exist.client.ResourceDescriptor;
import org.exist.client.TriggersDialog;
import org.exist.client.UploadDialog;
import org.exist.client.ZipFilter;
import org.exist.client.security.EditPropertiesDialog;
import org.exist.client.security.UserManagerDialog;
import org.exist.security.ACLPermission;
import org.exist.security.Account;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.internal.aider.PermissionAider;
import org.exist.security.internal.aider.PermissionAiderFactory;
import org.exist.util.FileUtils;
import org.exist.util.MimeTable;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xmldb.EXistCollection;
import org.exist.xmldb.EXistCollectionManagementService;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.EXistXQueryService;
import org.exist.xmldb.ExtendedResource;
import org.exist.xmldb.IndexQueryService;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.util.URIUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class ClientFrame
extends JFrame
implements WindowFocusListener,
KeyListener,
ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String CUT = Messages.getString("ClientFrame.0");
    public static final String COPY = Messages.getString("ClientFrame.1");
    public static final String PASTE = Messages.getString("ClientFrame.2");
    public static final int MAX_DISPLAY_LENGTH = 512000;
    public static final int MAX_HISTORY = 50;
    private static final SimpleAttributeSet promptAttrs = new SimpleAttributeSet();
    private static final SimpleAttributeSet defaultAttrs = new SimpleAttributeSet();
    private int commandStart;
    private boolean gotUp;
    private DefaultStyledDocument doc;
    private JLabel statusbar;
    private JTable fileman;
    private final ResourceTableModel resources;
    private JTextPane shell;
    private JPopupMenu shellPopup;
    private final ProcessThread process;
    private Preferences preferences;
    private XmldbURI path;
    private Properties properties;
    private final InteractiveClient client;

    public ClientFrame(InteractiveClient client, XmldbURI path, Properties properties) throws HeadlessException {
        super(Messages.getString("ClientFrame.3"));
        StyleConstants.setForeground(promptAttrs, Color.blue);
        StyleConstants.setBold(promptAttrs, true);
        StyleConstants.setForeground(defaultAttrs, Color.black);
        this.commandStart = 0;
        this.gotUp = false;
        this.resources = new ResourceTableModel();
        this.process = new ProcessThread();
        this.path = null;
        this.path = path;
        this.properties = properties;
        this.client = client;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        this.setupComponents();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                ClientFrame.this.close();
            }
        });
        this.pack();
        this.process.start();
        this.shell.requestFocus();
        this.preferences = Preferences.userNodeForPackage(ClientFrame.class);
    }

    private void setupComponents() {
        this.setJMenuBar(this.createMenuBar());
        JToolBar toolbar = new JToolBar();
        URL url = this.getClass().getResource("icons/Up24.gif");
        JButton button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.5"));
        button.addActionListener(this::goUpAction);
        toolbar.add(button);
        url = this.getClass().getResource("icons/Refresh24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.7"));
        button.addActionListener(e -> {
            try {
                this.client.reloadCollection();
            }
            catch (XMLDBException xMLDBException) {
                // empty catch block
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/New24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.9"));
        button.addActionListener(this::newCollectionAction);
        toolbar.add(button);
        url = this.getClass().getResource("icons/Add24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.11"));
        button.addActionListener(this::uploadAction);
        toolbar.add(button);
        url = this.getClass().getResource("icons/Delete24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.13"));
        button.addActionListener(this::removeAction);
        toolbar.add(button);
        url = this.getClass().getResource(Messages.getString("ClientFrame.14"));
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.15"));
        button.addActionListener(e -> {
            try {
                this.setPermAction(e);
            }
            catch (PermissionDeniedException pde) {
                ClientFrame.showErrorMessage(pde.getMessage(), pde);
            }
        });
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Export24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.17"));
        button.addActionListener(this::backupAction);
        toolbar.add(button);
        url = this.getClass().getResource("icons/Import24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.19"));
        button.addActionListener(this::restoreAction);
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource(Messages.getString("ClientFrame.20"));
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.21"));
        button.addActionListener(this::editUsersAction);
        toolbar.add(button);
        url = this.getClass().getResource("icons/Find24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("ClientFrame.23"));
        button.addActionListener(this::findAction);
        toolbar.add(button);
        JSplitPane split = new JSplitPane(0);
        split.setResizeWeight(0.5);
        this.fileman = new JTable();
        this.fileman.setModel(this.resources);
        this.fileman.setRowSorter(new TableRowSorter<ResourceTableModel>(this.resources));
        this.fileman.addMouseListener(new TableMouseListener());
        this.fileman.setDropMode(DropMode.ON);
        DropTarget filemanDropTarget = new DropTarget(this.fileman, 1, new FileListDropTargetListener());
        this.fileman.setDropTarget(filemanDropTarget);
        this.fileman.setDefaultRenderer(Object.class, new HighlightedTableCellRenderer());
        JScrollPane scroll = new JScrollPane(this.fileman);
        scroll.setMinimumSize(new Dimension(300, 150));
        split.setLeftComponent(scroll);
        this.shellPopup = new JPopupMenu(Messages.getString("ClientFrame.24"));
        this.shellPopup.add(new JMenuItem(CUT)).addActionListener(this);
        this.shellPopup.add(new JMenuItem(COPY)).addActionListener(this);
        this.shellPopup.add(new JMenuItem(PASTE)).addActionListener(this);
        this.doc = new DefaultStyledDocument();
        this.shell = new JTextPane(this.doc);
        this.shell.setContentType("text/plain; charset=UTF-8");
        this.shell.setFont(new Font("Monospaced", 0, 12));
        this.shell.setMargin(new Insets(7, 5, 7, 5));
        this.shell.addKeyListener(this);
        this.shell.addMouseListener(this);
        scroll = new JScrollPane(this.shell);
        split.setRightComponent(scroll);
        this.statusbar = new JLabel(Messages.getString("ClientFrame.27") + this.properties.getProperty("user") + "@" + this.properties.getProperty("uri"));
        this.statusbar.setMinimumSize(new Dimension(400, 15));
        this.statusbar.setBorder(BorderFactory.createBevelBorder(1));
        this.getContentPane().add((Component)split, "Center");
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)this.statusbar, "South");
    }

    private JMenuBar createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu fileMenu = new JMenu(Messages.getString("ClientFrame.31"));
        fileMenu.setMnemonic(70);
        menubar.add(fileMenu);
        JMenuItem item = new JMenuItem(Messages.getString("ClientFrame.32"), 83);
        item.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::uploadAction);
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.34"), 78);
        item.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::newCollectionAction);
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.36"), 66);
        item.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::newBlankDocument);
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.40"));
        item.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::removeAction);
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.42"), 67);
        item.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::copyAction);
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.44"), 77);
        item.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::moveAction);
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.46"), 82);
        item.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::renameAction);
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.47"), 69);
        item.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::exportAction);
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.48"), 73);
        item.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::reindexAction);
        fileMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.50"));
        item.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(e -> {
            try {
                this.setPermAction(e);
            }
            catch (PermissionDeniedException pde) {
                ClientFrame.showErrorMessage(pde.getMessage(), pde);
            }
        });
        fileMenu.add(item);
        fileMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.52"), 81);
        item.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(e -> this.close());
        fileMenu.add(item);
        JMenu toolsMenu = new JMenu(Messages.getString("ClientFrame.54"));
        toolsMenu.setMnemonic(84);
        menubar.add(toolsMenu);
        item = new JMenuItem(Messages.getString("ClientFrame.55"), 70);
        item.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::findAction);
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.57"), 85);
        item.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::editUsersAction);
        toolsMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.60"), 84);
        item.setAccelerator(KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        item.addActionListener(this::editTriggersAction);
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.62a"));
        item.addActionListener(e -> {
            try {
                DatabaseInstanceManager service = (DatabaseInstanceManager)this.client.current.getService("DatabaseInstanceManager", "1.0");
                service.enterServiceMode();
            }
            catch (XMLDBException ex) {
                ClientFrame.showErrorMessage(ex.getMessage(), ex);
            }
        });
        toolsMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.62b"));
        item.addActionListener(e -> {
            try {
                DatabaseInstanceManager service = (DatabaseInstanceManager)this.client.current.getService("DatabaseInstanceManager", "1.0");
                service.exitServiceMode();
            }
            catch (XMLDBException ex) {
                ClientFrame.showErrorMessage(ex.getMessage(), ex);
            }
        });
        toolsMenu.add(item);
        toolsMenu.addSeparator();
        item = new JMenuItem(Messages.getString("ClientFrame.63"), 66);
        item.addActionListener(this::backupAction);
        toolsMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.64"), 82);
        item.addActionListener(this::restoreAction);
        toolsMenu.add(item);
        JMenu connectMenu = new JMenu(Messages.getString("ClientFrame.65"));
        connectMenu.setMnemonic(68);
        menubar.add(connectMenu);
        item = new JMenuItem(Messages.getString("ClientFrame.66"), 83);
        item.addActionListener(e -> {
            this.display(Messages.getString("ClientFrame.67"));
            this.process.setAction("shutdown");
        });
        connectMenu.add(item);
        item = new JMenuItem(Messages.getString("ClientFrame.69"), 85);
        item.setToolTipText(Messages.getString("ClientFrame.70"));
        item.addActionListener(e -> {
            Properties loginData = ClientFrame.getLoginData(this.properties);
            this.reconnectClient(loginData);
        });
        connectMenu.add(item);
        JMenu optionsMenu = new JMenu(Messages.getString("ClientFrame.80"));
        optionsMenu.setMnemonic(79);
        menubar.add(optionsMenu);
        JCheckBoxMenuItem check = new JCheckBoxMenuItem(Messages.getString("ClientFrame.81"), "yes".equals(this.properties.getProperty("indent")));
        check.addActionListener(e -> {
            this.properties.setProperty("indent", ((JCheckBoxMenuItem)e.getSource()).isSelected() ? "yes" : "no");
            try {
                this.client.getResources();
            }
            catch (XMLDBException xMLDBException) {
                // empty catch block
            }
        });
        optionsMenu.add(check);
        check = new JCheckBoxMenuItem(Messages.getString("ClientFrame.85"), "yes".equals(this.properties.getProperty("expand-xincludes")));
        check.addActionListener(e -> {
            this.properties.setProperty("expand-xincludes", ((JCheckBoxMenuItem)e.getSource()).isSelected() ? "yes" : "no");
            try {
                this.client.getResources();
            }
            catch (XMLDBException xMLDBException) {
                // empty catch block
            }
        });
        optionsMenu.add(check);
        JMenu HelpMenu = new JMenu(Messages.getString("ClientFrame.89"));
        HelpMenu.setMnemonic(72);
        menubar.add(HelpMenu);
        item = new JMenuItem(Messages.getString("ClientFrame.90"), 65);
        item.addActionListener(e -> this.AboutAction());
        HelpMenu.add(item);
        return menubar;
    }

    public void reconnectClient(Properties loginData) {
        if (loginData == null || loginData.isEmpty()) {
            return;
        }
        Properties oldProps = this.properties;
        this.properties.putAll((Map<?, ?>)loginData);
        this.statusbar.setText(Messages.getString("ClientFrame.71") + this.properties.getProperty("user") + "@" + this.properties.getProperty("uri"));
        try {
            this.client.shutdown(false);
            this.client.connect();
            this.client.reloadCollection();
        }
        catch (Exception u) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.75") + this.properties.getProperty("uri") + Messages.getString("ClientFrame.77"), u);
            this.properties = oldProps;
            try {
                this.client.connect();
            }
            catch (Exception uu) {
                ClientFrame.showErrorMessage(Messages.getString("ClientFrame.78") + this.properties.getProperty("uri"), uu);
            }
        }
    }

    public void setPath(XmldbURI currentPath) {
        this.path = currentPath;
    }

    protected void displayPrompt() {
        String pathString = this.path.getCollectionPath();
        try {
            this.commandStart = this.doc.getLength();
            this.doc.insertString(this.commandStart, Messages.getString("ClientFrame.91"), promptAttrs);
            this.commandStart += 6;
            this.doc.insertString(this.commandStart, pathString + '>', promptAttrs);
            this.commandStart += pathString.length() + 1;
            this.doc.insertString(this.commandStart++, Messages.getString("ClientFrame.92"), defaultAttrs);
            this.shell.setCaretPosition(this.commandStart);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void display(String message) {
        try {
            this.commandStart = this.doc.getLength();
            if (this.commandStart > 512000) {
                this.doc.remove(0, 512000);
                this.commandStart = this.doc.getLength();
            }
            this.doc.insertString(this.commandStart, message, defaultAttrs);
            this.commandStart = this.doc.getLength();
            this.shell.setCaretPosition(this.commandStart);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void setResources(List<ResourceDescriptor> rows) {
        this.resources.setData(rows);
    }

    protected void setStatus(String message) {
        this.statusbar.setText(message);
    }

    protected void setEditable(boolean enabled) {
        this.shell.setEditable(enabled);
        this.shell.setVisible(enabled);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.type(e);
        this.gotUp = false;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.gotUp = true;
        this.type(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.type(e);
    }

    private synchronized void type(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                if (e.getID() == 401 && this.gotUp) {
                    this.enter();
                }
                e.consume();
                break;
            }
            case 36: {
                this.shell.setCaretPosition(this.commandStart);
                e.consume();
                break;
            }
            case 8: 
            case 37: 
            case 127: {
                if (this.shell.getCaretPosition() > this.commandStart) break;
                e.consume();
                break;
            }
            case 38: {
                if (e.getID() == 401) {
                    this.historyBack();
                }
                e.consume();
                break;
            }
            case 40: {
                if (e.getID() == 401) {
                    this.historyForward();
                }
                e.consume();
                break;
            }
            default: {
                if ((e.getModifiers() & 0xE) == 0 && this.shell.getCaretPosition() < this.commandStart) {
                    this.shell.setCaretPosition(this.doc.getLength());
                }
                if (e.paramString().indexOf(Messages.getString("ClientFrame.93")) <= -1 || this.shell.getCaretPosition() > this.commandStart) break;
                e.consume();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(CUT)) {
            this.shell.cut();
        } else if (cmd.equals(COPY)) {
            this.shell.copy();
        } else if (cmd.equals(PASTE)) {
            this.shell.paste();
        }
    }

    private void newBlankDocument(ActionEvent e) {
        NewResourceDialog dialog = new NewResourceDialog(this.client);
        dialog.setVisible(true);
    }

    private void goUpAction(ActionEvent ev) {
        this.display(Messages.getString("ClientFrame.94"));
        this.process.setAction("cd ..");
    }

    private void newCollectionAction(ActionEvent ev) {
        String newCol = JOptionPane.showInputDialog(this, (Object)Messages.getString("ClientFrame.96"));
        if (newCol != null) {
            String command = "mkcol \"" + newCol + '\"';
            this.display(command + "\n");
            this.process.setAction(command);
        }
    }

    private ResourceDescriptor[] getSelectedResources() {
        int[] selectedRows = this.fileman.getSelectedRows();
        ResourceDescriptor[] res = new ResourceDescriptor[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            res[i] = this.resources.getRow(this.fileman.convertRowIndexToModel(selectedRows[i]));
        }
        return res;
    }

    private void removeAction(ActionEvent ev) {
        ResourceDescriptor[] res = this.getSelectedResources();
        Collection removeRootCollection = this.client.current;
        if (JOptionPane.showConfirmDialog(this, Messages.getString("ClientFrame.104") + Messages.getString("ClientFrame.105"), Messages.getString("ClientFrame.106"), 0) == 0) {
            Runnable removeTask = () -> {
                ProgressMonitor monitor = new ProgressMonitor(this, Messages.getString("ClientFrame.107"), Messages.getString("ClientFrame.108"), 1, res.length);
                monitor.setMillisToDecideToPopup(500);
                monitor.setMillisToPopup(500);
                for (int i = 0; i < res.length; ++i) {
                    ResourceDescriptor resource = res[i];
                    if (resource.isCollection()) {
                        try {
                            EXistCollectionManagementService mgtService = (EXistCollectionManagementService)removeRootCollection.getService("CollectionManagementService", "1.0");
                            mgtService.removeCollection(resource.getName());
                        }
                        catch (XMLDBException e) {
                            ClientFrame.showErrorMessage(e.getMessage(), e);
                        }
                    } else {
                        try {
                            Resource res1 = removeRootCollection.getResource(resource.getName().toString());
                            removeRootCollection.removeResource(res1);
                        }
                        catch (XMLDBException e) {
                            ClientFrame.showErrorMessage(e.getMessage(), e);
                        }
                    }
                    monitor.setProgress(i + 1);
                    if (!monitor.isCanceled()) continue;
                    return;
                }
                try {
                    removeRootCollection.close();
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(e.getMessage(), e);
                }
                try {
                    this.client.getResources();
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(e.getMessage(), e);
                }
            };
            new Thread(removeTask).start();
        }
    }

    private void moveAction(ActionEvent ev) {
        Object[] collections;
        ResourceDescriptor[] res = this.getSelectedResources();
        try {
            Collection root = this.client.getCollection("/db");
            ArrayList<PrettyXmldbURI> alCollections = this.getCollections(root, new ArrayList<PrettyXmldbURI>());
            collections = new PrettyXmldbURI[alCollections.size()];
            alCollections.toArray(collections);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(e.getMessage(), e);
            return;
        }
        Object val = JOptionPane.showInputDialog(this, Messages.getString("ClientFrame.111"), Messages.getString("ClientFrame.112"), 3, null, collections, collections[0]);
        if (val == null) {
            return;
        }
        XmldbURI destinationPath = ((PrettyXmldbURI)val).getTargetURI();
        Runnable moveTask = () -> {
            try {
                EXistCollectionManagementService service = (EXistCollectionManagementService)this.client.current.getService("CollectionManagementService", "1.0");
                for (int i = 0; i < res.length; ++i) {
                    this.setStatus(Messages.getString("ClientFrame.115") + res[i].getName() + Messages.getString("ClientFrame.116") + destinationPath + Messages.getString("ClientFrame.117"));
                    if (res[i].isCollection()) {
                        service.move(res[i].getName(), destinationPath, null);
                        continue;
                    }
                    service.moveResource(res[i].getName(), destinationPath, null);
                }
                this.client.reloadCollection();
            }
            catch (XMLDBException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
            this.setStatus(Messages.getString("ClientFrame.118"));
        };
        new Thread(moveTask).start();
    }

    private void renameAction(ActionEvent ev) {
        XmldbURI parseIt;
        ResourceDescriptor[] res = this.getSelectedResources();
        String inputValue = "";
        try {
            inputValue = res[0].getName().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object val = JOptionPane.showInputDialog(this, Messages.getString("ClientFrame.119"), Messages.getString("ClientFrame.120"), 3, null, null, inputValue);
        if (val == null) {
            return;
        }
        try {
            parseIt = URIUtils.encodeXmldbUriFor((String)val);
        }
        catch (URISyntaxException e) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.121") + e.getMessage(), e);
            return;
        }
        XmldbURI destinationFilename = parseIt;
        Runnable renameTask = () -> {
            try {
                EXistCollectionManagementService service = (EXistCollectionManagementService)this.client.current.getService("CollectionManagementService", "1.0");
                for (int i = 0; i < res.length; ++i) {
                    this.setStatus(Messages.getString("ClientFrame.124") + res[i].getName() + Messages.getString("ClientFrame.125") + destinationFilename + Messages.getString("ClientFrame.126"));
                    if (res[i].isCollection()) {
                        service.move(res[i].getName(), null, destinationFilename);
                        continue;
                    }
                    service.moveResource(res[i].getName(), null, destinationFilename);
                }
                this.client.reloadCollection();
            }
            catch (XMLDBException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
            this.setStatus(Messages.getString("ClientFrame.127"));
        };
        new Thread(renameTask).start();
    }

    private void copyAction(ActionEvent ev) {
        Object[] collections;
        ResourceDescriptor[] res = this.getSelectedResources();
        try {
            Collection root = this.client.getCollection("/db");
            ArrayList<PrettyXmldbURI> alCollections = this.getCollections(root, new ArrayList<PrettyXmldbURI>());
            collections = new PrettyXmldbURI[alCollections.size()];
            alCollections.toArray(collections);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(e.getMessage(), e);
            return;
        }
        Object val = JOptionPane.showInputDialog(this, Messages.getString("ClientFrame.128"), Messages.getString("ClientFrame.129"), 3, null, collections, collections[0]);
        if (val == null) {
            return;
        }
        XmldbURI destinationPath = ((PrettyXmldbURI)val).getTargetURI();
        Runnable moveTask = () -> {
            try {
                EXistCollectionManagementService service = (EXistCollectionManagementService)this.client.current.getService("CollectionManagementService", "1.0");
                for (int i = 0; i < res.length; ++i) {
                    this.setStatus(Messages.getString("ClientFrame.132") + res[i].getName() + Messages.getString("ClientFrame.133") + destinationPath + Messages.getString("ClientFrame.134"));
                    if (res[i].isCollection()) {
                        service.copy(res[i].getName(), destinationPath, null);
                        continue;
                    }
                    service.copyResource(res[i].getName(), destinationPath, null);
                }
                this.client.reloadCollection();
            }
            catch (XMLDBException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
            this.setStatus(Messages.getString("ClientFrame.135"));
        };
        new Thread(moveTask).start();
    }

    private ArrayList<PrettyXmldbURI> getCollections(Collection root, ArrayList<PrettyXmldbURI> collectionsList) throws XMLDBException {
        collectionsList.add(new PrettyXmldbURI(XmldbURI.create(root.getName())));
        String[] childCollections = root.listChildCollections();
        Collection child = null;
        for (int i = 0; i < childCollections.length; ++i) {
            try {
                child = root.getChildCollection(childCollections[i]);
            }
            catch (XMLDBException xmldbe) {
                if (xmldbe.getCause() instanceof PermissionDeniedException) continue;
                throw xmldbe;
            }
            catch (Exception npe) {
                System.out.println("Corrupted resource/collection skipped: " + child != null ? (child.getName() != null ? child.getName() : "unknown") : "unknown");
                continue;
            }
            try {
                this.getCollections(child, collectionsList);
                continue;
            }
            catch (Exception ee) {
                System.out.println("Corrupted resource/collection skipped: " + child != null ? (child.getName() != null ? child.getName() : "unknown") : "unknown");
            }
        }
        return collectionsList;
    }

    private void reindexAction(ActionEvent ev) {
        ResourceDescriptor[] res;
        int[] selRows = this.fileman.getSelectedRows();
        if (selRows.length == 0) {
            res = new ResourceDescriptor[]{new ResourceDescriptor.Collection(this.client.path)};
        } else {
            res = new ResourceDescriptor[selRows.length];
            for (int i = 0; i < selRows.length; ++i) {
                res[i] = this.resources.getRow(this.fileman.convertRowIndexToModel(selRows[i]));
                if (res[i].isCollection()) continue;
                JOptionPane.showMessageDialog(this, Messages.getString("ClientFrame.136"), Messages.getString("ClientFrame.137"), 0);
                return;
            }
        }
        if (JOptionPane.showConfirmDialog(this, Messages.getString("ClientFrame.138"), Messages.getString("ClientFrame.139"), 0) == 0) {
            ResourceDescriptor[] collections = res;
            Runnable reindexThread = () -> {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    IndexQueryService service = (IndexQueryService)this.client.current.getService("IndexQueryService", "1.0");
                    for (int i = 0; i < collections.length; ++i) {
                        ResourceDescriptor next = collections[i];
                        this.setStatus(Messages.getString("ClientFrame.142") + next.getName() + Messages.getString("ClientFrame.143"));
                        service.reindexCollection(next.getName());
                    }
                    this.setStatus(Messages.getString("ClientFrame.144"));
                }
                catch (XMLDBException e) {
                    ClientFrame.showErrorMessage(e.getMessage(), e);
                }
                this.setCursor(Cursor.getDefaultCursor());
            };
            new Thread(reindexThread).start();
        }
    }

    private void uploadAction(ActionEvent ev) {
        JFileChooser chooser = new JFileChooser(this.preferences.get("directory.last", System.getProperty("user.dir")));
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        chooser.addChoosableFileFilter(new BinaryFileFilter());
        chooser.addChoosableFileFilter(new XMLFileFilter());
        if (chooser.showDialog(this, Messages.getString("ClientFrame.146")) == 0) {
            this.preferences.put("directory.last", chooser.getCurrentDirectory().getAbsolutePath());
            this.uploadFiles(FileUtils.asPathsList(chooser.getSelectedFiles()));
        }
    }

    private void uploadFiles(final List<Path> files) {
        if (files != null && !files.isEmpty()) {
            new Thread(){

                @Override
                public void run() {
                    UploadDialog upload = new UploadDialog();
                    try {
                        ClientFrame.this.client.parse(files, upload);
                        ClientFrame.this.client.getResources();
                    }
                    catch (XMLDBException e) {
                        ClientFrame.showErrorMessage(Messages.getString("ClientFrame.147") + e.getMessage(), e);
                    }
                }
            }.start();
        }
    }

    private boolean deleteDirectory(Path target) {
        try {
            FileUtils.delete(target);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void backupAction(ActionEvent ev) {
        ResourceDescriptor[] selResources = this.getSelectedResources();
        String defaultSelectedCollection = selResources != null ? (selResources.length == 1 && selResources[0].isCollection() ? this.path.toString() + "/" + selResources[0].getName().toString() : this.path.toString()) : this.path.toString();
        CreateBackupDialog dialog = new CreateBackupDialog(this.properties.getProperty("uri", "xmldb:exist://"), this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), Paths.get(this.preferences.get("directory.backup", System.getProperty("user.home")), new String[0]), defaultSelectedCollection);
        if (JOptionPane.showOptionDialog(this, dialog, Messages.getString("ClientFrame.157"), 2, 3, null, null, null) == 0) {
            String collection = dialog.getCollection();
            String backuptarget = dialog.getBackupTarget();
            Path target = Paths.get(backuptarget, new String[0]).normalize();
            if (Files.exists(target, new LinkOption[0])) {
                int response = JOptionPane.showConfirmDialog(this, String.format("%s %s %s", Messages.getString("CreateBackupDialog.6a"), backuptarget, Messages.getString("CreateBackupDialog.6b")), Messages.getString("CreateBackupDialog.6c"), 0);
                if (response == -1) {
                    return;
                }
                if (response == 0) {
                    this.deleteDirectory(target);
                }
            }
            try {
                Backup backup = new Backup(this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), Paths.get(backuptarget, new String[0]), XmldbURI.xmldbUriFor(this.properties.getProperty("uri", "xmldb:exist://") + collection));
                backup.backup(true, this);
            }
            catch (IOException | URISyntaxException | SAXException | XMLDBException e) {
                ClientFrame.showErrorMessage(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
            }
        }
    }

    private void restoreAction(ActionEvent ev) {
        JFileChooser chooser = new JFileChooser(this.preferences.get("directory.backup", System.getProperty("user.dir")));
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new BackupContentsFilter());
        chooser.addChoosableFileFilter(new ZipFilter());
        if (chooser.showDialog(null, Messages.getString("ClientFrame.169")) == 0) {
            Path f = chooser.getSelectedFile().toPath();
            this.preferences.put("directory.backup", chooser.getCurrentDirectory().getAbsolutePath());
            JPanel askPass = new JPanel(new BorderLayout());
            askPass.add((Component)new JLabel(Messages.getString("ClientFrame.170")), "North");
            JPasswordField passInput = new JPasswordField(25);
            askPass.add((Component)passInput, "Center");
            if (JOptionPane.showOptionDialog(this, askPass, Messages.getString("ClientFrame.171"), 2, 3, null, null, null) == 0) {
                String newDbaPass = passInput.getPassword().length == 0 ? null : new String(passInput.getPassword());
                String restoreFile = f.toAbsolutePath().toString();
                GuiRestoreListener listener = new GuiRestoreListener(this);
                this.doRestore(listener, this.properties.getProperty("user", "admin"), this.properties.getProperty("password", null), newDbaPass, Paths.get(restoreFile, new String[0]), this.properties.getProperty("uri", "xmldb:exist://"));
            }
        }
    }

    private void doRestore(GuiRestoreListener listener, String username, String password, String dbaPassword, Path f, String uri) {
        Callable<Void> callable = () -> {
            Restore restore = new Restore();
            try {
                restore.restore(listener, username, password, dbaPassword, f, uri);
                if (JOptionPane.showConfirmDialog(null, Messages.getString("ClientFrame.223"), Messages.getString("ClientFrame.224"), 0) == 0) {
                    this.setStatus(Messages.getString("ClientFrame.225"));
                    ClientFrame.repairRepository(this.client.getCollection());
                    this.setStatus(Messages.getString("ClientFrame.226"));
                }
                listener.hideDialog();
                if (this.properties.getProperty("user", "admin").equals("admin") && dbaPassword != null) {
                    this.properties.setProperty("password", dbaPassword);
                }
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        this.client.reloadCollection();
                    }
                    catch (XMLDBException xe) {
                        xe.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                ClientFrame.showErrorMessage(Messages.getString("ClientFrame.181") + e.getMessage(), e);
            }
            finally {
                if (listener.hasProblems()) {
                    ClientFrame.showErrorMessage(Messages.getString("ClientFrame.181") + listener.warningsAndErrorsAsString(), null);
                }
            }
            return null;
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(callable);
    }

    public static void repairRepository(Collection collection) throws XMLDBException {
        EXistXQueryService service = (EXistXQueryService)collection.getService("XQueryService", "1.0");
        service.query("import module namespace repair=\"http://exist-db.org/xquery/repo/repair\"\nat \"resource:org/exist/xquery/modules/expathrepo/repair.xql\";\nrepair:clean-all(),\nrepair:repair()");
    }

    public UserManagementService getUserManagementService() throws XMLDBException {
        Collection collection = this.client.getCollection();
        return (UserManagementService)collection.getService("UserManagementService", "1.0");
    }

    private void editUsersAction(ActionEvent ev) {
        try {
            UserManagementService userManagementService = this.getUserManagementService();
            UserManagerDialog userManager = new UserManagerDialog(userManagementService, this.client.getProperties().getProperty("user"), this);
            userManager.setVisible(true);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.185"), e);
            e.printStackTrace();
        }
    }

    private void exportAction(ActionEvent ev) {
        int[] rows;
        if (this.fileman.getSelectedRowCount() == 0) {
            return;
        }
        for (int row : rows = this.fileman.getSelectedRows()) {
            ResourceDescriptor desc = this.resources.getRow(this.fileman.convertRowIndexToModel(row));
            if (desc.isCollection()) continue;
            JFileChooser chooser = new JFileChooser(this.preferences.get("directory.last", System.getProperty("user.dir")));
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.setSelectedFile(Paths.get(desc.getName().getCollectionPath(), new String[0]).toFile());
            if (chooser.showDialog(this, "Select file for export") != 0) continue;
            this.preferences.put("directory.last", chooser.getCurrentDirectory().getAbsolutePath());
            Path file = chooser.getSelectedFile().toPath();
            if (Files.exists(file, new LinkOption[0]) && JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Overwrite?", 0) == 1) {
                return;
            }
            try {
                Throwable throwable;
                Collection collection = this.client.getCollection();
                Resource resource = collection.getResource(desc.getName().toString());
                if (resource instanceof ExtendedResource) {
                    throwable = null;
                    try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
                        ((ExtendedResource)resource).getContentIntoAStream(os);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                throwable = null;
                try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                    SAXSerializer contentSerializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
                    contentSerializer.setOutput(writer, this.properties);
                    ((EXistResource)resource).setLexicalHandler(contentSerializer);
                    ((XMLResource)resource).getContentAsSAX((ContentHandler)contentSerializer);
                    SerializerPool.getInstance().returnObject(contentSerializer);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Exception e) {
                System.err.println("An exception occurred" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void editIndexesAction(ActionEvent ev) {
        IndexDialog dialog = new IndexDialog(Messages.getString("ClientFrame.186"), this.client);
        dialog.setVisible(true);
    }

    private void editTriggersAction(ActionEvent ev) {
        TriggersDialog dialog = new TriggersDialog("Edit Triggers", this.client);
        dialog.setVisible(true);
    }

    private void findAction(ActionEvent ev) {
        Collection collection = this.client.getCollection();
        QueryDialog dialog = new QueryDialog(this.client, collection, this.properties);
        dialog.setVisible(true);
    }

    private void setPermAction(ActionEvent ev) throws PermissionDeniedException {
        if (this.fileman.getSelectedRowCount() == 0) {
            return;
        }
        try {
            XmldbURI name;
            Collection collection = this.client.getCollection();
            UserManagementService service = this.getUserManagementService();
            PermissionAider permAider = null;
            Date created = new Date();
            Date modified = null;
            String mimeType = null;
            if (this.fileman.getSelectedRowCount() == 1) {
                Permission perm;
                int row = this.fileman.convertRowIndexToModel(this.fileman.getSelectedRow());
                ResourceDescriptor desc = this.resources.getRow(row);
                name = desc.getName();
                if (desc.isCollection()) {
                    Collection coll = collection.getChildCollection(name.toString());
                    created = ((EXistCollection)coll).getCreationTime();
                    perm = service.getPermissions(coll);
                } else {
                    Resource res = collection.getResource(name.toString());
                    created = ((EXistResource)res).getCreationTime();
                    modified = ((EXistResource)res).getLastModificationTime();
                    mimeType = ((EXistResource)res).getMimeType();
                    perm = service.getPermissions(res);
                }
                permAider = PermissionAiderFactory.getPermission(perm.getOwner().getName(), perm.getGroup().getName(), perm.getMode());
                if (perm instanceof ACLPermission && permAider instanceof ACLPermission) {
                    ACLPermission aclPermission = (ACLPermission)((Object)perm);
                    for (int i = 0; i < aclPermission.getACECount(); ++i) {
                        ((ACLPermission)((Object)permAider)).addACE(aclPermission.getACEAccessType(i), aclPermission.getACETarget(i), aclPermission.getACEWho(i), aclPermission.getACEMode(i));
                    }
                }
            } else {
                name = XmldbURI.create("..");
                Account account = service.getAccount(this.properties.getProperty("user"));
                permAider = PermissionAiderFactory.getPermission(account.getName(), account.getPrimaryGroup(), 438);
            }
            ArrayList<ResourceDescriptor> selected = new ArrayList<ResourceDescriptor>();
            int[] rows = this.fileman.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                selected.add(this.resources.getRow(this.fileman.convertRowIndexToModel(rows[i])));
            }
            EditPropertiesDialog editPropertiesDialog = new EditPropertiesDialog(service, this.client.getProperties().getProperty("user"), collection, name, mimeType, created, modified, permAider, selected);
            editPropertiesDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    try {
                        ClientFrame.this.client.reloadCollection();
                    }
                    catch (XMLDBException xmldbe) {
                        ClientFrame.showErrorMessage(Messages.getString("ClientFrame.197") + xmldbe.getMessage(), xmldbe);
                        xmldbe.printStackTrace();
                    }
                }
            });
            editPropertiesDialog.setVisible(true);
        }
        catch (XMLDBException e) {
            ClientFrame.showErrorMessage(Messages.getString("ClientFrame.197") + e.getMessage(), e);
            e.printStackTrace();
        }
    }

    private void enter() {
        int end = this.doc.getLength();
        if (end - this.commandStart == 0) {
            return;
        }
        try {
            String command = this.doc.getText(this.commandStart, end - this.commandStart);
            this.commandStart = end;
            this.doc.insertString(this.commandStart++, "\n", defaultAttrs);
            if (command != null) {
                this.process.setAction(command);
                this.client.console.getHistory().addToHistory(command);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void historyBack() {
        this.client.console.getHistory().previous();
        String item = this.client.console.getHistory().current();
        if (item == null) {
            return;
        }
        try {
            if (this.shell.getCaretPosition() > this.commandStart) {
                this.doc.remove(this.commandStart, this.doc.getLength() - this.commandStart);
            }
            this.doc.insertString(this.commandStart, item, defaultAttrs);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void historyForward() {
        this.client.console.getHistory().next();
        String item = this.client.console.getHistory().current();
        try {
            if (this.shell.getCaretPosition() > this.commandStart) {
                this.doc.remove(this.commandStart, this.doc.getLength() - this.commandStart);
            }
            this.doc.insertString(this.commandStart, item, defaultAttrs);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        this.process.terminate();
        System.exit(0);
    }

    private void actionFinished() {
        if (!this.process.getStatus()) {
            this.close();
        }
        this.displayPrompt();
    }

    private void AboutAction() {
        JOptionPane.showMessageDialog(this, this.client.getNotice());
    }

    protected static Properties getLoginData(Properties props) {
        Properties properties = new Properties();
        String serverUri = props.getProperty("uri") == null || props.getProperty("uri").isEmpty() ? "xmldb:exist://localhost:8080/exist/xmlrpc" : (Boolean.parseBoolean(props.getProperty("local-mode-opt", "FALSE")) ? "xmldb:exist://localhost:8080/exist/xmlrpc" : props.getProperty("uri"));
        DefaultConnectionSettings defaultConnectionSettings = new DefaultConnectionSettings(props.getProperty("user", "admin"), props.getProperty("password", ""), serverUri, Boolean.parseBoolean(props.getProperty("ssl-enable", "FALSE")));
        defaultConnectionSettings.setConfiguration(props.getProperty("configuration", ""));
        ConnectionDialog connectionDialog = new ConnectionDialog(null, true, defaultConnectionSettings, Boolean.parseBoolean(props.getProperty("local-mode-opt", "FALSE")), Boolean.parseBoolean(props.getProperty("NO_EMBED_MODE", "FALSE")));
        connectionDialog.setTitle(SystemProperties.getInstance().getSystemProperty("product-name", "eXist-db") + " " + SystemProperties.getInstance().getSystemProperty("product-version", "unknown") + " Database Login");
        connectionDialog.addDialogCompleteWithResponseCallback(connection -> {
            properties.setProperty("user", connection.getUsername());
            properties.setProperty("password", connection.getPassword());
            if (!connection.getUri().isEmpty()) {
                properties.setProperty("uri", connection.getUri());
                properties.setProperty("ssl-enable", Boolean.valueOf(connection.isSsl()).toString().toUpperCase());
                properties.setProperty("local-mode-opt", "FALSE");
            } else {
                properties.setProperty("configuration", connection.getConfiguration());
                properties.setProperty("uri", XmldbURI.EMBEDDED_SERVER_URI.toString());
            }
        });
        connectionDialog.setVisible(true);
        return properties;
    }

    public static void showErrorMessage(String message, Throwable t) {
        JScrollPane scroll = null;
        JTextArea msgArea = new JTextArea(message);
        msgArea.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClientFrame.214")));
        msgArea.setEditable(false);
        msgArea.setBackground(null);
        if (t != null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            t.printStackTrace(writer);
            JTextArea stacktrace = new JTextArea(out.toString(), 20, 50);
            stacktrace.setBackground(null);
            stacktrace.setEditable(false);
            scroll = new JScrollPane(stacktrace);
            scroll.setPreferredSize(new Dimension(250, 300));
            scroll.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClientFrame.215")));
        }
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{msgArea, scroll});
        optionPane.setMessageType(0);
        JDialog dialog = optionPane.createDialog(null, Messages.getString("ClientFrame.216"));
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static int showErrorMessageQuery(String message, Throwable t) {
        JTextArea msgArea = new JTextArea(message);
        msgArea.setLineWrap(true);
        msgArea.setWrapStyleWord(true);
        msgArea.setEditable(false);
        msgArea.setBackground(null);
        JScrollPane scrollMsgArea = new JScrollPane(msgArea);
        scrollMsgArea.setPreferredSize(new Dimension(600, 300));
        scrollMsgArea.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClientFrame.217")));
        JScrollPane scrollStacktrace = null;
        if (t != null) {
            try (StringWriter out = new StringWriter();
                 PrintWriter writer = new PrintWriter(out);){
                t.printStackTrace(writer);
                JTextArea stacktrace = new JTextArea(out.toString(), 20, 50);
                stacktrace.setLineWrap(true);
                stacktrace.setWrapStyleWord(true);
                stacktrace.setBackground(null);
                stacktrace.setEditable(false);
                scrollStacktrace = new JScrollPane(stacktrace);
                scrollStacktrace.setPreferredSize(new Dimension(600, 300));
                scrollStacktrace.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClientFrame.218")));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{scrollMsgArea, scrollStacktrace});
        optionPane.setMessageType(0);
        optionPane.setOptionType(2);
        JDialog dialog = optionPane.createDialog(null, Messages.getString("ClientFrame.219"));
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
        Object result = optionPane.getValue();
        if (result == null) {
            return 2;
        }
        return (Integer)optionPane.getValue();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.toFront();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.shellPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.shellPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class FileListDropTargetListener
    implements DropTargetListener {
        private FileListDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                dtde.acceptDrop(3);
                Transferable transferable = dtde.getTransferable();
                List<Path> files = this.getFilesWin32(transferable);
                if (files == null) {
                    files = this.getFilesUnix(transferable);
                }
                if (files != null) {
                    ClientFrame.this.uploadFiles(files);
                }
            }
            catch (UnsupportedFlavorException | IOException | ClassNotFoundException | URISyntaxException use) {
                System.err.println("An exception occurred while dragging and dropping files: " + use.getMessage());
                use.printStackTrace();
            }
        }

        private List<Path> getFilesWin32(Transferable transferable) throws UnsupportedFlavorException, IOException {
            return ((List)transferable.getTransferData(DataFlavor.javaFileListFlavor)).stream().map(File::toPath).collect(Collectors.toList());
        }

        private List<Path> getFilesUnix(Transferable transferable) throws ClassNotFoundException, UnsupportedFlavorException, IOException, URISyntaxException {
            ArrayList<Path> files = null;
            DataFlavor unixFileDataFlavour = new DataFlavor("text/uri-list;class=java.lang.String");
            String data = (String)transferable.getTransferData(unixFileDataFlavour);
            StringTokenizer st = new StringTokenizer(data, "\r\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("#") || token.isEmpty()) continue;
                if (files == null) {
                    files = new ArrayList<Path>();
                }
                files.add(Paths.get(new URI(token)));
            }
            return files;
        }
    }

    static class XMLFileFilter
    extends FileFilter {
        XMLFileFilter() {
        }

        @Override
        public String getDescription() {
            return Messages.getString("ClientFrame.221");
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return MimeTable.getInstance().isXMLContent(f.getName());
        }
    }

    static class BinaryFileFilter
    extends FileFilter {
        BinaryFileFilter() {
        }

        @Override
        public String getDescription() {
            return Messages.getString("ClientFrame.220");
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return !MimeTable.getInstance().isXMLContent(f.getName());
        }
    }

    static class ResourceTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{Messages.getString("ClientFrame.207"), Messages.getString("ClientFrame.208"), Messages.getString("ClientFrame.209"), Messages.getString("ClientFrame.210"), Messages.getString("ClientFrame.211")};
        private List<ResourceDescriptor> rows = null;
        private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        ResourceTableModel() {
        }

        public void setData(List<ResourceDescriptor> rows) {
            Collections.sort(rows, new ResourceComparator());
            this.rows = rows;
            this.fireTableDataChanged();
        }

        public ResourceDescriptor getRow(int index) {
            return this.getRowCount() > 0 ? this.rows.get(index) : null;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.rows == null ? 0 : this.rows.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.getRowCount() > 0) {
                ResourceDescriptor row = this.getRow(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return row.getName().toString();
                    }
                    case 1: {
                        return this.dateFormat.format(row.getDate());
                    }
                    case 2: {
                        return row.getOwner();
                    }
                    case 3: {
                        return row.getGroup();
                    }
                    case 4: {
                        return row.getPermissions();
                    }
                }
                throw new RuntimeException(Messages.getString("ClientFrame.212"));
            }
            return "";
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }
    }

    class ProcessThread
    extends Thread {
        private String action;
        private boolean terminate;
        private boolean status;

        public ProcessThread() {
            super("exist-client-processThread");
            this.action = null;
            this.terminate = false;
            this.status = false;
        }

        public synchronized void setAction(String action) {
            while (this.action != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.action = action;
            this.notify();
        }

        public synchronized void terminate() {
            this.terminate = true;
            this.notify();
        }

        public synchronized boolean getStatus() {
            return this.status;
        }

        public boolean isReady() {
            return this.action == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.terminate) {
                ProcessThread processThread;
                while (this.action == null) {
                    try {
                        processThread = this;
                        synchronized (processThread) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                this.status = ClientFrame.this.client.process(this.action);
                processThread = this;
                synchronized (processThread) {
                    this.action = null;
                    ClientFrame.this.actionFinished();
                    this.notify();
                }
            }
        }
    }

    private static class ResourceComparator
    implements Comparator<ResourceDescriptor> {
        private ResourceComparator() {
        }

        @Override
        public int compare(ResourceDescriptor desc1, ResourceDescriptor desc2) {
            if (desc1.isCollection() != desc2.isCollection()) {
                return desc1.isCollection() ? -1 : 1;
            }
            return desc1.getName().compareTo(desc2.getName());
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = ClientFrame.this.fileman.convertRowIndexToModel(ClientFrame.this.fileman.getSelectedRow());
                ResourceDescriptor resource = ClientFrame.this.resources.getRow(row);
                if (resource.isCollection()) {
                    String command = "cd \"" + resource.getName() + '\"';
                    ClientFrame.this.display(command + "\n");
                    ClientFrame.this.process.setAction(command);
                } else {
                    ClientFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        Resource doc = ClientFrame.this.client.retrieve(resource.getName(), ClientFrame.this.properties.getProperty("indent", "yes"));
                        if ("application/xquery".equals(((EXistResource)doc).getMimeType())) {
                            Collection collection = ClientFrame.this.client.getCollection();
                            QueryDialog dialog = new QueryDialog(ClientFrame.this.client, collection, doc, ClientFrame.this.properties);
                            dialog.setVisible(true);
                        } else {
                            DocumentView view = new DocumentView(ClientFrame.this.client, resource.getName(), doc, ClientFrame.this.properties);
                            view.setSize(new Dimension(640, 400));
                            view.viewDocument();
                        }
                    }
                    catch (XMLDBException ex) {
                        ClientFrame.showErrorMessage(Messages.getString("ClientFrame.206") + ex.getMessage(), ex);
                    }
                    ClientFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

