/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exist.client.InteractiveClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class CollectionXConf {
    public static final String TYPE_QNAME = "qname";
    public static final String TYPE_PATH = "path";
    private InteractiveClient client = null;
    private String path = null;
    Collection collection = null;
    Resource resConfig = null;
    private LinkedHashMap<String, String> customNamespaces = null;
    private RangeIndex[] rangeIndexes = null;
    private Trigger[] triggers = null;
    private boolean hasChanged = false;

    CollectionXConf(String CollectionName2, InteractiveClient client) throws XMLDBException {
        String[] resources;
        this.client = client;
        this.path = "/db/system/config" + CollectionName2;
        this.collection = client.getCollection(this.path);
        if (this.collection == null) {
            return;
        }
        for (String resource : resources = this.collection.listResources()) {
            if (!resource.endsWith(".xconf")) continue;
            this.resConfig = this.collection.getResource(resource);
            break;
        }
        if (this.resConfig == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document docConfig = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            docConfig = builder.parse(new ByteArrayInputStream(this.resConfig.getContent().toString().getBytes()));
        }
        catch (IOException | ParserConfigurationException | SAXException builder) {
            // empty catch block
        }
        Element xconf = docConfig.getDocumentElement();
        this.customNamespaces = this.getCustomNamespaces(xconf);
        this.rangeIndexes = this.getRangeIndexes(xconf);
        this.triggers = this.getTriggers(xconf);
    }

    public RangeIndex[] getRangeIndexes() {
        return this.rangeIndexes;
    }

    public RangeIndex getRangeIndex(int index) {
        return this.rangeIndexes[index];
    }

    public int getRangeIndexCount() {
        if (this.rangeIndexes != null) {
            return this.rangeIndexes.length;
        }
        return 0;
    }

    public void deleteRangeIndex(int index) {
        if (index < this.rangeIndexes.length) {
            this.hasChanged = true;
            if (this.rangeIndexes.length == 1) {
                this.rangeIndexes = null;
            } else {
                RangeIndex[] newRangeIndexes = new RangeIndex[this.rangeIndexes.length - 1];
                int x = 0;
                for (int i = 0; i < this.rangeIndexes.length; ++i) {
                    if (i == index) continue;
                    newRangeIndexes[x] = this.rangeIndexes[i];
                    ++x;
                }
                this.rangeIndexes = newRangeIndexes;
            }
        }
    }

    public void updateRangeIndex(int index, String type, String XPath, String xsType) {
        this.hasChanged = true;
        if (type != null) {
            this.rangeIndexes[index].setType(type);
        }
        if (XPath != null) {
            this.rangeIndexes[index].setXPath(XPath);
        }
        if (xsType != null) {
            this.rangeIndexes[index].setxsType(xsType);
        }
    }

    public void addRangeIndex(String type, String XPath, String xsType) {
        this.hasChanged = true;
        if (this.rangeIndexes == null) {
            this.rangeIndexes = new RangeIndex[1];
            this.rangeIndexes[0] = new RangeIndex(type, XPath, xsType);
        } else {
            RangeIndex[] newRangeIndexes = new RangeIndex[this.rangeIndexes.length + 1];
            System.arraycopy(this.rangeIndexes, 0, newRangeIndexes, 0, this.rangeIndexes.length);
            newRangeIndexes[this.rangeIndexes.length] = new RangeIndex(type, XPath, xsType);
            this.rangeIndexes = newRangeIndexes;
        }
    }

    public Trigger[] getTriggers() {
        return this.triggers;
    }

    public Trigger getTrigger(int index) {
        return this.triggers[index];
    }

    public int getTriggerCount() {
        if (this.triggers != null) {
            return this.triggers.length;
        }
        return 0;
    }

    public void deleteTrigger(int index) {
        if (index < this.triggers.length) {
            this.hasChanged = true;
            if (this.triggers.length == 1) {
                this.triggers = null;
            } else {
                Trigger[] newTriggers = new Trigger[this.triggers.length - 1];
                int x = 0;
                for (int i = 0; i < this.triggers.length; ++i) {
                    if (i == index) continue;
                    newTriggers[x] = this.triggers[i];
                    ++x;
                }
                this.triggers = newTriggers;
            }
        }
    }

    public void updateTrigger(int index, String triggerClass, Properties parameters) {
        this.hasChanged = true;
        if (triggerClass != null) {
            this.triggers[index].setTriggerClass(triggerClass);
        }
    }

    public void addTrigger(String triggerClass, Properties parameters) {
        this.hasChanged = true;
        if (this.triggers == null) {
            this.triggers = new Trigger[1];
            this.triggers[0] = new Trigger(triggerClass, parameters);
        } else {
            Trigger[] newTriggers = new Trigger[this.triggers.length + 1];
            System.arraycopy(this.triggers, 0, newTriggers, 0, this.triggers.length);
            newTriggers[this.triggers.length] = new Trigger(triggerClass, parameters);
            this.triggers = newTriggers;
        }
    }

    private LinkedHashMap<String, String> getCustomNamespaces(Element xconf) {
        NamedNodeMap attrs = xconf.getAttributes();
        if (attrs.getLength() > 1) {
            LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node a = attrs.item(i);
                if (!a.getNodeName().startsWith("xmlns:")) continue;
                String namespaceLocalName = a.getNodeName().substring(a.getNodeName().indexOf(":") + 1);
                namespaces.put(namespaceLocalName, a.getNodeValue());
            }
            return namespaces;
        }
        return null;
    }

    private RangeIndex[] getRangeIndexes(Element xconf) {
        NodeList nlRangeIndexes = xconf.getElementsByTagName("create");
        if (nlRangeIndexes.getLength() > 0) {
            ArrayList<RangeIndex> rl = new ArrayList<RangeIndex>();
            for (int i = 0; i < nlRangeIndexes.getLength(); ++i) {
                Element rangeIndex = (Element)nlRangeIndexes.item(i);
                if (!rangeIndex.hasAttribute("type")) continue;
                if (rangeIndex.hasAttribute(TYPE_QNAME)) {
                    rl.add(new RangeIndex(TYPE_QNAME, rangeIndex.getAttribute(TYPE_QNAME), rangeIndex.getAttribute("type")));
                    continue;
                }
                rl.add(new RangeIndex(TYPE_PATH, rangeIndex.getAttribute(TYPE_PATH), rangeIndex.getAttribute("type")));
            }
            RangeIndex[] rangeIndexes = new RangeIndex[rl.size()];
            rangeIndexes = rl.toArray(rangeIndexes);
            return rangeIndexes;
        }
        return null;
    }

    private Trigger[] getTriggers(Element xconf) {
        NodeList nlTriggers = xconf.getElementsByTagName("trigger");
        if (nlTriggers.getLength() > 0) {
            Trigger[] triggers = new Trigger[nlTriggers.getLength()];
            for (int i = 0; i < nlTriggers.getLength(); ++i) {
                Element trigger = (Element)nlTriggers.item(i);
                Properties parameters = new Properties();
                NodeList nlTriggerParameters = trigger.getElementsByTagName("parameter");
                if (nlTriggerParameters.getLength() > 0) {
                    for (int x = 0; x < nlTriggerParameters.getLength(); ++x) {
                        Element parameter = (Element)nlTriggerParameters.item(x);
                        parameters.setProperty(parameter.getAttribute("name"), parameter.getAttribute("value"));
                    }
                }
                triggers[i] = new Trigger(trigger.getAttribute("class"), parameters);
            }
            return triggers;
        }
        return null;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    private String toXMLString() {
        StringBuilder xconf = new StringBuilder();
        xconf.append("<collection xmlns=\"http://exist-db.org/collection-config/1.0\"");
        if (this.customNamespaces != null) {
            for (Map.Entry<String, String> entry : this.customNamespaces.entrySet()) {
                xconf.append(" ");
                String namespaceLocalName = entry.getKey();
                String namespaceURL = entry.getValue();
                xconf.append("xmlns:").append(namespaceLocalName).append("=\"").append(namespaceURL).append("\"");
            }
        }
        xconf.append(">");
        xconf.append(System.getProperty("line.separator"));
        if (this.rangeIndexes != null) {
            xconf.append('\t');
            xconf.append("<index>");
            xconf.append(System.getProperty("line.separator"));
            if (this.rangeIndexes != null) {
                for (RangeIndex rangeIndex : this.rangeIndexes) {
                    xconf.append("\t\t\t");
                    xconf.append(rangeIndex.toXMLString());
                    xconf.append(System.getProperty("line.separator"));
                }
            }
            xconf.append('\t');
            xconf.append("</index>");
            xconf.append(System.getProperty("line.separator"));
        }
        if (this.triggers != null) {
            xconf.append('\t');
            xconf.append("<triggers>");
            for (Trigger trigger : this.triggers) {
                xconf.append("\t\t\t");
                xconf.append(trigger.toXMLString());
                xconf.append(System.getProperty("line.separator"));
            }
            xconf.append('\t');
            xconf.append("</triggers>");
            xconf.append(System.getProperty("line.separator"));
        }
        xconf.append("</collection>");
        return xconf.toString();
    }

    public boolean Save() {
        try {
            if (this.resConfig == null) {
                if (this.collection == null) {
                    this.client.process("mkcol " + this.path);
                    this.collection = this.client.getCollection(this.path);
                }
                this.resConfig = this.collection.createResource("collection.xconf", "XMLResource");
            }
            this.resConfig.setContent((Object)this.toXMLString());
            this.collection.storeResource(this.resConfig);
        }
        catch (XMLDBException xmldbe) {
            return false;
        }
        return true;
    }

    protected static class Trigger {
        private String triggerClass = null;
        private Properties parameters = null;

        Trigger(String triggerClass, Properties parameters) {
            this.triggerClass = triggerClass;
            this.parameters = parameters;
        }

        public String getTriggerClass() {
            return this.triggerClass;
        }

        public void setTriggerClass(String triggerClass) {
            this.triggerClass = triggerClass;
        }

        protected String toXMLString() {
            StringBuilder trigger = new StringBuilder();
            if (!"".equals(this.triggerClass)) {
                trigger.append("<trigger class=\"");
                trigger.append(this.triggerClass);
                trigger.append("\">");
                if (this.parameters != null && this.parameters.size() > 0) {
                    Enumeration<Object> pKeys = this.parameters.keys();
                    while (pKeys.hasMoreElements()) {
                        String name = (String)pKeys.nextElement();
                        String value = this.parameters.getProperty(name);
                        trigger.append("<parameter name=\"");
                        trigger.append(name);
                        trigger.append("\" value=\"");
                        trigger.append(value);
                        trigger.append("\"/>");
                    }
                }
                trigger.append("</trigger>");
            }
            return trigger.toString();
        }
    }

    protected class RangeIndex {
        private String type = "qname";
        private String XPath = null;
        private String xsType = null;

        RangeIndex(String type, String XPath, String xsType) {
            this.type = type;
            this.XPath = XPath;
            this.xsType = xsType;
        }

        public String getXPath() {
            return this.XPath;
        }

        public String getxsType() {
            return this.xsType;
        }

        public String getType() {
            return this.type;
        }

        public void setXPath(String XPath) {
            this.XPath = XPath;
        }

        public void setxsType(String xsType) {
            this.xsType = xsType;
        }

        public void setType(String type) {
            this.type = type;
        }

        protected String toXMLString() {
            StringBuilder range = new StringBuilder();
            if (CollectionXConf.TYPE_PATH.equals(this.type)) {
                range.append("<create path=\"");
            } else {
                range.append("<create qname=\"");
            }
            range.append(this.XPath);
            range.append("\" type=\"");
            range.append(this.xsType);
            range.append("\"/>");
            return range.toString();
        }
    }
}

