/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.exist.client.Connection;
import org.exist.client.DefaultConnectionSettings;
import org.exist.client.DialogCompleteWithResponse;
import org.exist.client.DialogWithResponse;
import org.exist.client.EnterKeyAdapter;
import org.exist.client.FavouriteConnection;
import org.exist.client.FavouriteConnections;
import org.exist.client.InteractiveClient;
import org.exist.client.Messages;

public class ConnectionDialog
extends JDialog
implements DialogWithResponse<Connection> {
    private ComboBoxModel connectionTypeModel = null;
    private DefaultListModel favouritesModel = null;
    private final DefaultConnectionSettings defaultConnectionSettings;
    private final boolean disableEmbeddedConnectionType;
    private Path config;
    private final List<DialogCompleteWithResponse<Connection>> dialogCompleteWithResponseCallbacks = new ArrayList<DialogCompleteWithResponse<Connection>>();
    private JButton btnClose;
    private JButton btnConnect;
    private JButton btnSaveToFavourites;
    private JButton btnSelectConfiguration;
    private JCheckBox chkSsl;
    private JComboBox cmbConnectionType;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JLabel lblConfiguration;
    private JLabel lblConnectionType;
    private JLabel lblExistLogo;
    private JLabel lblPassword;
    private JLabel lblServerUri;
    private JLabel lblUsername;
    private JList lstFavourites;
    private JMenuItem miExportFavourites;
    private JMenuItem miImportFavourites;
    private JMenuItem miRemoveFavourite;
    private JPanel panEmbedded;
    private JPanel panFavourites;
    private JPanel panRemote;
    private JPopupMenu pmFavourites;
    private JTabbedPane tpConnectionType;
    private JTextField txtConfiguration;
    private JPasswordField txtPassword;
    private JTextField txtServerUri;
    private JTextField txtUsername;

    public ConnectionDialog(Frame parent, boolean modal, DefaultConnectionSettings defaultConnectionSettings, boolean embeddedByDefault, boolean disableEmbeddedConnectionType) {
        super(parent, modal);
        this.defaultConnectionSettings = defaultConnectionSettings;
        this.config = Paths.get(defaultConnectionSettings.getConfiguration(), new String[0]);
        this.disableEmbeddedConnectionType = disableEmbeddedConnectionType;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        this.initComponents();
        if (disableEmbeddedConnectionType) {
            this.cmbConnectionType.removeItem((Object)ConnectionType.Embedded);
        } else if (embeddedByDefault) {
            this.cmbConnectionType.setSelectedItem((Object)ConnectionType.Embedded);
            this.toggleRemoteEmbeddedDisplayTab(false);
        }
        this.txtPassword.addKeyListener(new EnterKeyAdapter(this.btnConnect));
        this.txtPassword.requestFocusInWindow();
    }

    private ComboBoxModel getConnectionTypeModel() {
        if (this.connectionTypeModel == null) {
            this.connectionTypeModel = new DefaultComboBoxModel<ConnectionType>(ConnectionType.values());
        }
        return this.connectionTypeModel;
    }

    private DefaultListModel getFavouritesModel() {
        if (this.favouritesModel == null) {
            this.favouritesModel = new DefaultListModel();
            for (FavouriteConnection favourite : FavouriteConnections.load()) {
                this.favouritesModel.addElement(favourite);
            }
        }
        return this.favouritesModel;
    }

    private void storeFavourites(ListModel model) {
        ArrayList<FavouriteConnection> favourites = new ArrayList<FavouriteConnection>();
        for (int i = 0; i < model.getSize(); ++i) {
            favourites.add((FavouriteConnection)model.getElementAt(i));
        }
        FavouriteConnections.store(favourites);
    }

    @Override
    public void addDialogCompleteWithResponseCallback(DialogCompleteWithResponse<Connection> dialogCompleteWithResponseCallback) {
        this.getDialogCompleteWithResponseCallbacks().add(dialogCompleteWithResponseCallback);
    }

    private List<DialogCompleteWithResponse<Connection>> getDialogCompleteWithResponseCallbacks() {
        return this.dialogCompleteWithResponseCallbacks;
    }

    private String getLabelText(String resourceId) {
        return Messages.getString(resourceId) + ":";
    }

    private String getLabel(String resourceId) {
        return Messages.getString(resourceId);
    }

    public DefaultConnectionSettings getDefaultConnectionSettings() {
        return this.defaultConnectionSettings;
    }

    private void initComponents() {
        this.pmFavourites = new JPopupMenu();
        this.miRemoveFavourite = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.miImportFavourites = new JMenuItem();
        this.miExportFavourites = new JMenuItem();
        this.lblExistLogo = new JLabel();
        this.lblUsername = new JLabel();
        this.lblPassword = new JLabel();
        this.lblConnectionType = new JLabel();
        this.cmbConnectionType = new JComboBox();
        this.txtUsername = new JTextField();
        this.txtPassword = new JPasswordField();
        this.tpConnectionType = new JTabbedPane();
        this.tpConnectionType.setUI(new BasicTabbedPaneUI(){

            @Override
            protected final void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
            }

            @Override
            protected final void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected final void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected final void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected final void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected final void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
            }

            @Override
            protected final void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
            }

            @Override
            protected final void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
            }

            @Override
            protected final void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            }

            @Override
            protected final void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            }
        });
        this.panRemote = new JPanel();
        this.lblServerUri = new JLabel();
        this.txtServerUri = new JTextField();
        this.chkSsl = new JCheckBox();
        this.panEmbedded = new JPanel();
        this.lblConfiguration = new JLabel();
        this.txtConfiguration = new JTextField();
        this.btnSelectConfiguration = new JButton();
        this.panFavourites = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.lstFavourites = new JList();
        this.btnSaveToFavourites = new JButton();
        this.btnClose = new JButton();
        this.btnConnect = new JButton();
        this.jSeparator1 = new JSeparator();
        this.miRemoveFavourite.setText("Remove");
        this.miRemoveFavourite.addActionListener(this::miRemoveFavouriteActionPerformed);
        this.pmFavourites.add(this.miRemoveFavourite);
        this.pmFavourites.add(this.jSeparator2);
        this.miImportFavourites.setText("Import Favourites...");
        this.miImportFavourites.addActionListener(this::miImportFavouritesActionPerformed);
        this.pmFavourites.add(this.miImportFavourites);
        this.miExportFavourites.setText("Export Favourites...");
        this.miExportFavourites.addActionListener(this::miExportFavouritesActionPerformed);
        this.pmFavourites.add(this.miExportFavourites);
        this.setDefaultCloseOperation(2);
        this.setTitle("Database Connection");
        this.lblExistLogo.setIcon(InteractiveClient.getExistIcon(this.getClass()));
        this.lblUsername.setText(this.getLabelText("LoginPanel.2"));
        this.lblPassword.setText(this.getLabelText("LoginPanel.3"));
        this.lblConnectionType.setText(this.getLabelText("LoginPanel.4"));
        this.cmbConnectionType.setModel(this.getConnectionTypeModel());
        this.cmbConnectionType.addActionListener(this::cmbConnectionTypeActionPerformed);
        this.txtUsername.setText(this.getDefaultConnectionSettings().getUsername());
        this.tpConnectionType.setTabPlacement(4);
        this.lblServerUri.setText(this.getLabelText("LoginPanel.12"));
        this.txtServerUri.setText(this.getDefaultConnectionSettings().getUri());
        this.chkSsl.setSelected(this.getDefaultConnectionSettings().isSsl());
        this.chkSsl.setText(this.getLabel("LoginPanel.47"));
        GroupLayout panRemoteLayout = new GroupLayout(this.panRemote);
        this.panRemote.setLayout(panRemoteLayout);
        panRemoteLayout.setHorizontalGroup(panRemoteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panRemoteLayout.createSequentialGroup().addContainerGap().addComponent(this.lblServerUri).addGap(63, 63, 63).addGroup(panRemoteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkSsl).addComponent(this.txtServerUri, -2, 336, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        panRemoteLayout.setVerticalGroup(panRemoteLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panRemoteLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panRemoteLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblServerUri).addComponent(this.txtServerUri, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkSsl).addGap(25, 25, 25)));
        this.tpConnectionType.addTab("tab3", this.panRemote);
        this.lblConfiguration.setText(this.getLabelText("LoginPanel.8"));
        this.txtConfiguration.setEditable(false);
        this.txtConfiguration.setText(this.config.toAbsolutePath().toString());
        this.txtConfiguration.setToolTipText(this.getLabel("LoginPanel.9"));
        this.btnSelectConfiguration.setText("...");
        this.btnSelectConfiguration.setToolTipText(this.getLabel("LoginPanel.11"));
        this.btnSelectConfiguration.addActionListener(this::btnSelectConfigurationActionPerformed);
        GroupLayout panEmbeddedLayout = new GroupLayout(this.panEmbedded);
        this.panEmbedded.setLayout(panEmbeddedLayout);
        panEmbeddedLayout.setHorizontalGroup(panEmbeddedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panEmbeddedLayout.createSequentialGroup().addContainerGap().addComponent(this.lblConfiguration).addGap(33, 33, 33).addComponent(this.txtConfiguration, -1, 279, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectConfiguration, -2, 33, -2).addContainerGap()));
        panEmbeddedLayout.setVerticalGroup(panEmbeddedLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panEmbeddedLayout.createSequentialGroup().addContainerGap().addGroup(panEmbeddedLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConfiguration).addComponent(this.txtConfiguration, -2, -1, -2).addComponent(this.btnSelectConfiguration, -2, 28, -2)).addContainerGap(38, Short.MAX_VALUE)));
        this.tpConnectionType.addTab("tab2", this.panEmbedded);
        this.panFavourites.setBorder(BorderFactory.createTitledBorder(this.getLabel("LoginPanel.14")));
        this.lstFavourites.setModel(this.getFavouritesModel());
        this.lstFavourites.setComponentPopupMenu(this.pmFavourites);
        this.lstFavourites.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConnectionDialog.this.lstFavouritesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstFavourites);
        this.btnSaveToFavourites.setText(this.getLabel("LoginPanel.17"));
        this.btnSaveToFavourites.addActionListener(this::btnSaveToFavouritesActionPerformed);
        GroupLayout panFavouritesLayout = new GroupLayout(this.panFavourites);
        this.panFavourites.setLayout(panFavouritesLayout);
        panFavouritesLayout.setHorizontalGroup(panFavouritesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panFavouritesLayout.createSequentialGroup().addContainerGap().addGroup(panFavouritesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 463, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panFavouritesLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnSaveToFavourites))).addContainerGap()));
        panFavouritesLayout.setVerticalGroup(panFavouritesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panFavouritesLayout.createSequentialGroup().addComponent(this.btnSaveToFavourites).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 143, Short.MAX_VALUE).addContainerGap()));
        this.btnClose.setText(this.getLabel("LoginPanel.51"));
        this.btnClose.addActionListener(this::btnCloseActionPerformed);
        this.btnConnect.setText(this.getLabel("LoginPanel.50"));
        this.btnConnect.addKeyListener(new EnterKeyAdapter());
        this.btnConnect.addActionListener(this::btnConnectActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnConnect)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.lblExistLogo, -2, 113, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panFavourites, -2, -1, -2).addComponent(this.tpConnectionType, -2, 527, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblPassword, -1, 110, Short.MAX_VALUE).addComponent(this.lblConnectionType, -1, -1, Short.MAX_VALUE)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtPassword, -2, 270, -2).addComponent(this.txtUsername, -2, 270, -2).addComponent(this.cmbConnectionType, -2, 100, -2))).addComponent(this.lblUsername, -2, 115, -2))).addComponent(this.jSeparator1, -2, 666, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUsername).addComponent(this.txtUsername, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.txtPassword, -2, -1, -2)).addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblConnectionType).addComponent(this.cmbConnectionType, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.lblExistLogo, -2, 108, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tpConnectionType, -2, 86, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panFavourites, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClose).addComponent(this.btnConnect)).addContainerGap(35, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnConnectActionPerformed(ActionEvent evt) {
        Connection connection = this.cmbConnectionType.getSelectedItem() == ConnectionType.Remote ? new Connection(this.txtUsername.getText(), new String(this.txtPassword.getPassword()), this.txtServerUri.getText(), this.chkSsl.isSelected()) : new Connection(this.txtUsername.getText(), new String(this.txtPassword.getPassword()), this.txtConfiguration.getText());
        for (DialogCompleteWithResponse<Connection> callback : this.getDialogCompleteWithResponseCallbacks()) {
            callback.complete(connection);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cmbConnectionTypeActionPerformed(ActionEvent evt) {
        boolean remote = (ConnectionType)((Object)this.cmbConnectionType.getSelectedItem()) == ConnectionType.Remote;
        this.toggleRemoteEmbeddedDisplayTab(remote);
    }

    private void toggleRemoteEmbeddedDisplayTab(boolean remote) {
        this.lblServerUri.setEnabled(remote);
        this.lblServerUri.setVisible(remote);
        this.txtServerUri.setEnabled(remote);
        this.txtServerUri.setVisible(remote);
        this.chkSsl.setEnabled(remote);
        this.chkSsl.setVisible(remote);
        this.lblConfiguration.setEnabled(!remote);
        this.lblConfiguration.setVisible(!remote);
        this.txtConfiguration.setEnabled(!remote);
        this.txtConfiguration.setVisible(!remote);
        this.btnSelectConfiguration.setEnabled(!remote);
        this.btnSelectConfiguration.setVisible(!remote);
        if (remote) {
            this.tpConnectionType.setSelectedIndex(0);
            if (this.txtServerUri.getText().isEmpty()) {
                this.txtServerUri.setText(this.defaultConnectionSettings.getUri());
                this.chkSsl.setSelected(this.defaultConnectionSettings.isSsl());
            }
        } else {
            this.tpConnectionType.setSelectedIndex(1);
            if (this.txtConfiguration.getText().isEmpty()) {
                this.txtConfiguration.setText(this.defaultConnectionSettings.getConfiguration());
            }
        }
    }

    private void btnSelectConfigurationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setCurrentDirectory(this.config.getParent().toFile());
        if (chooser.showDialog(this, Messages.getString("LoginPanel.37")) == 0) {
            this.config = chooser.getSelectedFile().toPath();
            this.txtConfiguration.setText(this.config.toAbsolutePath().toString());
        }
    }

    private void btnSaveToFavouritesActionPerformed(ActionEvent evt) {
        String favouriteName = JOptionPane.showInputDialog(this, "Please enter a name for your favourite:", "Save Favourite", 3);
        if (favouriteName != null && favouriteName.length() > 0) {
            for (int i = 0; i < this.getFavouritesModel().getSize(); ++i) {
                if (!this.getFavouritesModel().elementAt(i).equals(favouriteName)) continue;
                int result = JOptionPane.showConfirmDialog(this, Messages.getString("LoginPanel.19"), Messages.getString("LoginPanel.20"), 0);
                if (result == 1) {
                    return;
                }
                this.getFavouritesModel().remove(i);
                break;
            }
            FavouriteConnection favourite = this.cmbConnectionType.getSelectedItem() == ConnectionType.Remote ? new FavouriteConnection(favouriteName, this.txtUsername.getText(), new String(this.txtPassword.getPassword()), this.txtServerUri.getText(), this.chkSsl.isSelected()) : new FavouriteConnection(favouriteName, this.txtUsername.getText(), new String(this.txtPassword.getPassword()), this.config.toAbsolutePath().toString());
            this.getFavouritesModel().addElement(favourite);
            this.storeFavourites(this.getFavouritesModel());
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void lstFavouritesMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.miRemoveFavourite.setEnabled(!this.lstFavourites.isSelectionEmpty());
            this.miExportFavourites.setEnabled(!this.getFavouritesModel().isEmpty());
        }
        if (evt.getClickCount() == 2 && this.lstFavourites.getSelectedIndex() >= 0) {
            FavouriteConnection favourite = (FavouriteConnection)this.lstFavourites.getSelectedValue();
            boolean favouriteHasEmbeddedMode = "".equals(favourite.getUri());
            if (this.disableEmbeddedConnectionType && favouriteHasEmbeddedMode) {
                JOptionPane.showMessageDialog(this, "The favourite connection '" + favourite.getName() + "' uses an Embedded Connection Type, but Embedded Connections have been disabled at client startup.", "Favourite Selection Error", 0);
                this.lstFavourites.clearSelection();
            } else {
                this.txtUsername.setText(favourite.getUsername());
                this.txtPassword.setText(favourite.getPassword());
                this.cmbConnectionType.setSelectedItem((Object)(favouriteHasEmbeddedMode ? ConnectionType.Embedded : ConnectionType.Remote));
                this.tpConnectionType.setSelectedIndex(this.cmbConnectionType.getSelectedIndex());
                this.txtServerUri.setText(favourite.getUri());
                this.chkSsl.setSelected(favourite.isSsl());
                this.txtConfiguration.setText(favourite.getConfiguration());
                this.txtPassword.requestFocusInWindow();
            }
        }
    }

    private void miImportFavouritesActionPerformed(ActionEvent evt) {
        Path file = Paths.get("favourites.xml", new String[0]);
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(file.toFile());
        chooser.showOpenDialog(this);
        Path selectedImportFile = chooser.getSelectedFile().toPath();
        if (selectedImportFile == null) {
            JOptionPane.showMessageDialog(this, Messages.getString("LoginPanel.33"), Messages.getString("LoginPanel.34"), 0);
            return;
        }
        if (!Files.isReadable(selectedImportFile)) {
            JOptionPane.showMessageDialog(this, Messages.getString("LoginPanel.35"), Messages.getString("LoginPanel.36"), 0);
            return;
        }
        try {
            FavouriteConnections.importFromFile(selectedImportFile);
            this.getFavouritesModel().removeAllElements();
            for (FavouriteConnection favourite : FavouriteConnections.load()) {
                this.getFavouritesModel().addElement(favourite);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to read preferences file: " + selectedImportFile.toAbsolutePath() + ": " + ioe.getMessage(), "Error Importing Preferences", 0);
        }
        catch (InvalidPreferencesFormatException ipfe) {
            JOptionPane.showMessageDialog(this, "Invalid format for preferences file: " + selectedImportFile.toAbsolutePath() + ": " + ipfe.getMessage(), "Error Importing Preferences", 0);
        }
    }

    private void miExportFavouritesActionPerformed(ActionEvent evt) {
        Path file = Paths.get(Messages.getString("LoginPanel.25"), new String[0]);
        JFileChooser chooser = new JFileChooser();
        chooser.setSelectedFile(file.toFile());
        chooser.showSaveDialog(this);
        Path selectedExportFile = chooser.getSelectedFile().toPath();
        if (selectedExportFile == null) {
            JOptionPane.showMessageDialog(this, Messages.getString("LoginPanel.26"), Messages.getString("LoginPanel.27"), 0);
            return;
        }
        if (Files.exists(selectedExportFile, new LinkOption[0]) && !Files.isReadable(selectedExportFile)) {
            JOptionPane.showMessageDialog(this, Messages.getString("LoginPanel.28"), Messages.getString("LoginPanel.29"), 0);
            return;
        }
        try {
            FavouriteConnections.exportToFile(selectedExportFile);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to write preferences file: " + selectedExportFile.toAbsolutePath() + ": " + ioe.getMessage(), "Error Importing Preferences", 0);
        }
        catch (BackingStoreException bse) {
            JOptionPane.showMessageDialog(this, "Backing store error for export to file: " + selectedExportFile.toAbsolutePath() + ": " + bse.getMessage(), "Error Importing Preferences", 0);
        }
    }

    private void miRemoveFavouriteActionPerformed(ActionEvent evt) {
        if (!this.lstFavourites.isSelectionEmpty()) {
            this.getFavouritesModel().remove(this.lstFavourites.getSelectedIndex());
            this.storeFavourites(this.getFavouritesModel());
        }
    }

    private static enum ConnectionType {
        Remote,
        Embedded;

    }
}

