/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import org.exist.client.FavouriteConnection;
import org.exist.client.Messages;
import org.exist.xmldb.XmldbURI;

public class FavouriteConnections {
    private static final String FAVOURITES_NODE = Messages.getString("LoginPanel.1");

    public static void store(List<FavouriteConnection> favourites) {
        Preferences prefs = Preferences.userNodeForPackage(FavouriteConnections.class);
        Preferences favouritesNode = prefs.node(FAVOURITES_NODE);
        try {
            favouritesNode.removeNode();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
        favouritesNode = prefs.node(FAVOURITES_NODE);
        for (FavouriteConnection favourite : favourites) {
            if (favourites == null) continue;
            Preferences favouriteNode = favouritesNode.node(favourite.getName());
            favouriteNode.put(FavouriteConnection.USERNAME, favourite.getUsername());
            favouriteNode.put(FavouriteConnection.PASSWORD, "");
            favouriteNode.put(FavouriteConnection.URI, favourite.getUri());
            favouriteNode.put(FavouriteConnection.CONFIGURATION, favourite.getConfiguration());
            favouriteNode.put(FavouriteConnection.SSL, Boolean.valueOf(favourite.isSsl()).toString().toUpperCase());
        }
    }

    public static List<FavouriteConnection> load() {
        Preferences prefs = Preferences.userNodeForPackage(FavouriteConnections.class);
        Preferences favouritesNode = prefs.node(FAVOURITES_NODE);
        String[] favouriteNodeNames = new String[]{};
        try {
            favouriteNodeNames = favouritesNode.childrenNames();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
        ArrayList<FavouriteConnection> favourites = new ArrayList<FavouriteConnection>();
        for (String favouriteNodeName : favouriteNodeNames) {
            Preferences node = favouritesNode.node(favouriteNodeName);
            FavouriteConnection favourite = !"".equals(node.get(FavouriteConnection.URI, "")) && !"".equals(node.get(FavouriteConnection.CONFIGURATION, "")) ? (node.get(FavouriteConnection.URI, "").equals(XmldbURI.EMBEDDED_SERVER_URI.toString()) ? FavouriteConnections.getEmbeddedFavourite(favouriteNodeName, node) : FavouriteConnections.getRemoteFavourite(favouriteNodeName, node)) : ("".equals(node.get(FavouriteConnection.URI, "")) ? FavouriteConnections.getEmbeddedFavourite(favouriteNodeName, node) : FavouriteConnections.getRemoteFavourite(favouriteNodeName, node));
            favourites.add(favourite);
        }
        Collections.sort(favourites);
        return favourites;
    }

    private static FavouriteConnection getRemoteFavourite(String favouriteNodeName, Preferences node) {
        return new FavouriteConnection(favouriteNodeName, node.get(FavouriteConnection.USERNAME, ""), "", node.get(FavouriteConnection.URI, ""), Boolean.parseBoolean(node.get(FavouriteConnection.SSL, "FALSE")));
    }

    private static FavouriteConnection getEmbeddedFavourite(String favouriteNodeName, Preferences node) {
        return new FavouriteConnection(favouriteNodeName, node.get(FavouriteConnection.USERNAME, ""), "", node.get(FavouriteConnection.CONFIGURATION, ""));
    }

    public static void importFromFile(Path f) throws IOException, InvalidPreferencesFormatException {
        Preferences prefs = Preferences.userNodeForPackage(FavouriteConnections.class);
        try (InputStream is = Files.newInputStream(f, new OpenOption[0]);){
            Preferences.importPreferences(is);
        }
    }

    public static void exportToFile(Path f) throws IOException, BackingStoreException {
        Preferences prefs = Preferences.userNodeForPackage(FavouriteConnections.class);
        try (OutputStream os = Files.newOutputStream(f, new OpenOption[0]);){
            prefs.exportSubtree(os);
        }
    }
}

