/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.exist.client.ClientFrame;
import org.exist.client.PrettyXmldbURI;
import org.exist.xmldb.XmldbURI;

public class HighlightedTableCellRenderer<T extends AbstractTableModel>
extends DefaultTableCellRenderer {
    private static final Color collectionBackground = new Color(225, 235, 224);
    private static final Color collectionForeground = Color.black;
    private static final Color highBackground = new Color(115, 130, 189);
    private static final Color highForeground = Color.white;
    private static final Color altBackground = new Color(235, 235, 235);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color background;
        Color foreground;
        Component renderer;
        if (value instanceof XmldbURI) {
            value = new PrettyXmldbURI((XmldbURI)value);
        }
        if ((renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JCheckBox) {
            ((JCheckBox)renderer).setOpaque(true);
        } else if (renderer instanceof JLabel) {
            ((JLabel)renderer).setOpaque(true);
        }
        AbstractTableModel resources = (AbstractTableModel)table.getModel();
        if (isSelected) {
            foreground = highForeground;
            background = highBackground;
        } else if (resources instanceof ClientFrame.ResourceTableModel && ((ClientFrame.ResourceTableModel)resources).getRow(row).isCollection()) {
            foreground = collectionForeground;
            background = collectionBackground;
        } else if (row % 2 == 0) {
            background = altBackground;
            foreground = Color.black;
        } else {
            foreground = Color.black;
            background = Color.white;
        }
        renderer.setForeground(foreground);
        renderer.setBackground(background);
        return renderer;
    }
}

