/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.exist.util.MimeTable;

public class MimeTypeFileFilter
extends FileFilter {
    private String description = null;
    private List<String> extensions = null;

    public MimeTypeFileFilter(String mimeType) {
        this.description = MimeTable.getInstance().getContentType(mimeType).getDescription();
        this.extensions = MimeTable.getInstance().getAllExtensions(mimeType);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        int extensionOffset = file.getName().lastIndexOf(46);
        if (extensionOffset == -1) {
            return false;
        }
        String fileExtension = file.getName().substring(extensionOffset).toLowerCase();
        for (String extension : this.extensions) {
            if (!fileExtension.equals(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder description = new StringBuilder(this.description);
        description.append(" (");
        Iterator<String> itExtensions = this.extensions.iterator();
        while (itExtensions.hasNext()) {
            description.append(itExtensions.next());
            if (!itExtensions.hasNext()) continue;
            description.append(' ');
        }
        description.append(")");
        return description.toString();
    }
}

