/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import org.exist.client.ClientFrame;
import org.exist.client.InteractiveClient;
import org.exist.client.Messages;
import org.exist.client.MimeTypeFileFilter;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.EXistXQueryService;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.XQueryWatchDog;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.CompiledExpression;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class QueryDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private InteractiveClient client;
    private Collection collection;
    private Properties properties;
    private RSyntaxTextArea query;
    private RTextScrollPane queryScrollPane;
    private JTabbedPane resultTabs;
    private RSyntaxTextArea resultDisplay;
    private RTextScrollPane resultDisplayScrollPane;
    private RSyntaxTextArea exprDisplay;
    private RTextScrollPane exprDisplayScrollPane;
    private JComboBox collections = null;
    private SpinnerNumberModel count;
    private DefaultComboBoxModel history = new DefaultComboBoxModel();
    private JTextField statusMessage;
    private JTextField queryPositionDisplay;
    private JProgressBar progress;
    private JButton submitButton;
    private JButton killButton;
    private QueryThread q = null;
    private Resource resource = null;
    private static AtomicInteger queryThreadId = new AtomicInteger();

    private QueryDialog(InteractiveClient client, Collection collection, Properties properties, boolean loadedFromDb) {
        super(Messages.getString("QueryDialog.0"));
        this.collection = collection;
        this.properties = properties;
        this.client = client;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        this.setupComponents(loadedFromDb);
        this.pack();
    }

    public QueryDialog(InteractiveClient client, Collection collection, Properties properties) {
        this(client, collection, properties, false);
    }

    public QueryDialog(InteractiveClient client, final Collection collection, final Resource resource, Properties properties) throws XMLDBException {
        this(client, collection, properties, true);
        this.resource = resource;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    UserManagementService service = (UserManagementService)collection.getService("UserManagementService", "1.0");
                    service.unlockResource(resource);
                }
                catch (XMLDBException e) {
                    e.printStackTrace();
                }
            }
        });
        this.query.setText(new String((byte[])resource.getContent()));
        this.setTitle(Messages.getString("QueryDialog.0") + ": " + resource.getId());
    }

    private void saveToDb(String queryText) {
        try {
            this.resource.setContent((Object)queryText);
            this.collection.storeResource(this.resource);
        }
        catch (XMLDBException xmldbe) {
            ClientFrame.showErrorMessage(xmldbe.getMessage(), xmldbe);
        }
    }

    private void setupComponents(boolean loadedFromDb) {
        this.getContentPane().setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        URL url = this.getClass().getResource("icons/Open24.gif");
        JButton button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("QueryDialog.opentooltip"));
        button.addActionListener(e -> this.open());
        toolbar.add(button);
        if (loadedFromDb) {
            url = this.getClass().getResource("icons/SaveAs23.gif");
            button = new JButton(new ImageIcon(url));
            button.setToolTipText("Save to database");
            button.addActionListener(e -> this.saveToDb(this.query.getText()));
            toolbar.add(button);
        }
        url = this.getClass().getResource("icons/SaveAs24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("QueryDialog.saveastooltip"));
        button.addActionListener(e -> this.save(this.query.getText(), "query"));
        toolbar.add(button);
        url = this.getClass().getResource("icons/SaveAs25.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("QueryDialog.saveresultstooltip"));
        button.addActionListener(e -> this.save(this.resultDisplay.getText(), "result"));
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Copy24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("QueryDialog.copytooltip"));
        button.addActionListener(e -> this.query.copy());
        toolbar.add(button);
        url = this.getClass().getResource("icons/Cut24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("QueryDialog.cuttooltip"));
        button.addActionListener(e -> this.query.cut());
        toolbar.add(button);
        url = this.getClass().getResource("icons/Paste24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("QueryDialog.pastetooltip"));
        button.addActionListener(e -> this.query.paste());
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Find24.gif");
        button = new JButton(new ImageIcon(url));
        button.setToolTipText(Messages.getString("QueryDialog.compiletooltip"));
        button.addActionListener(e -> this.compileQuery());
        toolbar.add(button);
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Find24.gif");
        this.submitButton = new JButton(Messages.getString("QueryDialog.submitbutton"), new ImageIcon(url));
        this.submitButton.setToolTipText(Messages.getString("QueryDialog.submittooltip"));
        toolbar.add(this.submitButton);
        this.submitButton.addActionListener(e -> {
            this.submitButton.setEnabled(false);
            if (this.collection instanceof LocalCollection) {
                this.killButton.setEnabled(true);
            }
            this.q = this.doQuery();
        });
        toolbar.addSeparator();
        url = this.getClass().getResource("icons/Delete24.gif");
        this.killButton = new JButton(Messages.getString("QueryDialog.killbutton"), new ImageIcon(url));
        this.killButton.setToolTipText(Messages.getString("QueryDialog.killtooltip"));
        toolbar.add(this.killButton);
        this.killButton.setEnabled(false);
        this.killButton.addActionListener(e -> {
            if (this.q != null) {
                this.q.killQuery();
                this.killButton.setEnabled(false);
                this.q = null;
            }
        });
        JSplitPane split = new JSplitPane(0);
        split.setResizeWeight(0.6);
        JComponent qbox = this.createQueryBox();
        split.setTopComponent(qbox);
        JPanel vbox = new JPanel();
        vbox.setLayout(new BorderLayout());
        JLabel label = new JLabel(Messages.getString("QueryDialog.resultslabel"));
        vbox.add((Component)label, "North");
        this.resultTabs = new JTabbedPane();
        this.resultDisplay = new RSyntaxTextArea(14, 80);
        this.resultDisplay.setEditable(false);
        this.resultDisplay.getPopupMenu().remove(0);
        this.resultDisplay.getPopupMenu().remove(0);
        this.resultDisplay.getPopupMenu().remove(0);
        this.resultDisplay.setSyntaxEditingStyle("text/xml");
        this.resultDisplay.setCodeFoldingEnabled(true);
        this.resultDisplayScrollPane = new RTextScrollPane((RTextArea)this.resultDisplay);
        this.resultTabs.add(Messages.getString("QueryDialog.XMLtab"), (Component)this.resultDisplayScrollPane);
        this.exprDisplay = new RSyntaxTextArea(14, 80);
        this.exprDisplay.setEditable(false);
        this.exprDisplay.getPopupMenu().remove(0);
        this.exprDisplay.getPopupMenu().remove(0);
        this.exprDisplay.getPopupMenu().remove(0);
        this.exprDisplayScrollPane = new RTextScrollPane((RTextArea)this.exprDisplay);
        this.resultTabs.add(Messages.getString("QueryDialog.tracetab"), (Component)this.exprDisplayScrollPane);
        vbox.add((Component)this.resultTabs, "Center");
        Box statusbar = Box.createHorizontalBox();
        statusbar.setBorder(BorderFactory.createBevelBorder(1));
        this.statusMessage = new JTextField(20);
        this.statusMessage.setEditable(false);
        this.statusMessage.setFocusable(true);
        statusbar.add(this.statusMessage);
        this.queryPositionDisplay = new JTextField(5);
        this.queryPositionDisplay.setEditable(false);
        this.queryPositionDisplay.setFocusable(true);
        statusbar.add(this.queryPositionDisplay);
        this.query.addCaretListener(e -> {
            RSyntaxTextArea txt = (RSyntaxTextArea)e.getSource();
            this.queryPositionDisplay.setText("Line: " + (txt.getCaretLineNumber() + 1) + " Column:" + (txt.getCaretOffsetFromLineStart() + 1));
        });
        this.progress = new JProgressBar();
        this.progress.setPreferredSize(new Dimension(200, statusbar.getHeight()));
        this.progress.setVisible(false);
        statusbar.add(this.progress);
        vbox.add((Component)statusbar, "South");
        split.setBottomComponent(vbox);
        split.setDividerLocation(0.6);
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)split, "Center");
    }

    private JComponent createQueryBox() {
        JTabbedPane tabs = new JTabbedPane();
        JPanel inputVBox = new JPanel();
        inputVBox.setLayout(new BorderLayout());
        tabs.add(Messages.getString("QueryDialog.inputtab"), inputVBox);
        Box historyBox = Box.createHorizontalBox();
        JLabel label = new JLabel(Messages.getString("QueryDialog.historylabel"));
        historyBox.add(label);
        JComboBox historyList = new JComboBox(this.history);
        for (String query : this.client.queryHistory) {
            this.addQuery(query);
        }
        historyList.addActionListener(e -> {
            String item = this.client.queryHistory.get(historyList.getSelectedIndex());
            this.query.setText(item);
        });
        historyBox.add(historyList);
        inputVBox.add((Component)historyBox, "North");
        this.query = new RSyntaxTextArea(14, 80);
        this.query.setSyntaxEditingStyle("text/xml");
        this.query.setCodeFoldingEnabled(true);
        this.queryScrollPane = new RTextScrollPane((RTextArea)this.query);
        inputVBox.add((Component)this.queryScrollPane, "Center");
        Box optionsPanel = Box.createHorizontalBox();
        label = new JLabel(Messages.getString("QueryDialog.contextlabel"));
        optionsPanel.add(label);
        ArrayList<String> data = new ArrayList<String>();
        try {
            Collection root = this.client.getCollection("/db");
            data.add(this.collection.getName());
            this.getCollections(root, this.collection, data);
        }
        catch (XMLDBException e2) {
            ClientFrame.showErrorMessage(Messages.getString("QueryDialog.collectionretrievalerrormessage") + ".", e2);
        }
        this.collections = new JComboBox<String>(new Vector<String>(data));
        this.collections.addActionListener(e -> {
            int p = this.collections.getSelectedIndex();
            String context = (String)data.get(p);
            try {
                this.collection = this.client.getCollection(context);
            }
            catch (XMLDBException xMLDBException) {
                // empty catch block
            }
        });
        optionsPanel.add(this.collections);
        label = new JLabel(Messages.getString("QueryDialog.maxlabel"));
        optionsPanel.add(label);
        this.count = new SpinnerNumberModel(100, 1, 10000, 50);
        JSpinner spinner = new JSpinner(this.count);
        spinner.setMaximumSize(new Dimension(400, 100));
        optionsPanel.add(spinner);
        inputVBox.add((Component)optionsPanel, "South");
        return tabs;
    }

    private List<String> getCollections(Collection root, Collection collection, List<String> collectionsList) throws XMLDBException {
        if (!collection.getName().equals(root.getName())) {
            collectionsList.add(root.getName());
        }
        String[] childCollections = root.listChildCollections();
        Collection child = null;
        for (int i = 0; i < childCollections.length; ++i) {
            try {
                child = root.getChildCollection(childCollections[i]);
            }
            catch (XMLDBException xmldbe) {
                if (xmldbe.getCause() instanceof PermissionDeniedException) continue;
                throw xmldbe;
            }
            catch (Exception npe) {
                System.out.println("Corrupted resource/collection skipped: " + child != null ? (child.getName() != null ? child.getName() : "unknown") : "unknown");
                continue;
            }
            try {
                this.getCollections(child, collection, collectionsList);
                continue;
            }
            catch (Exception ee) {
                System.out.println("Corrupted resource/collection skipped: " + child != null ? (child.getName() != null ? child.getName() : "unknown") : "unknown");
            }
        }
        return collectionsList;
    }

    private void open() {
        String workDir = this.properties.getProperty("working-dir", System.getProperty("user.dir"));
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(Paths.get(workDir, new String[0]).toFile());
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/xquery"));
        if (chooser.showDialog(this, Messages.getString("QueryDialog.opendialog")) == 0) {
            Path selectedDir = chooser.getCurrentDirectory().toPath();
            this.properties.setProperty("working-dir", selectedDir.toAbsolutePath().toString());
            Path file = chooser.getSelectedFile().toPath();
            if (!Files.isReadable(file)) {
                JOptionPane.showInternalMessageDialog(this, Messages.getString("QueryDialog.cannotreadmessage") + " " + file.toAbsolutePath(), Messages.getString("QueryDialog.Error"), 0);
            }
            try (BufferedReader reader = Files.newBufferedReader(file);){
                String line;
                StringBuilder buf = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    buf.append(line);
                    buf.append('\n');
                }
                this.query.setText(buf.toString());
            }
            catch (IOException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
        }
    }

    private void save(String stringToSave, String fileCategory) {
        if (stringToSave == null || "".equals(stringToSave)) {
            return;
        }
        String workDir = this.properties.getProperty("working-dir", System.getProperty("user.dir"));
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setCurrentDirectory(Paths.get(workDir, new String[0]).toFile());
        chooser.setFileSelectionMode(0);
        if ("result".equals(fileCategory)) {
            chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/xhtml+xml"));
            chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/xml"));
        } else {
            chooser.addChoosableFileFilter(new MimeTypeFileFilter("application/xquery"));
        }
        if (chooser.showDialog(this, Messages.getString("QueryDialog.savedialogpre") + " " + fileCategory + " " + Messages.getString("QueryDialog.savedialogpost")) == 0) {
            Path selectedDir = chooser.getCurrentDirectory().toPath();
            this.properties.setProperty("working-dir", selectedDir.toAbsolutePath().toString());
            Path file = chooser.getSelectedFile().toPath();
            if (Files.exists(file, new LinkOption[0]) && !Files.isWritable(file)) {
                JOptionPane.showMessageDialog(this, Messages.getString("QueryDialog.cannotsavemessagepre") + " " + fileCategory + " " + Messages.getString("QueryDialog.cannotsavemessageinf") + " " + file.toAbsolutePath(), Messages.getString("QueryDialog.Error"), 0);
            }
            if (Files.exists(file, new LinkOption[0]) && JOptionPane.showConfirmDialog(this, Messages.getString("QueryDialog.savedialogconfirm"), "Overwrite?", 0) == 1) {
                return;
            }
            try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                writer.write(stringToSave);
            }
            catch (IOException e) {
                ClientFrame.showErrorMessage(e.getMessage(), e);
            }
        }
    }

    private QueryThread doQuery() {
        String xpath = this.query.getText();
        if (xpath.length() == 0) {
            return null;
        }
        this.resultDisplay.setText("");
        QueryThread q = new QueryThread(xpath);
        q.start();
        return q;
    }

    private void compileQuery() {
        String xpath = this.query.getText();
        if (xpath.length() == 0) {
            return;
        }
        this.resultDisplay.setText("");
        this.statusMessage.setText(Messages.getString("QueryDialog.compilemessage"));
        this.setCursor(Cursor.getPredefinedCursor(3));
        long tResult = 0L;
        long tCompiled = 0L;
        try {
            EXistXQueryService service = (EXistXQueryService)this.collection.getService("XQueryService", "1.0");
            service.setProperty("indent", this.properties.getProperty("indent", "yes"));
            long t0 = System.currentTimeMillis();
            CompiledExpression compiled = service.compile(xpath);
            long t1 = System.currentTimeMillis();
            tCompiled = t1 - t0;
            StringWriter writer = new StringWriter();
            service.dump(compiled, writer);
            this.exprDisplay.setText(writer.toString());
            this.resultTabs.setSelectedComponent((Component)this.exprDisplayScrollPane);
            this.statusMessage.setText(Messages.getString("QueryDialog.Compilation") + ": " + tCompiled + "ms");
        }
        catch (Throwable e) {
            this.statusMessage.setText(Messages.getString("QueryDialog.Error") + ": " + InteractiveClient.getExceptionMessage(e) + ". " + Messages.getString("QueryDialog.Compilation") + ": " + tCompiled + "ms, " + Messages.getString("QueryDialog.Execution") + ": " + 0L + "ms");
            ClientFrame.showErrorMessageQuery(Messages.getString("QueryDialog.compilationerrormessage") + ": " + InteractiveClient.getExceptionMessage(e), e);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void addQuery(String query) {
        if (query.length() > 40) {
            query = query.substring(0, 40);
        }
        this.history.addElement(Integer.toString(this.history.getSize() + 1) + ". " + query);
    }

    private class QueryThread
    extends Thread {
        private final String xpath;
        private XQueryContext context;

        public QueryThread(String query) {
            super("exist-queryThread-" + queryThreadId.getAndIncrement());
            this.xpath = query;
            this.context = null;
        }

        public boolean killQuery() {
            if (this.context != null) {
                boolean retval;
                XQueryWatchDog xwd = this.context.getWatchDog();
                boolean bl = retval = !xwd.isTerminating();
                if (retval) {
                    xwd.kill(0L);
                }
                this.context = null;
                return retval;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            QueryDialog.this.statusMessage.setText(Messages.getString("QueryDialog.processingquerymessage"));
            QueryDialog.this.progress.setVisible(true);
            QueryDialog.this.progress.setIndeterminate(true);
            QueryDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            long tResult = 0L;
            long tCompiled = 0L;
            ResourceSet result = null;
            try {
                EXistXQueryService service = (EXistXQueryService)QueryDialog.this.collection.getService("XQueryService", "1.0");
                service.setProperty("indent", QueryDialog.this.properties.getProperty("indent", "yes"));
                long t0 = System.currentTimeMillis();
                if (QueryDialog.this.resource != null) {
                    service.setModuleLoadPath("xmldb:exist://" + QueryDialog.this.resource.getParentCollection().getName());
                }
                CompiledExpression compiled = service.compile(this.xpath);
                long t1 = System.currentTimeMillis();
                if (compiled instanceof CompiledXQuery) {
                    this.context = ((CompiledXQuery)compiled).getContext();
                }
                tCompiled = t1 - t0;
                StringWriter writer = new StringWriter();
                service.dump(compiled, writer);
                QueryDialog.this.exprDisplay.setText(writer.toString());
                result = service.execute(compiled);
                this.context = null;
                tResult = System.currentTimeMillis() - t1;
                writer = new StringWriter();
                service.dump(compiled, writer);
                QueryDialog.this.exprDisplay.setText(writer.toString());
                QueryDialog.this.statusMessage.setText(Messages.getString("QueryDialog.retrievingmessage"));
                int howmany = QueryDialog.this.count.getNumber().intValue();
                QueryDialog.this.progress.setIndeterminate(false);
                QueryDialog.this.progress.setMinimum(1);
                QueryDialog.this.progress.setMaximum(howmany);
                int select = -1;
                StringBuilder contents = new StringBuilder();
                ResourceIterator i = result.getIterator();
                for (int j = 0; i.hasMoreResources() && j < howmany; ++j) {
                    XMLResource resource = (XMLResource)i.nextResource();
                    QueryDialog.this.progress.setValue(j);
                    try {
                        contents.append((String)resource.getContent());
                        contents.append("\n");
                        continue;
                    }
                    catch (XMLDBException e) {
                        select = ClientFrame.showErrorMessageQuery(Messages.getString("QueryDialog.retrievalerrormessage") + ": " + InteractiveClient.getExceptionMessage(e), e);
                        if (select == 3) break;
                    }
                }
                QueryDialog.this.resultTabs.setSelectedComponent((Component)QueryDialog.this.resultDisplayScrollPane);
                QueryDialog.this.resultDisplay.setText(contents.toString());
                QueryDialog.this.resultDisplay.setCaretPosition(0);
                QueryDialog.this.statusMessage.setText(Messages.getString("QueryDialog.Found") + " " + result.getSize() + " " + Messages.getString("QueryDialog.items") + ". " + Messages.getString("QueryDialog.Compilation") + ": " + tCompiled + "ms, " + Messages.getString("QueryDialog.Execution") + ": " + tResult + "ms");
            }
            catch (Throwable e) {
                QueryDialog.this.statusMessage.setText(Messages.getString("QueryDialog.Error") + ": " + InteractiveClient.getExceptionMessage(e) + ". " + Messages.getString("QueryDialog.Compilation") + ": " + tCompiled + "ms, " + Messages.getString("QueryDialog.Execution") + ": " + tResult + "ms");
                QueryDialog.this.progress.setVisible(false);
                ClientFrame.showErrorMessageQuery(Messages.getString("QueryDialog.queryrunerrormessage") + ": " + InteractiveClient.getExceptionMessage(e), e);
            }
            finally {
                if (this.context != null) {
                    this.context.runCleanupTasks();
                }
                this.context = null;
                if (result != null) {
                    try {
                        result.clear();
                    }
                    catch (XMLDBException service) {}
                }
            }
            if (((QueryDialog)QueryDialog.this).client.queryHistory.isEmpty() || !((QueryDialog)QueryDialog.this).client.queryHistory.getLast().equals(this.xpath)) {
                QueryDialog.this.client.addToHistory(this.xpath);
                QueryDialog.this.client.writeQueryHistory();
                QueryDialog.this.addQuery(this.xpath);
            }
            QueryDialog.this.setCursor(Cursor.getDefaultCursor());
            QueryDialog.this.progress.setVisible(false);
            QueryDialog.this.killButton.setEnabled(false);
            QueryDialog.this.submitButton.setEnabled(true);
        }
    }
}

