/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.exist.client.ClientFrame;
import org.exist.client.CollectionXConf;
import org.exist.client.InteractiveClient;
import org.exist.client.Messages;
import org.exist.client.PrettyXmldbURI;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.XmldbURI;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;

class TriggersDialog
extends JFrame {
    private static final long serialVersionUID = 1L;
    private CollectionXConf cx = null;
    private JComboBox cmbCollections;
    private JTable tblTriggers;
    private TriggersTableModel triggersModel;
    private InteractiveClient client;

    public TriggersDialog(String title, InteractiveClient client) {
        super(title);
        this.client = client;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TriggersDialog.this.saveChanges();
                TriggersDialog.this.setVisible(false);
                TriggersDialog.this.dispose();
            }
        };
        this.addWindowListener(windowListener);
        this.setupComponents();
        this.actionGetTriggers("/db");
    }

    private void setupComponents() {
        GridBagLayout grid = new GridBagLayout();
        this.getContentPane().setLayout(grid);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        JLabel label = new JLabel(Messages.getString("TriggersDialog.Collection"));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        grid.setConstraints(label, c);
        this.getContentPane().add(label);
        ArrayList<PrettyXmldbURI> alCollections = new ArrayList<PrettyXmldbURI>();
        try {
            Collection root = this.client.getCollection("/db");
            List<PrettyXmldbURI> alAllCollections = this.getCollections(root, new ArrayList<PrettyXmldbURI>());
            for (int i = 0; i < alAllCollections.size(); ++i) {
                if (alAllCollections.get(i).toString().contains("/db/system/config")) continue;
                alCollections.add(alAllCollections.get(i));
            }
        }
        catch (XMLDBException e2) {
            ClientFrame.showErrorMessage(e2.getMessage(), e2);
            return;
        }
        this.cmbCollections = new JComboBox<Object>(alCollections.toArray());
        this.cmbCollections.addActionListener(e -> {
            this.saveChanges();
            JComboBox cb = (JComboBox)e.getSource();
            this.actionGetTriggers(cb.getSelectedItem().toString());
        });
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 1.0;
        grid.setConstraints(this.cmbCollections, c);
        this.getContentPane().add(this.cmbCollections);
        JPanel panelTriggers = new JPanel();
        panelTriggers.setBorder(new TitledBorder(Messages.getString("TriggersDialog.Triggers")));
        GridBagLayout panelTriggersGrid = new GridBagLayout();
        panelTriggers.setLayout(panelTriggersGrid);
        this.triggersModel = new TriggersTableModel();
        this.tblTriggers = new JTable(this.triggersModel);
        this.tblTriggers.setAutoResizeMode(1);
        this.tblTriggers.setSelectionMode(0);
        Box triggersToolbarBox = Box.createHorizontalBox();
        JButton btnAddTrigger = new JButton(Messages.getString("TriggersDialog.addbutton"));
        btnAddTrigger.addActionListener(e -> this.actionAddTrigger());
        triggersToolbarBox.add(btnAddTrigger);
        JButton btnDeleteTrigger = new JButton(Messages.getString("TriggersDialog.deletebutton"));
        btnDeleteTrigger.addActionListener(e -> this.actionDeleteTrigger());
        triggersToolbarBox.add(btnDeleteTrigger);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 10;
        c.fill = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelTriggersGrid.setConstraints(triggersToolbarBox, c);
        panelTriggers.add(triggersToolbarBox);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        grid.setConstraints(panelTriggers, c);
        this.getContentPane().add(panelTriggers);
        this.pack();
    }

    private void saveChanges() {
        int result;
        if (this.cx.hasChanged() && (result = JOptionPane.showConfirmDialog(this.getContentPane(), "The configuration for the collection has changed, would you like to save the changes?", "Save Changes", 0)) == 0) {
            if (this.cx.Save()) {
                JOptionPane.showMessageDialog(this.getContentPane(), "Your changes have been saved.");
            } else {
                JOptionPane.showMessageDialog(this.getContentPane(), "Unable to save changes!");
            }
        }
    }

    private List<PrettyXmldbURI> getCollections(Collection root, List<PrettyXmldbURI> collectionsList) throws XMLDBException {
        collectionsList.add(new PrettyXmldbURI(XmldbURI.create(root.getName())));
        String[] childCollections = root.listChildCollections();
        for (int i = 0; i < childCollections.length; ++i) {
            Collection child;
            try {
                child = root.getChildCollection(childCollections[i]);
            }
            catch (XMLDBException xmldbe) {
                if (xmldbe.getCause() instanceof PermissionDeniedException) continue;
                throw xmldbe;
            }
            this.getCollections(child, collectionsList);
        }
        return collectionsList;
    }

    private void actionAddTrigger() {
        this.triggersModel.addRow();
    }

    private void actionDeleteTrigger() {
        int iSelectedRow = this.tblTriggers.getSelectedRow();
        if (iSelectedRow > -1) {
            this.triggersModel.removeRow(iSelectedRow);
        }
    }

    private void actionGetTriggers(String collectionName) {
        try {
            this.cx = new CollectionXConf(collectionName, this.client);
            this.triggersModel.fireTableDataChanged();
        }
        catch (XMLDBException xmldbe) {
            ClientFrame.showErrorMessage(xmldbe.getMessage(), xmldbe);
        }
    }

    class TriggersTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{"class", "Parameters"};

        public TriggersTableModel() {
            this.fireTableDataChanged();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String triggerClass = null;
            if (columnIndex == 0) {
                triggerClass = (String)aValue;
            }
            TriggersDialog.this.cx.updateTrigger(rowIndex, triggerClass, null);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        public void removeRow(int rowIndex) {
            TriggersDialog.this.cx.deleteTrigger(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void addRow() {
            TriggersDialog.this.cx.addTrigger("", null);
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount() + 1);
            ListSelectionModel selectionModel = TriggersDialog.this.tblTriggers.getSelectionModel();
            selectionModel.setSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return TriggersDialog.this.cx != null ? TriggersDialog.this.cx.getTriggerCount() : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return TriggersDialog.this.cx.getTrigger(rowIndex).getTriggerClass();
                }
            }
            return null;
        }
    }

    public static class CheckBoxCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public CheckBoxCellEditor() {
            super(new JCheckBox());
        }
    }

    public static class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }
}

