/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import javax.swing.table.DefaultTableModel;
import org.exist.client.LabelledBoolean;
import org.exist.security.Permission;

public class BasicPermissionsTableModel
extends DefaultTableModel {
    final Class[] types = new Class[]{String.class, Boolean.class, Boolean.class, Boolean.class, LabelledBoolean.class};
    boolean[] canEdit = new boolean[]{false, true, true, true, true};

    public BasicPermissionsTableModel(Permission permission) {
        super(new Object[][]{{"User", (permission.getOwnerMode() & 4) == 4, (permission.getOwnerMode() & 2) == 2, (permission.getOwnerMode() & 1) == 1, new LabelledBoolean("SetUID", permission.isSetUid())}, {"Group", (permission.getGroupMode() & 4) == 4, (permission.getGroupMode() & 2) == 2, (permission.getGroupMode() & 1) == 1, new LabelledBoolean("SetGID", permission.isSetGid())}, {"Other", (permission.getOtherMode() & 4) == 4, (permission.getOtherMode() & 2) == 2, (permission.getOtherMode() & 1) == 1, new LabelledBoolean("Sticky", permission.isSticky())}}, new String[]{"Permission", "Read", "Write", "Execute", "Special"});
    }

    public Class getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.canEdit[columnIndex];
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
    }

    public int getMode() {
        int mode = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (((Boolean)this.getValueAt(i, 1)).booleanValue()) {
                mode |= 4;
            }
            if (((Boolean)this.getValueAt(i, 2)).booleanValue()) {
                mode |= 2;
            }
            if (((Boolean)this.getValueAt(i, 3)).booleanValue()) {
                mode |= 1;
            }
            if (i == this.getRowCount() - 1) continue;
            mode <<= 3;
        }
        if (((LabelledBoolean)this.getValueAt(0, 4)).isSet()) {
            mode |= 0x800;
        }
        if (((LabelledBoolean)this.getValueAt(1, 4)).isSet()) {
            mode |= 0x400;
        }
        if (((LabelledBoolean)this.getValueAt(2, 4)).isSet()) {
            mode |= 0x200;
        }
        return mode;
    }
}

