/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import org.exist.client.security.GroupDialog;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class EditGroupDialog
extends GroupDialog {
    private static final long serialVersionUID = -9092253443709031810L;
    private final Group group;

    public EditGroupDialog(UserManagementService userManagementService, String currentUser, Group group) {
        super(userManagementService, currentUser);
        this.group = group;
        this.setFormPropertiesFromGroup();
    }

    @Override
    protected void addSelfAsManager() {
    }

    private void setFormPropertiesFromGroup() {
        this.setTitle("Edit Group: " + this.getGroup().getName());
        this.btnCreate.setText("Save");
        this.txtGroupName.setText(this.getGroup().getName());
        this.txtGroupName.setEnabled(false);
        this.txtDescription.setText(this.getGroup().getMetadataValue(EXistSchemaType.DESCRIPTION));
        try {
            List<Account> groupManagers = this.group.getManagers();
            Object[] groupMembers = this.getUserManagementService().getGroupMembers(this.group.getName());
            Arrays.sort(groupMembers);
            for (Object groupMember : groupMembers) {
                this.getGroupMembersTableModel().addRow(new Object[]{groupMember, this.isGroupManager(groupManagers, (String)groupMember)});
            }
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not get group members: " + xmldbe.getMessage(), "Edit Group Error", 0);
        }
        catch (PermissionDeniedException pde) {
            JOptionPane.showMessageDialog(this, "Could not get group members: " + pde.getMessage(), "Edit Group Error", 0);
        }
        this.miAddGroupMember.setEnabled(this.canModifyGroupMembers());
        this.btnAddMember.setEnabled(this.canModifyGroupMembers());
    }

    @Override
    protected void createGroup() {
        this.updateGroup();
    }

    private void updateGroup() {
        try {
            this.updateGroupMembers();
            this.setGroupFromFormProperties();
            this.getUserManagementService().updateGroup(this.getGroup());
        }
        catch (PermissionDeniedException pde) {
            JOptionPane.showMessageDialog(this, "Could not update group '" + this.txtGroupName.getText() + "': " + pde.getMessage(), "Edit Group Error", 0);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not update group '" + this.txtGroupName.getText() + "': " + xmldbe.getMessage(), "Edit Group Error", 0);
        }
    }

    private void setGroupFromFormProperties() throws PermissionDeniedException, XMLDBException {
        this.getGroup().setMetadataValue(EXistSchemaType.DESCRIPTION, this.txtDescription.getText());
        List<Account> currentManagers = this.getGroup().getManagers();
        for (Account currentManager : currentManagers) {
            this.getUserManagementService().removeGroupManager(this.group.getName(), currentManager.getName());
        }
        for (int i = 0; i < this.getGroupMembersTableModel().getRowCount(); ++i) {
            boolean isManager = (Boolean)this.getGroupMembersTableModel().getValueAt(i, 1);
            if (!isManager) continue;
            String manager = (String)this.getGroupMembersTableModel().getValueAt(i, 0);
            this.getUserManagementService().addGroupManager(manager, this.getGroup().getName());
        }
    }

    private void updateGroupMembers() throws XMLDBException, PermissionDeniedException {
        HashSet<String> currentGroupMembers = new HashSet<String>(Arrays.asList(this.getUserManagementService().getGroupMembers(this.group.getName())));
        HashSet<String> groupMembers = new HashSet<String>();
        for (int i = 0; i < this.getGroupMembersTableModel().getRowCount(); ++i) {
            groupMembers.add((String)this.getGroupMembersTableModel().getValueAt(i, 0));
        }
        for (String currentGroupMember : currentGroupMembers) {
            if (groupMembers.contains(currentGroupMember)) continue;
            this.getUserManagementService().removeGroupMember(this.group.getName(), currentGroupMember);
        }
        for (String groupMember : groupMembers) {
            if (currentGroupMembers.contains(groupMember)) continue;
            this.getUserManagementService().addAccountToGroup(groupMember, this.group.getName());
        }
    }

    protected Group getGroup() {
        return this.group;
    }

    @Override
    protected boolean canModifyGroupMembers() {
        try {
            return this.getUserManagementService().getAccount(this.getCurrentUser()).hasDbaRole() || this.isGroupManager(this.group.getManagers(), this.getCurrentUser());
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not establish user " + this.getCurrentUser() + "'s group permissions: " + xmldbe.getMessage(), "Edit Group Error", 0);
            return false;
        }
        catch (PermissionDeniedException pde) {
            JOptionPane.showMessageDialog(this, "Could not establish user " + this.getCurrentUser() + "'s group permissions: " + pde.getMessage(), "Edit Group Error", 0);
            return false;
        }
    }

    @Override
    protected boolean canModifySelectedGroupMember() {
        boolean groupMemberSelected = this.tblGroupMembers.getSelectedRow() > -1;
        return groupMemberSelected && (!this.group.getName().equals("dba") || !this.getSelectedMember().equals("admin") && !this.getSelectedMember().equals("SYSTEM")) && (!this.group.getName().equals("guest") || !this.getSelectedMember().equals("guest"));
    }

    private boolean isGroupManager(List<Account> groupManagers, String groupMember) {
        for (Account groupManager : groupManagers) {
            if (!groupManager.getName().equals(groupMember)) continue;
            return true;
        }
        return false;
    }
}

