/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import org.exist.client.DialogCompleteWithResponse;
import org.exist.client.DialogWithResponse;
import org.exist.client.security.UmaskSpinnerModel;
import org.exist.client.security.UserDialog;
import org.exist.security.AXSchemaType;
import org.exist.security.Account;
import org.exist.security.EXistSchemaType;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.EXistUserManagementService;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class EditUserDialog
extends UserDialog
implements DialogWithResponse<String> {
    private static final long serialVersionUID = 9097018734007436201L;
    private static final String HIDDEN_PASSWORD_CONST = "password";
    private final Account account;
    private final List<DialogCompleteWithResponse<String>> dialogCompleteWithResponseCallbacks = new ArrayList<DialogCompleteWithResponse<String>>();

    public EditUserDialog(UserManagementService userManagementService, Account account) {
        super(userManagementService);
        this.account = account;
        this.setFormPropertiesFromAccount();
    }

    private void setFormPropertiesFromAccount() {
        this.setTitle("Edit User: " + this.getAccount().getName());
        this.btnCreate.setText("Save");
        this.txtUsername.setText(this.getAccount().getName());
        this.txtUsername.setEnabled(false);
        this.txtFullName.setText(this.getAccount().getMetadataValue(AXSchemaType.FULLNAME));
        this.txtDescription.setText(this.getAccount().getMetadataValue(EXistSchemaType.DESCRIPTION));
        this.txtPassword.setText(HIDDEN_PASSWORD_CONST);
        this.txtPasswordConfirm.setText(HIDDEN_PASSWORD_CONST);
        this.cbDisabled.setSelected(!this.getAccount().isEnabled());
        this.spnUmask.setValue(UmaskSpinnerModel.intToOctalUmask(this.getAccount().getUserMask()));
        this.cbPersonalGroup.setVisible(false);
        boolean first = true;
        for (String group : this.getAccount().getGroups()) {
            this.getMemberOfGroupsListModel().add(group);
            this.getAvailableGroupsListModel().removeElement(group);
            if (!first) continue;
            this.setPrimaryGroup(group);
            this.getMemberOfGroupsListCellRenderer().setCellOfInterest(this.getPrimaryGroup());
            first = false;
        }
    }

    @Override
    protected void createUser() {
        if (this.getMemberOfGroupsListModel().getSize() == 0) {
            JOptionPane.showMessageDialog(this, "A user must be a member of at least one user group", "Edit User Error", 0);
            return;
        }
        this.updateUser();
        if (this.isPasswordChanged()) {
            for (DialogCompleteWithResponse<String> callback : this.getDialogCompleteWithResponseCallbacks()) {
                callback.complete(this.txtPassword.getText());
            }
        }
    }

    private void updateUser() {
        try {
            Optional<String> newPassword = this.setAccountFromFormProperties();
            this.getUserManagementService().updateAccount(this.getAccount());
            this.modifyAccountGroupMembership();
            if (newPassword.isPresent()) {
                Account acct = this.getUserManagementService().getAccount(this.getAccount().getName());
                acct.setPassword(newPassword.get());
                this.getUserManagementService().updateAccount(acct);
            }
        }
        catch (PermissionDeniedException pde) {
            JOptionPane.showMessageDialog(this, "Could not update user '" + this.txtUsername.getText() + "': " + pde.getMessage(), "Edit User Error", 0);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not update user '" + this.txtUsername.getText() + "': " + xmldbe.getMessage(), "Edit User Error", 0);
        }
    }

    private boolean isPasswordChanged() {
        String password = new String(this.txtPassword.getPassword());
        return !password.equals(HIDDEN_PASSWORD_CONST);
    }

    private void modifyAccountGroupMembership() throws XMLDBException {
        HashSet<String> currentGroups = new HashSet<String>(Arrays.asList(this.getAccount().getGroups()));
        HashSet<String> memberOfGroups = new HashSet<String>();
        for (int i = 0; i < this.getMemberOfGroupsListModel().getSize(); ++i) {
            memberOfGroups.add((String)this.getMemberOfGroupsListModel().getElementAt(i));
        }
        for (String currentGroup : currentGroups) {
            if (memberOfGroups.contains(currentGroup)) continue;
            this.getUserManagementService().removeGroupMember(currentGroup, this.getAccount().getName());
        }
        for (String memberOfGroup : memberOfGroups) {
            if (currentGroups.contains(memberOfGroup)) continue;
            this.getUserManagementService().addAccountToGroup(this.getAccount().getName(), memberOfGroup);
        }
        ((EXistUserManagementService)this.getUserManagementService()).setUserPrimaryGroup(this.getAccount().getName(), this.getPrimaryGroup());
    }

    private Optional<String> setAccountFromFormProperties() throws PermissionDeniedException {
        this.getAccount().setMetadataValue(AXSchemaType.FULLNAME, this.txtFullName.getText());
        this.getAccount().setMetadataValue(EXistSchemaType.DESCRIPTION, this.txtDescription.getText());
        this.getAccount().setEnabled(!this.cbDisabled.isSelected());
        this.getAccount().setUserMask(UmaskSpinnerModel.octalUmaskToInt((String)this.spnUmask.getValue()));
        if (this.isPasswordChanged()) {
            String password = new String(this.txtPassword.getPassword());
            return Optional.of(password);
        }
        return Optional.empty();
    }

    protected Account getAccount() {
        return this.account;
    }

    private List<DialogCompleteWithResponse<String>> getDialogCompleteWithResponseCallbacks() {
        return this.dialogCompleteWithResponseCallbacks;
    }

    @Override
    public void addDialogCompleteWithResponseCallback(DialogCompleteWithResponse<String> dialogCompleteWithResponseCallback) {
        this.getDialogCompleteWithResponseCallbacks().add(dialogCompleteWithResponseCallback);
    }
}

