/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.exist.client.DialogCompleteWithResponse;
import org.exist.client.DialogWithResponse;
import org.exist.client.security.AutoCompletion;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class FindGroupForm
extends JFrame
implements DialogWithResponse<String> {
    private final UserManagementService userManagementService;
    private final List<DialogCompleteWithResponse<String>> dialogCompleteWithResponseCallbacks = new ArrayList<DialogCompleteWithResponse<String>>();
    private final Set<String> allGroupNames;
    private DefaultComboBoxModel groupNameModel;
    private JButton btnCancel;
    private JButton btnOk;
    private JComboBox cmbGroupName;
    private JSeparator jSeparator1;
    private JLabel lblGroupName;

    public FindGroupForm(UserManagementService userManagementService) throws XMLDBException {
        this.userManagementService = userManagementService;
        this.allGroupNames = new HashSet<String>();
        for (String groupName : userManagementService.getGroups()) {
            this.allGroupNames.add(groupName);
        }
        this.initComponents();
    }

    private void initComponents() {
        this.lblGroupName = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.cmbGroupName = new JComboBox();
        AutoCompletion.enable(this.cmbGroupName);
        this.setDefaultCloseOperation(2);
        this.setTitle("Find User...");
        this.lblGroupName.setText("Group:");
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(this::btnOkActionPerformed);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this::btnCancelActionPerformed);
        this.cmbGroupName.setEditable(true);
        this.cmbGroupName.setModel(this.getGroupNameModel());
        this.cmbGroupName.addActionListener(this::cmbGroupNameActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.lblGroupName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cmbGroupName, -2, 341, -2).addContainerGap(45, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOk))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGroupName).addComponent(this.cmbGroupName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancel)).addContainerGap(14, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void cmbGroupNameActionPerformed(ActionEvent evt) {
        String currentGroupName = (String)this.cmbGroupName.getSelectedItem();
        boolean isValid = this.isValidGroupName(currentGroupName);
        this.btnOk.setEnabled(isValid);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        String currentGroupName = (String)this.cmbGroupName.getSelectedItem();
        if (!this.isValidGroupName(currentGroupName)) {
            return;
        }
        for (DialogCompleteWithResponse<String> callback : this.getDialogCompleteWithResponseCallbacks()) {
            callback.complete(currentGroupName);
        }
        this.setVisible(false);
        this.dispose();
    }

    private boolean isValidGroupName(String groupName) {
        return this.allGroupNames.contains(groupName);
    }

    private ComboBoxModel getGroupNameModel() {
        if (this.groupNameModel == null) {
            this.groupNameModel = new DefaultComboBoxModel();
            this.groupNameModel.addElement("");
            for (String groupName : this.allGroupNames) {
                this.groupNameModel.addElement(groupName);
            }
        }
        return this.groupNameModel;
    }

    private UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    @Override
    public void addDialogCompleteWithResponseCallback(DialogCompleteWithResponse<String> dialogCompleteWithResponseCallback) {
        this.getDialogCompleteWithResponseCallbacks().add(dialogCompleteWithResponseCallback);
    }

    private List<DialogCompleteWithResponse<String>> getDialogCompleteWithResponseCallbacks() {
        return this.dialogCompleteWithResponseCallbacks;
    }
}

