/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.exist.client.DialogCompleteWithResponse;
import org.exist.client.HighlightedTableCellRenderer;
import org.exist.client.security.FindUserForm;
import org.exist.client.security.ReadOnlyDefaultTableModel;
import org.exist.client.security.RegExpInputVerifier;
import org.exist.security.EXistSchemaType;
import org.exist.security.Group;
import org.exist.security.internal.aider.GroupAider;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class GroupDialog
extends JFrame {
    private static final long serialVersionUID = 2291775874309563932L;
    private final Pattern PTN_GROUPNAME = Pattern.compile("[a-zA-Z0-9\\-\\._@]{3,}");
    private final UserManagementService userManagementService;
    private final String currentUser;
    private DefaultTableModel groupMembersTableModel = null;
    protected JButton btnAddMember;
    private JButton btnClose;
    protected JButton btnCreate;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblDescription;
    private JLabel lblGroupMembers;
    private JLabel lblGroupName;
    protected JMenuItem miAddGroupMember;
    private JMenuItem miRemoveGroupMember;
    private JCheckBoxMenuItem micbGroupMemberManager;
    private JPopupMenu pmGroupMembers;
    protected JTable tblGroupMembers;
    protected JTextField txtDescription;
    protected JTextField txtGroupName;

    public GroupDialog(UserManagementService userManagementService, String currentUser) {
        this.userManagementService = userManagementService;
        this.currentUser = currentUser;
        this.initComponents();
        this.tblGroupMembers.setDefaultRenderer(Object.class, new HighlightedTableCellRenderer());
        this.addSelfAsManager();
    }

    public UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    protected final DefaultTableModel getGroupMembersTableModel() {
        if (this.groupMembersTableModel == null) {
            this.groupMembersTableModel = new ReadOnlyDefaultTableModel(null, new String[]{"Username", "Group Manager"}){

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    if (columnIndex == 1) {
                        return Boolean.class;
                    }
                    return super.getColumnClass(columnIndex);
                }
            };
        }
        return this.groupMembersTableModel;
    }

    protected void addSelfAsManager() {
        this.getGroupMembersTableModel().addRow(new Object[]{this.currentUser, Boolean.TRUE});
    }

    private void initComponents() {
        this.pmGroupMembers = new JPopupMenu();
        this.miAddGroupMember = new JMenuItem();
        this.micbGroupMemberManager = new JCheckBoxMenuItem();
        this.miRemoveGroupMember = new JMenuItem();
        this.lblGroupName = new JLabel();
        this.txtGroupName = new JTextField();
        this.lblDescription = new JLabel();
        this.txtDescription = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.tblGroupMembers = new JTable();
        this.lblGroupMembers = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.btnCreate = new JButton();
        this.btnClose = new JButton();
        this.btnAddMember = new JButton();
        this.miAddGroupMember.setText("Add Group Member...");
        this.miAddGroupMember.addActionListener(this::miAddGroupMemberActionPerformed);
        this.pmGroupMembers.add(this.miAddGroupMember);
        this.micbGroupMemberManager.setSelected(true);
        this.micbGroupMemberManager.setText("Group Manager");
        this.micbGroupMemberManager.addActionListener(this::micbGroupMemberManagerActionPerformed);
        this.pmGroupMembers.add(this.micbGroupMemberManager);
        this.miRemoveGroupMember.setText("Remove Group Member");
        this.miRemoveGroupMember.addActionListener(this::miRemoveGroupMemberActionPerformed);
        this.pmGroupMembers.add(this.miRemoveGroupMember);
        this.setDefaultCloseOperation(2);
        this.setTitle("New Group");
        this.setPreferredSize(new Dimension(446, 385));
        this.lblGroupName.setText("Group name:");
        this.txtGroupName.setInputVerifier(this.getGroupNameInputVerifier());
        this.lblDescription.setText("Description:");
        this.tblGroupMembers.setModel(this.getGroupMembersTableModel());
        this.tblGroupMembers.setAutoCreateRowSorter(true);
        this.tblGroupMembers.setComponentPopupMenu(this.pmGroupMembers);
        this.tblGroupMembers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GroupDialog.this.tblGroupMembersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblGroupMembers);
        this.lblGroupMembers.setText("Group Members:");
        this.btnCreate.setText("Create");
        this.btnCreate.addActionListener(this::btnCreateActionPerformed);
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this::btnCloseActionPerformed);
        this.btnAddMember.setText("Add Group Member...");
        this.btnAddMember.addActionListener(this::btnAddMemberActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblGroupName).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.lblDescription).addGap(21, 21, 21))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtDescription, -1, 279, Short.MAX_VALUE).addComponent(this.txtGroupName)).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lblGroupMembers).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreate).addGap(16, 16, 16)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnAddMember).addContainerGap(251, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGroupName).addComponent(this.txtGroupName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtDescription, -2, -1, -2).addComponent(this.lblDescription)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblGroupMembers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.btnAddMember).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnClose).addComponent(this.btnCreate)).addContainerGap()));
        this.pack();
    }

    private InputVerifier getGroupNameInputVerifier() {
        return new RegExpInputVerifier(this.PTN_GROUPNAME);
    }

    private boolean isValidGroupName() {
        if (this.PTN_GROUPNAME.matcher(this.txtGroupName.getText()).matches()) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "Group Name must be at least 3 characters (" + this.PTN_GROUPNAME.toString() + ")");
        return false;
    }

    private boolean isValidGroupDetails() {
        return this.isValidGroupName();
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        if (!this.isValidGroupDetails()) {
            return;
        }
        this.createGroup();
        this.setVisible(false);
        this.dispose();
    }

    protected void createGroup() {
        Group group = null;
        try {
            GroupAider groupAider = new GroupAider(this.txtGroupName.getText());
            groupAider.setMetadataValue(EXistSchemaType.DESCRIPTION, this.txtDescription.getText());
            this.getUserManagementService().addGroup(groupAider);
            group = this.getUserManagementService().getGroup(this.txtGroupName.getText());
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not create group '" + this.txtGroupName.getText() + "': " + xmldbe.getMessage(), "Create Group Error", 0);
            return;
        }
        for (int i = 0; i < this.getGroupMembersTableModel().getRowCount(); ++i) {
            String member = (String)this.getGroupMembersTableModel().getValueAt(i, 0);
            try {
                this.getUserManagementService().addAccountToGroup(member, group.getName());
                boolean isManager = (Boolean)this.getGroupMembersTableModel().getValueAt(i, 1);
                if (!isManager) continue;
                this.getUserManagementService().addGroupManager(member, group.getName());
                continue;
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(this, "Could not add user '" + member + "' to group '" + group.getName() + "': " + xmldbe.getMessage(), "Create Group Error", 0);
                return;
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    protected boolean canModifyGroupMembers() {
        return true;
    }

    protected boolean canModifySelectedGroupMember() {
        return this.tblGroupMembers.getSelectedRow() > -1;
    }

    private void tblGroupMembersMouseClicked(MouseEvent evt) {
        this.micbGroupMemberManager.setEnabled(this.canModifySelectedGroupMember());
        this.micbGroupMemberManager.setState(this.isSelectedMemberManager());
        this.miRemoveGroupMember.setEnabled(this.canModifySelectedGroupMember());
    }

    private void micbGroupMemberManagerActionPerformed(ActionEvent evt) {
        this.getGroupMembersTableModel().setValueAt(!this.isSelectedMemberManager(), this.tblGroupMembers.getSelectedRow(), 1);
    }

    private void miRemoveGroupMemberActionPerformed(ActionEvent evt) {
        int row = this.tblGroupMembers.getSelectedRow();
        this.getGroupMembersTableModel().removeRow(row);
    }

    private void btnAddMemberActionPerformed(ActionEvent evt) {
        this.showFindUserForm();
    }

    private void miAddGroupMemberActionPerformed(ActionEvent evt) {
        this.showFindUserForm();
    }

    protected String getSelectedMember() {
        int row = this.tblGroupMembers.getSelectedRow();
        return (String)this.getGroupMembersTableModel().getValueAt(row, 0);
    }

    protected boolean isSelectedMemberManager() {
        int row = this.tblGroupMembers.getSelectedRow();
        return (Boolean)this.getGroupMembersTableModel().getValueAt(row, 1);
    }

    private void showFindUserForm() {
        DialogCompleteWithResponse<String> callback = username -> {
            if (!this.groupMembersContains((String)username)) {
                this.getGroupMembersTableModel().addRow(new Object[]{username, false});
            }
        };
        try {
            FindUserForm findUserForm = new FindUserForm(this.getUserManagementService());
            findUserForm.addDialogCompleteWithResponseCallback(callback);
            findUserForm.setTitle("Add User to Group...");
            findUserForm.setVisible(true);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not retrieve list of users: " + xmldbe.getMessage(), "Add Member Error", 0);
            return;
        }
    }

    private boolean groupMembersContains(String username) {
        for (int i = 0; i < this.getGroupMembersTableModel().getRowCount(); ++i) {
            String member = (String)this.getGroupMembersTableModel().getValueAt(i, 0);
            if (!member.equals(username)) continue;
            return true;
        }
        return false;
    }

    protected String getCurrentUser() {
        return this.currentUser;
    }
}

