/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class UmaskDocumentFilter
extends DocumentFilter {
    static final Pattern ptnUmask = Pattern.compile("0?[0-7]{1,3}");
    final Matcher mtcUmask = ptnUmask.matcher("");

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        Document doc = fb.getDocument();
        String original = doc.getText(0, doc.getLength());
        if (this.isValidUmask(this.removeFromString(original, offset, length))) {
            super.remove(fb, offset, length);
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        Document doc = fb.getDocument();
        String original = doc.getText(0, doc.getLength());
        if (this.isValidUmask(this.insertIntoString(original, text, offset))) {
            super.insertString(fb, offset, text, attr);
        }
    }

    private String removeFromString(String original, int offset, int length) {
        String newString;
        if (offset > 0) {
            newString = original.substring(0, offset + length - 1);
            if (offset + length < original.length()) {
                newString = newString + original.substring(offset + length);
            }
        } else {
            newString = original.substring(offset + length);
        }
        return newString;
    }

    private String insertIntoString(String original, String toInsert, int offset) {
        String newString;
        if (offset > 0) {
            newString = original.substring(0, offset);
            newString = newString + toInsert;
            if (offset < original.length()) {
                newString = newString + original.substring(offset);
            }
        } else {
            newString = toInsert + original;
        }
        return newString;
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        Document doc = fb.getDocument();
        String original = doc.getText(0, doc.getLength());
        String str = length > 0 ? this.removeFromString(original, offset, length) : original;
        if (this.isValidUmask(str = this.insertIntoString(str, text, offset))) {
            super.replace(fb, offset, length, text, attrs);
        }
    }

    private boolean isValidUmask(String str) {
        this.mtcUmask.reset(str);
        return this.mtcUmask.matches();
    }
}

