/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import javax.swing.AbstractSpinnerModel;

public class UmaskSpinnerModel
extends AbstractSpinnerModel {
    private int umask = 501;
    public static final int OCTAL_RADIX = 8;

    @Override
    public Object getValue() {
        return UmaskSpinnerModel.intToOctalUmask(this.umask);
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !(value instanceof String)) {
            throw new IllegalArgumentException("illegal value");
        }
        int otherUmask = UmaskSpinnerModel.octalUmaskToInt((String)value);
        if (otherUmask != this.umask) {
            this.umask = otherUmask;
            this.fireStateChanged();
        }
    }

    @Override
    public Object getNextValue() {
        String result = this.umask < 511 ? UmaskSpinnerModel.intToOctalUmask(this.nextUmask(this.umask)) : "0777";
        return result;
    }

    @Override
    public Object getPreviousValue() {
        String result = this.umask > 0 ? UmaskSpinnerModel.intToOctalUmask(this.prevUmask(this.umask)) : "0000";
        return result;
    }

    private int prevUmask(int umask) {
        if (umask == 56) {
            return 7;
        }
        if (umask == 448) {
            return 63;
        }
        return umask - 1;
    }

    private int nextUmask(int umask) {
        if (umask == 7) {
            return 8;
        }
        if (umask == 56) {
            return 64;
        }
        return umask + 1;
    }

    public static int octalUmaskToInt(String octalUmask) {
        return Integer.parseInt(octalUmask, 8);
    }

    public static String intToOctalUmask(int umask) {
        return String.format("%4s", Integer.toString(umask, 8)).replace(' ', '0');
    }
}

