/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.security;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.exist.client.InteractiveClient;
import org.exist.client.security.MemberOfGroupsListCellRenderer;
import org.exist.client.security.RegExpInputVerifier;
import org.exist.client.security.SortedListModel;
import org.exist.client.security.UmaskEditor;
import org.exist.client.security.UmaskSpinnerModel;
import org.exist.security.AXSchemaType;
import org.exist.security.EXistSchemaType;
import org.exist.security.PermissionDeniedException;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.xmldb.UserManagementService;
import org.xmldb.api.base.XMLDBException;

public class UserDialog
extends JFrame {
    private static final long serialVersionUID = -7544980948396443454L;
    private final Pattern PTN_USERNAME = Pattern.compile("[a-zA-Z0-9\\-\\._@]{3,}");
    private final Pattern PTN_PASSWORD = Pattern.compile(".{3,}");
    private UserManagementService userManagementService;
    private SortedListModel<String> availableGroupsModel = null;
    private SortedListModel<String> memberOfGroupsModel = null;
    private String primaryGroup = null;
    private MemberOfGroupsListCellRenderer memberOfGroupsListCellRenderer = null;
    private JButton btnAddGroup;
    private JButton btnClose;
    protected JButton btnCreate;
    private JButton btnRemoveGroup;
    protected JCheckBox cbDisabled;
    protected JCheckBox cbPersonalGroup;
    private JCheckBoxMenuItem cbmiPrimaryGroup;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel lblAvailableGroups;
    private JLabel lblDescription;
    private JLabel lblFullName;
    private JLabel lblMemberOfGroups;
    private JLabel lblPassword;
    private JLabel lblPasswordConfirm;
    private JLabel lblUmask;
    private JLabel lblUsername;
    private JList lstAvailableGroups;
    private JList lstMemberOfGroups;
    private JPopupMenu pmMemberOfGroups;
    protected JSpinner spnUmask;
    protected JTextField txtDescription;
    protected JTextField txtFullName;
    protected JPasswordField txtPassword;
    protected JPasswordField txtPasswordConfirm;
    protected JTextField txtUsername;

    public UserDialog(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
        this.setIconImage(InteractiveClient.getExistIcon(this.getClass()).getImage());
        this.initComponents();
    }

    private void initComponents() {
        this.pmMemberOfGroups = new JPopupMenu();
        this.cbmiPrimaryGroup = new JCheckBoxMenuItem();
        this.jSeparator1 = new JSeparator();
        this.lblUsername = new JLabel();
        this.txtUsername = new JTextField();
        this.lblFullName = new JLabel();
        this.txtFullName = new JTextField();
        this.lblDescription = new JLabel();
        this.txtDescription = new JTextField();
        this.lblPassword = new JLabel();
        this.txtPassword = new JPasswordField();
        this.lblPasswordConfirm = new JLabel();
        this.txtPasswordConfirm = new JPasswordField();
        this.cbDisabled = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.spnUmask = new JSpinner();
        this.lblUmask = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.btnClose = new JButton();
        this.btnCreate = new JButton();
        this.cbPersonalGroup = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.lstMemberOfGroups = new JList();
        this.lblMemberOfGroups = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstAvailableGroups = new JList();
        this.lblAvailableGroups = new JLabel();
        this.btnAddGroup = new JButton();
        this.btnRemoveGroup = new JButton();
        this.jSeparator4 = new JSeparator();
        this.cbmiPrimaryGroup.setSelected(true);
        this.cbmiPrimaryGroup.setText("Primary Group");
        this.cbmiPrimaryGroup.addActionListener(this::cbmiPrimaryGroupActionPerformed);
        this.pmMemberOfGroups.add(this.cbmiPrimaryGroup);
        this.setDefaultCloseOperation(2);
        this.setTitle("New User");
        this.lblUsername.setText("User name:");
        this.txtUsername.setInputVerifier(this.getUsernameInputVerifier());
        this.lblFullName.setText("Full name:");
        this.lblDescription.setText("Description:");
        this.lblPassword.setText("Password:");
        this.txtPassword.setInputVerifier(this.getPasswordInputVerifier());
        this.lblPasswordConfirm.setText("Confirm password:");
        this.txtPasswordConfirm.setInputVerifier(this.getPasswordInputVerifier());
        this.cbDisabled.setText("Account is disabled");
        this.spnUmask.setModel(new UmaskSpinnerModel());
        this.spnUmask.setEditor(new UmaskEditor(this.spnUmask));
        this.spnUmask.setValue(this.getUmask());
        this.lblUmask.setText("umask:");
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this::btnCloseActionPerformed);
        this.btnCreate.setText("Create");
        this.btnCreate.addActionListener(this::btnCreateActionPerformed);
        this.cbPersonalGroup.setSelected(true);
        this.cbPersonalGroup.setText("Create personal user group");
        this.lstMemberOfGroups.setModel(this.getMemberOfGroupsListModel());
        this.lstMemberOfGroups.setCellRenderer(this.getMemberOfGroupsListCellRenderer());
        this.lstMemberOfGroups.setComponentPopupMenu(this.pmMemberOfGroups);
        this.lstMemberOfGroups.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UserDialog.this.lstMemberOfGroupsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstMemberOfGroups);
        this.lblMemberOfGroups.setText("Member of Groups:");
        this.lstAvailableGroups.setModel(this.getAvailableGroupsListModel());
        this.jScrollPane2.setViewportView(this.lstAvailableGroups);
        this.lblAvailableGroups.setText("Available Groups:");
        this.btnAddGroup.setText("->");
        this.btnAddGroup.setToolTipText("Add to Group");
        this.btnAddGroup.addActionListener(this::btnAddGroupActionPerformed);
        this.btnRemoveGroup.setText("<-");
        this.btnRemoveGroup.setToolTipText("Remove from Group");
        this.btnRemoveGroup.addActionListener(this::btnRemoveGroupActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.btnClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreate).addGap(6, 6, 6)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jScrollPane2, -2, 177, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnAddGroup, -2, 58, -2).addComponent(this.btnRemoveGroup, -2, 0, Short.MAX_VALUE))).addComponent(this.lblAvailableGroups)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMemberOfGroups).addComponent(this.jScrollPane1, -2, 177, -2))))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblDescription).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)).addGroup(layout.createSequentialGroup().addComponent(this.lblFullName).addGap(24, 24, 24))).addGroup(layout.createSequentialGroup().addComponent(this.lblUsername).addGap(3, 3, 3))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.txtUsername, -1, 296, Short.MAX_VALUE).addComponent(this.txtFullName, GroupLayout.Alignment.LEADING).addComponent(this.txtDescription, GroupLayout.Alignment.LEADING))).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPasswordConfirm).addComponent(this.lblPassword)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtPassword, -1, 248, Short.MAX_VALUE).addComponent(this.txtPasswordConfirm)))).addGap(0, 35, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator4).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING)))).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.lblUmask).addGap(18, 18, 18).addComponent(this.spnUmask, -2, 76, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2).addComponent(this.jSeparator3)).addContainerGap()))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.cbDisabled)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cbPersonalGroup))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUsername).addComponent(this.txtUsername, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFullName).addComponent(this.txtFullName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDescription).addComponent(this.txtDescription, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.txtPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPasswordConfirm, -2, -1, -2).addComponent(this.lblPasswordConfirm)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDisabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spnUmask, -2, -1, -2).addComponent(this.lblUmask)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPersonalGroup).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMemberOfGroups, GroupLayout.Alignment.TRAILING).addComponent(this.lblAvailableGroups)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, -1, -2).addComponent(this.jScrollPane2, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGap(52, 52, 52).addComponent(this.btnAddGroup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemoveGroup))).addGap(10, 10, 10).addComponent(this.jSeparator4, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnClose).addComponent(this.btnCreate)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        if (!this.isValidUserDetails()) {
            return;
        }
        this.createUser();
        this.setVisible(false);
        this.dispose();
    }

    protected void createUser() {
        GroupAider groupAider = null;
        if (this.cbPersonalGroup.isSelected()) {
            groupAider = new GroupAider(this.txtUsername.getText());
            groupAider.setMetadataValue(EXistSchemaType.DESCRIPTION, "Personal group for " + this.txtUsername.getText());
            try {
                this.getUserManagementService().addGroup(groupAider);
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(this, "Could not create personal group '" + this.txtUsername.getText() + "': " + xmldbe.getMessage(), "Create User Error", 0);
                return;
            }
        }
        UserAider userAider = new UserAider(this.txtUsername.getText());
        userAider.setMetadataValue(AXSchemaType.FULLNAME, this.txtFullName.getText());
        userAider.setMetadataValue(EXistSchemaType.DESCRIPTION, this.txtDescription.getText());
        userAider.setPassword(this.txtPassword.getText());
        userAider.setEnabled(!this.cbDisabled.isSelected());
        userAider.setUserMask(UmaskSpinnerModel.octalUmaskToInt((String)this.spnUmask.getValue()));
        if (this.cbPersonalGroup.isSelected()) {
            userAider.addGroup(this.txtUsername.getText());
        }
        Iterator<String> itMemberOfGroups = this.memberOfGroupsModel.iterator();
        while (itMemberOfGroups.hasNext()) {
            String memberOfGroup = itMemberOfGroups.next();
            userAider.addGroup(memberOfGroup);
        }
        try {
            userAider.setPrimaryGroup(new GroupAider(this.getPrimaryGroup()));
        }
        catch (PermissionDeniedException pde) {
            JOptionPane.showMessageDialog(this, "Could not set primary group '" + this.getPrimaryGroup() + "' of user '" + this.txtUsername.getText() + "': " + pde.getMessage(), "Create User Error", 0);
            return;
        }
        try {
            this.getUserManagementService().addAccount(userAider);
        }
        catch (XMLDBException xmldbe) {
            JOptionPane.showMessageDialog(this, "Could not create user '" + this.txtUsername.getText() + "': " + xmldbe.getMessage(), "Create User Error", 0);
            return;
        }
        if (this.cbPersonalGroup.isSelected()) {
            try {
                groupAider.addManager(userAider);
                this.getUserManagementService().updateGroup(groupAider);
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(this, "Could not set user '" + this.txtUsername.getText() + "' as manager of personal group '" + this.txtUsername.getText() + "': " + xmldbe.getMessage(), "Create User Error", 0);
                return;
            }
            catch (PermissionDeniedException pde) {
                JOptionPane.showMessageDialog(this, "Could not set user '" + this.txtUsername.getText() + "' as manager of personal group '" + this.txtUsername.getText() + "': " + pde.getMessage(), "Create User Error", 0);
                return;
            }
        }
    }

    private void btnAddGroupActionPerformed(ActionEvent evt) {
        for (Object value : this.lstAvailableGroups.getSelectedValues()) {
            this.memberOfGroupsModel.add(value.toString());
            this.availableGroupsModel.removeElement(value.toString());
            if (this.getMemberOfGroupsListModel().getSize() != 1) continue;
            String firstGroup = (String)this.getMemberOfGroupsListModel().getElementAt(0);
            this.setPrimaryGroup(firstGroup);
            this.getMemberOfGroupsListCellRenderer().setCellOfInterest(this.getPrimaryGroup());
        }
    }

    private void btnRemoveGroupActionPerformed(ActionEvent evt) {
        for (Object value : this.lstMemberOfGroups.getSelectedValues()) {
            String group = value.toString();
            this.availableGroupsModel.add(group);
            this.memberOfGroupsModel.removeElement(group);
            if (!this.getPrimaryGroup().equals(group)) continue;
            if (this.getMemberOfGroupsListModel().getSize() == 0) {
                this.setPrimaryGroup(null);
            } else {
                String firstGroup = (String)this.getMemberOfGroupsListModel().getElementAt(0);
                this.setPrimaryGroup(firstGroup);
            }
            this.getMemberOfGroupsListCellRenderer().setCellOfInterest(this.getPrimaryGroup());
        }
    }

    private void cbmiPrimaryGroupActionPerformed(ActionEvent evt) {
        this.primaryGroup = (String)this.getMemberOfGroupsListModel().getElementAt(this.lstMemberOfGroups.getSelectedIndex());
        this.getMemberOfGroupsListCellRenderer().setCellOfInterest(this.primaryGroup);
    }

    private void lstMemberOfGroupsMouseClicked(MouseEvent evt) {
        this.cbmiPrimaryGroup.setState(((String)this.getMemberOfGroupsListModel().getElementAt(this.lstMemberOfGroups.getSelectedIndex())).equals(this.primaryGroup));
    }

    private boolean isValidUserDetails() {
        return this.isValidUsername() && this.isValidPassword() && this.isValidGroups();
    }

    private boolean isValidUsername() {
        if (this.PTN_USERNAME.matcher(this.txtUsername.getText()).matches()) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "Username must be at least 3 characters (" + this.PTN_USERNAME.toString() + ")");
        return false;
    }

    private boolean isValidPassword() {
        if (this.txtPassword != null && this.PTN_PASSWORD.matcher(this.txtPassword.getText()).matches() && this.txtPassword.getText().equals(this.txtPasswordConfirm.getText())) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "Passwords do not match or are less than 3 characters.");
        return false;
    }

    private boolean isValidGroups() {
        if (this.cbPersonalGroup.isSelected() || this.memberOfGroupsModel.getSize() > 0) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "The user must be in at least one group, or a personal group must be created for them.");
        return false;
    }

    private InputVerifier getUsernameInputVerifier() {
        return new RegExpInputVerifier(this.PTN_USERNAME);
    }

    private InputVerifier getPasswordInputVerifier() {
        return new RegExpInputVerifier(this.PTN_PASSWORD);
    }

    private String getUmask() {
        return String.format("%4s", Integer.toString(18, 8)).replace(' ', '0');
    }

    protected SortedListModel getAvailableGroupsListModel() {
        if (this.availableGroupsModel == null) {
            try {
                String[] groupNames = this.getUserManagementService().getGroups();
                this.availableGroupsModel = new SortedListModel();
                this.availableGroupsModel.addAll((String[])groupNames);
            }
            catch (XMLDBException xmldbe) {
                JOptionPane.showMessageDialog(this, "Could not get available groups: " + xmldbe.getMessage(), "Create User Error", 0);
            }
        }
        return this.availableGroupsModel;
    }

    protected SortedListModel getMemberOfGroupsListModel() {
        if (this.memberOfGroupsModel == null) {
            this.memberOfGroupsModel = new SortedListModel();
        }
        return this.memberOfGroupsModel;
    }

    protected UserManagementService getUserManagementService() {
        return this.userManagementService;
    }

    protected void setPrimaryGroup(String primaryGroup) {
        this.primaryGroup = primaryGroup;
    }

    protected String getPrimaryGroup() {
        return this.primaryGroup;
    }

    protected void setUserManagementService(UserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    protected MemberOfGroupsListCellRenderer getMemberOfGroupsListCellRenderer() {
        if (this.memberOfGroupsListCellRenderer == null) {
            this.memberOfGroupsListCellRenderer = new MemberOfGroupsListCellRenderer();
        }
        return this.memberOfGroupsListCellRenderer;
    }
}

