/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import org.exist.EXistException;
import org.exist.Resource;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionMetadata;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionFactory;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.IndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.SyntaxException;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public interface Collection
extends Resource,
Comparable<Collection>,
Cacheable {
    public static final int LENGTH_COLLECTION_ID = 4;
    public static final int UNKNOWN_COLLECTION_ID = -1;

    public Lock getLock();

    public void release(Lock.LockMode var1);

    public int getId();

    public void setId(int var1);

    public void setAddress(long var1);

    public long getAddress();

    @Override
    public XmldbURI getURI();

    public void setPath(XmldbURI var1);

    @Override
    public CollectionMetadata getMetadata();

    @Override
    public Permission getPermissions();

    public Permission getPermissionsNoLock();

    public void setPermissions(int var1) throws LockException, PermissionDeniedException;

    @Deprecated
    public void setPermissions(String var1) throws SyntaxException, LockException, PermissionDeniedException;

    @Deprecated
    public void setPermissions(Permission var1) throws LockException;

    @Deprecated
    public long getCreationTime();

    public void setCreationTime(long var1);

    public boolean isCollectionConfigEnabled();

    public void setCollectionConfigEnabled(boolean var1);

    public CollectionConfiguration getConfiguration(DBBroker var1);

    public IndexSpec getIndexConfiguration(DBBroker var1);

    public GeneralRangeIndexSpec getIndexByPathConfiguration(DBBroker var1, NodePath var2);

    public QNameRangeIndexSpec getIndexByQNameConfiguration(DBBroker var1, QName var2);

    public boolean isTempCollection();

    public boolean isTriggersEnabled();

    public void setTriggersEnabled(boolean var1);

    public int getMemorySize();

    public XmldbURI getParentURI();

    public void setReader(XMLReader var1);

    public boolean isEmpty(DBBroker var1) throws PermissionDeniedException;

    public int getDocumentCount(DBBroker var1) throws PermissionDeniedException;

    @Deprecated
    public int getDocumentCountNoLock(DBBroker var1) throws PermissionDeniedException;

    public int getChildCollectionCount(DBBroker var1) throws PermissionDeniedException;

    public boolean hasDocument(DBBroker var1, XmldbURI var2) throws PermissionDeniedException;

    public boolean hasChildCollection(DBBroker var1, XmldbURI var2) throws PermissionDeniedException, LockException;

    @Deprecated
    public boolean hasChildCollectionNoLock(DBBroker var1, XmldbURI var2) throws PermissionDeniedException;

    public void addCollection(DBBroker var1, Collection var2, boolean var3) throws PermissionDeniedException, LockException;

    public List<CollectionEntry> getEntries(DBBroker var1) throws PermissionDeniedException, LockException;

    public CollectionEntry getChildCollectionEntry(DBBroker var1, String var2) throws PermissionDeniedException;

    public CollectionEntry getResourceEntry(DBBroker var1, String var2) throws PermissionDeniedException, LockException;

    public void update(DBBroker var1, Collection var2) throws PermissionDeniedException, LockException;

    public void addDocument(Txn var1, DBBroker var2, DocumentImpl var3) throws PermissionDeniedException, LockException;

    public void unlinkDocument(DBBroker var1, DocumentImpl var2) throws PermissionDeniedException, LockException;

    public Iterator<XmldbURI> collectionIterator(DBBroker var1) throws PermissionDeniedException, LockException;

    @Deprecated
    public Iterator<XmldbURI> collectionIteratorNoLock(DBBroker var1) throws PermissionDeniedException;

    public Iterator<DocumentImpl> iterator(DBBroker var1) throws PermissionDeniedException, LockException;

    @Deprecated
    public Iterator<DocumentImpl> iteratorNoLock(DBBroker var1) throws PermissionDeniedException;

    public List<Collection> getDescendants(DBBroker var1, Subject var2) throws PermissionDeniedException;

    public MutableDocumentSet allDocs(DBBroker var1, MutableDocumentSet var2, boolean var3) throws PermissionDeniedException;

    public MutableDocumentSet allDocs(DBBroker var1, MutableDocumentSet var2, boolean var3, LockedDocumentMap var4) throws PermissionDeniedException;

    public DocumentSet allDocs(DBBroker var1, MutableDocumentSet var2, boolean var3, LockedDocumentMap var4, Lock.LockMode var5) throws LockException, PermissionDeniedException;

    public DocumentSet getDocuments(DBBroker var1, MutableDocumentSet var2) throws PermissionDeniedException, LockException;

    @Deprecated
    public DocumentSet getDocumentsNoLock(DBBroker var1, MutableDocumentSet var2);

    public DocumentSet getDocuments(DBBroker var1, MutableDocumentSet var2, LockedDocumentMap var3, Lock.LockMode var4) throws LockException, PermissionDeniedException;

    public DocumentImpl getDocument(DBBroker var1, XmldbURI var2) throws PermissionDeniedException;

    @Deprecated
    public DocumentImpl getDocumentWithLock(DBBroker var1, XmldbURI var2) throws LockException, PermissionDeniedException;

    public DocumentImpl getDocumentWithLock(DBBroker var1, XmldbURI var2, Lock.LockMode var3) throws LockException, PermissionDeniedException;

    @Deprecated
    public DocumentImpl getDocumentNoLock(DBBroker var1, String var2) throws PermissionDeniedException;

    @Deprecated
    public void releaseDocument(DocumentImpl var1);

    public void releaseDocument(DocumentImpl var1, Lock.LockMode var2);

    public void removeCollection(DBBroker var1, XmldbURI var2) throws LockException, PermissionDeniedException;

    public void removeResource(Txn var1, DBBroker var2, DocumentImpl var3) throws PermissionDeniedException, LockException, IOException, TriggerException;

    public void removeXMLResource(Txn var1, DBBroker var2, XmldbURI var3) throws PermissionDeniedException, TriggerException, LockException, IOException;

    public void removeBinaryResource(Txn var1, DBBroker var2, XmldbURI var3) throws PermissionDeniedException, LockException, TriggerException;

    public void removeBinaryResource(Txn var1, DBBroker var2, DocumentImpl var3) throws PermissionDeniedException, LockException, TriggerException;

    public IndexInfo validateXMLResource(Txn var1, DBBroker var2, XmldbURI var3, InputSource var4) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException;

    public IndexInfo validateXMLResource(Txn var1, DBBroker var2, XmldbURI var3, String var4) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException;

    public IndexInfo validateXMLResource(Txn var1, DBBroker var2, XmldbURI var3, Node var4) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException, IOException;

    public void store(Txn var1, DBBroker var2, IndexInfo var3, InputSource var4) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException;

    public void store(Txn var1, DBBroker var2, IndexInfo var3, String var4) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException;

    public void store(Txn var1, DBBroker var2, IndexInfo var3, Node var4) throws EXistException, PermissionDeniedException, TriggerException, SAXException, LockException;

    public BinaryDocument validateBinaryResource(Txn var1, DBBroker var2, XmldbURI var3) throws PermissionDeniedException, LockException, TriggerException, IOException;

    public BinaryDocument addBinaryResource(Txn var1, DBBroker var2, XmldbURI var3, InputStream var4, String var5, long var6, Date var8, Date var9) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException;

    @Deprecated
    public BinaryDocument addBinaryResource(Txn var1, DBBroker var2, XmldbURI var3, byte[] var4, String var5) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException;

    @Deprecated
    public BinaryDocument addBinaryResource(Txn var1, DBBroker var2, XmldbURI var3, byte[] var4, String var5, Date var6, Date var7) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException;

    public BinaryDocument addBinaryResource(Txn var1, DBBroker var2, XmldbURI var3, InputStream var4, String var5, long var6) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException;

    public BinaryDocument addBinaryResource(Txn var1, DBBroker var2, BinaryDocument var3, InputStream var4, String var5, long var6, Date var8, Date var9) throws EXistException, PermissionDeniedException, LockException, TriggerException, IOException;

    public Observable getObservable();

    public void serialize(VariableByteOutputStream var1) throws IOException, LockException;

    public static class DocumentEntry
    extends CollectionEntry {
        public DocumentEntry(DocumentImpl document) {
            super(document.getURI(), document.getPermissions());
            this.setCreated(document.getMetadata().getCreated());
        }

        @Override
        public void readMetadata(DBBroker broker) {
        }

        @Override
        public void read(VariableByteInput is) throws IOException {
        }
    }

    public static class SubCollectionEntry
    extends CollectionEntry {
        public SubCollectionEntry(SecurityManager sm, XmldbURI uri) {
            super(uri, PermissionFactory.getDefaultCollectionPermission(sm));
        }

        @Override
        public void readMetadata(DBBroker broker) {
            broker.readCollectionEntry(this);
        }

        @Override
        public void read(VariableByteInput is) throws IOException {
            is.skip(1);
            int collLen = is.readInt();
            for (int i = 0; i < collLen; ++i) {
                is.readUTF();
            }
            this.getPermissions().read(is);
            this.setCreated(is.readLong());
        }

        public void read(Collection collection) {
            this.setPermissions(collection.getPermissionsNoLock());
            this.setCreated(collection.getCreationTime());
        }
    }

    public static abstract class CollectionEntry {
        private final XmldbURI uri;
        private Permission permissions;
        private long created = -1L;

        protected CollectionEntry(XmldbURI uri, Permission permissions) {
            this.uri = uri;
            this.permissions = permissions;
        }

        public abstract void readMetadata(DBBroker var1);

        public abstract void read(VariableByteInput var1) throws IOException;

        public XmldbURI getUri() {
            return this.uri;
        }

        public long getCreated() {
            return this.created;
        }

        protected void setCreated(long created) {
            this.created = created;
        }

        public Permission getPermissions() {
            return this.permissions;
        }

        protected void setPermissions(Permission permissions) {
            this.permissions = permissions;
        }
    }

    public static interface InternalAccess {
        public void addDocument(DocumentImpl var1) throws EXistException;

        public int getId();
    }
}

