/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.cache.LRUCache;
import org.exist.storage.lock.Lock;
import org.exist.util.hashtable.Object2LongHashMap;
import org.exist.util.hashtable.SequencedLongHashMap;
import org.exist.xmldb.XmldbURI;

@NotThreadSafe
public class CollectionCache
extends LRUCache<Collection>
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(CollectionCache.class);
    private final BrokerPool pool;
    private Object2LongHashMap<String> names;

    public CollectionCache(BrokerPool pool, int blockBuffers, double growthThreshold) {
        super("collection cache", blockBuffers, 2.0, growthThreshold, "DATA");
        this.pool = pool;
        this.names = new Object2LongHashMap(blockBuffers);
    }

    @Override
    public void add(Collection collection) {
        this.add(collection, 1);
    }

    @Override
    public void add(Collection collection, int initialRefCount) {
        if (!this.pool.isOperational()) {
            return;
        }
        super.add(collection, initialRefCount);
        String name = collection.getURI().getRawCollectionPath();
        this.names.put(name, collection.getKey());
    }

    @Override
    public Collection get(Collection collection) {
        return (Collection)this.get(collection.getKey());
    }

    @Override
    public Collection get(XmldbURI name) {
        long key = this.names.get(name.getRawCollectionPath());
        if (key < 0L) {
            return null;
        }
        return (Collection)this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeOne(Collection item) {
        boolean removed = false;
        SequencedLongHashMap.Entry next = this.map.getFirstEntry();
        int tries = 0;
        do {
            Lock lock;
            Collection cached;
            if ((cached = (Collection)next.getValue()).getKey() != item.getKey() && (lock = cached.getLock()).attempt(Lock.LockMode.READ_LOCK)) {
                try {
                    if (cached.allowUnload()) {
                        if (this.pool.getConfigurationManager() != null) {
                            this.pool.getConfigurationManager().invalidate(cached.getURI(), null);
                        }
                        this.names.remove(cached.getURI().getRawCollectionPath());
                        cached.sync(true);
                        this.map.remove(cached.getKey());
                        removed = true;
                    }
                }
                finally {
                    lock.release(Lock.LockMode.READ_LOCK);
                }
            }
            if (removed) continue;
            if ((next = next.getNext()) == null && tries < 2) {
                next = this.map.getFirstEntry();
                ++tries;
                continue;
            }
            LOG.info("Unable to remove entry");
            removed = true;
        } while (!removed);
        this.cacheManager.requestMem(this);
    }

    @Override
    public void remove(Collection item) {
        super.remove(item);
        this.names.remove(item.getURI().getRawCollectionPath());
        if (this.pool.getConfigurationManager() != null) {
            this.pool.getConfigurationManager().invalidate(item.getURI(), null);
        }
    }

    public int getRealSize() {
        int size = 0;
        Iterator<Long> i = this.names.valueIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)this.get(i.next());
            if (collection == null) continue;
            size += collection.getMemorySize();
        }
        return size;
    }

    @Override
    public void resize(int newSize) {
        if (newSize < this.max) {
            this.shrink(newSize);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Growing collection cache to " + newSize);
            }
            SequencedLongHashMap<Collection> newMap = new SequencedLongHashMap<Collection>(newSize * 2);
            Object2LongHashMap<String> newNames = new Object2LongHashMap<String>(newSize);
            for (SequencedLongHashMap.Entry next = this.map.getFirstEntry(); next != null; next = next.getNext()) {
                Collection cacheable = (Collection)next.getValue();
                newMap.put(cacheable.getKey(), cacheable);
                newNames.put(cacheable.getURI().getRawCollectionPath(), cacheable.getKey());
            }
            this.max = newSize;
            this.map = newMap;
            this.names = newNames;
            this.accounting.reset();
            this.accounting.setTotalSize(this.max);
        }
    }

    @Override
    protected void shrink(int newSize) {
        super.shrink(newSize);
        this.names = new Object2LongHashMap(newSize);
    }
}

