/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.CollectionURI;
import org.exist.collections.IndexInfo;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.DBBroker;
import org.exist.storage.IndexSpec;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.Locked;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.sanity.SanityCheck;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class CollectionConfigurationManager
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(CollectionConfigurationManager.class);
    public static final String CONFIG_COLLECTION = "/db/system/config";
    public static final XmldbURI CONFIG_COLLECTION_URI = XmldbURI.create("/db/system/config");
    public static final XmldbURI ROOT_COLLECTION_CONFIG_URI = CONFIG_COLLECTION_URI.append("db");
    public static final String COLLECTION_CONFIG_FILENAME = "collection.xconf";
    public static final CollectionURI COLLECTION_CONFIG_PATH = new CollectionURI(CONFIG_COLLECTION_URI.getRawCollectionPath());
    private Map<CollectionURI, CollectionConfiguration> configurations = new HashMap<CollectionURI, CollectionConfiguration>();
    private Locked latch = new Locked();
    private CollectionConfiguration defaultConfig;

    public CollectionConfigurationManager(BrokerPool brokerPool) {
        this.defaultConfig = new CollectionConfiguration(brokerPool);
    }

    @Override
    public void startSystem(DBBroker systemBroker) throws BrokerPoolServiceException {
        try {
            this.checkCreateCollection(systemBroker, CONFIG_COLLECTION_URI);
            this.checkCreateCollection(systemBroker, ROOT_COLLECTION_CONFIG_URI);
            this.loadAllConfigurations(systemBroker);
            this.defaultConfig.setIndexConfiguration(systemBroker.getIndexConfiguration());
        }
        catch (EXistException | CollectionConfigurationException | PermissionDeniedException | LockException e) {
            throw new BrokerPoolServiceException(e);
        }
    }

    public void addConfiguration(Txn txn, DBBroker broker, Collection collection, String config) throws CollectionConfigurationException {
        try {
            XmldbURI path = CONFIG_COLLECTION_URI.append(collection.getURI());
            Collection confCol = broker.getOrCreateCollection(txn, path);
            if (confCol == null) {
                throw new CollectionConfigurationException("Failed to create config collection: " + path);
            }
            XmldbURI configurationDocumentName = null;
            CollectionConfiguration conf = this.getConfiguration(broker, collection);
            if (conf != null && (configurationDocumentName = conf.getDocName()) != null) {
                LOG.warn("Replacing current configuration file '" + configurationDocumentName + "'");
            }
            if (configurationDocumentName == null) {
                configurationDocumentName = CollectionConfiguration.DEFAULT_COLLECTION_CONFIG_FILE_URI;
            }
            broker.saveCollection(txn, confCol);
            IndexInfo info = confCol.validateXMLResource(txn, broker, configurationDocumentName, config);
            confCol.store(txn, broker, info, config);
        }
        catch (CollectionConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CollectionConfigurationException("Failed to store collection configuration: " + e.getMessage(), e);
        }
    }

    public void testConfiguration(DBBroker broker, String config) throws CollectionConfigurationException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(new StringReader(config));
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter();
            reader.setContentHandler(adapter);
            reader.parse(src);
            org.exist.dom.memtree.DocumentImpl doc = adapter.getDocument();
            CollectionConfiguration conf = new CollectionConfiguration(broker.getBrokerPool());
            conf.read(broker, doc, true, null, null);
        }
        catch (Exception e) {
            throw new CollectionConfigurationException(e);
        }
    }

    public List<Object> getCustomIndexSpecs(final String customIndexId) {
        return this.latch.read(new Callable<List<Object>>(){

            @Override
            public List<Object> call() throws Exception {
                ArrayList<Object> configs = new ArrayList<Object>(10);
                for (CollectionConfiguration config : CollectionConfigurationManager.this.configurations.values()) {
                    Object customConfig;
                    IndexSpec spec = config.getIndexConfiguration();
                    if (spec == null || (customConfig = spec.getCustomIndexSpec(customIndexId)) == null) continue;
                    configs.add(customConfig);
                }
                return configs;
            }
        });
    }

    protected CollectionConfiguration getConfiguration(DBBroker broker, Collection collection) throws CollectionConfigurationException {
        final CollectionURI path = new CollectionURI(COLLECTION_CONFIG_PATH);
        path.append(collection.getURI().getRawCollectionPath());
        return this.latch.read(new Callable<CollectionConfiguration>(){

            @Override
            public CollectionConfiguration call() throws Exception {
                CollectionConfiguration conf = null;
                while (!path.equals(COLLECTION_CONFIG_PATH)) {
                    conf = (CollectionConfiguration)CollectionConfigurationManager.this.configurations.get(path);
                    if (conf != null) {
                        return conf;
                    }
                    path.removeLastSegment();
                }
                return CollectionConfigurationManager.this.defaultConfig;
            }
        });
    }

    protected void loadAllConfigurations(DBBroker broker) throws CollectionConfigurationException, PermissionDeniedException, LockException {
        Collection root = broker.getCollection(CONFIG_COLLECTION_URI);
        this.loadAllConfigurations(broker, root);
    }

    protected void loadAllConfigurations(DBBroker broker, Collection configCollection) throws CollectionConfigurationException, PermissionDeniedException, LockException {
        if (configCollection == null) {
            return;
        }
        this.loadConfiguration(broker, configCollection);
        XmldbURI path = configCollection.getURI();
        Iterator<XmldbURI> i = configCollection.collectionIterator(broker);
        while (i.hasNext()) {
            XmldbURI childName = i.next();
            Collection child = broker.getCollection(path.appendInternal(childName));
            if (child == null) {
                LOG.error("Collection is registered but could not be loaded: " + childName);
            }
            this.loadAllConfigurations(broker, child);
        }
    }

    protected void loadConfiguration(DBBroker broker, final Collection configCollection) throws CollectionConfigurationException, PermissionDeniedException, LockException {
        if (configCollection != null && configCollection.getDocumentCount(broker) > 0) {
            Iterator<DocumentImpl> i = configCollection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl confDoc = i.next();
                if (!confDoc.getFileURI().endsWith(CollectionConfiguration.COLLECTION_CONFIG_SUFFIX_URI)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Reading collection configuration from '" + confDoc.getURI() + "'");
                }
                final CollectionConfiguration conf = new CollectionConfiguration(broker.getBrokerPool());
                try {
                    conf.read(broker, confDoc, false, configCollection.getURI(), confDoc.getFileURI());
                }
                catch (CollectionConfigurationException e) {
                    String message = "Failed to read configuration document " + confDoc.getFileURI() + " in " + configCollection.getURI() + ". " + e.getMessage();
                    LOG.error(message);
                }
                this.latch.write(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        CollectionConfigurationManager.this.configurations.put(new CollectionURI(configCollection.getURI().getRawCollectionPath()), conf);
                        return null;
                    }
                });
                break;
            }
        }
    }

    public CollectionConfiguration getOrCreateCollectionConfiguration(final DBBroker broker, Collection collection) {
        final CollectionURI path = new CollectionURI(COLLECTION_CONFIG_PATH);
        path.append(collection.getURI().getRawCollectionPath());
        CollectionConfiguration conf = this.latch.read(new Callable<CollectionConfiguration>(){

            @Override
            public CollectionConfiguration call() {
                return (CollectionConfiguration)CollectionConfigurationManager.this.configurations.get(path);
            }
        });
        if (conf != null) {
            return conf;
        }
        return this.latch.write(new Callable<CollectionConfiguration>(){

            @Override
            public CollectionConfiguration call() {
                CollectionConfiguration conf = (CollectionConfiguration)CollectionConfigurationManager.this.configurations.get(path);
                if (conf != null) {
                    return conf;
                }
                conf = new CollectionConfiguration(broker.getBrokerPool());
                CollectionConfigurationManager.this.configurations.put(path, conf);
                return conf;
            }
        });
    }

    public void invalidateAll(final XmldbURI collectionPath) {
        if (!collectionPath.startsWith(CONFIG_COLLECTION_URI)) {
            return;
        }
        this.latch.write(new Callable<Void>(){

            @Override
            public Void call() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalidating collection " + collectionPath + " and subcollections");
                }
                CollectionURI uri = new CollectionURI(collectionPath.getRawCollectionPath());
                CollectionConfigurationManager.this.configurations.remove(uri);
                String str = uri.toString();
                Iterator it = CollectionConfigurationManager.this.configurations.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (!((CollectionURI)entry.getKey()).toString().startsWith(str)) continue;
                    it.remove();
                }
                return null;
            }
        });
    }

    public void invalidate(final XmldbURI collectionPath, BrokerPool pool) {
        if (!collectionPath.startsWith(CONFIG_COLLECTION_URI)) {
            return;
        }
        this.latch.write(new Callable<Void>(){

            @Override
            public Void call() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalidating collection " + collectionPath);
                }
                CollectionConfigurationManager.this.configurations.remove(new CollectionURI(collectionPath.getRawCollectionPath()));
                return null;
            }
        });
    }

    private void checkCreateCollection(DBBroker broker, XmldbURI uri) throws EXistException {
        TransactionManager transact = broker.getDatabase().getTransactionManager();
        try (Txn txn = transact.beginTransaction();){
            Collection collection = broker.getCollection(uri);
            if (collection == null) {
                collection = broker.getOrCreateCollection(txn, uri);
                SanityCheck.THROW_ASSERT(collection != null);
                broker.saveCollection(txn, collection);
            }
            transact.commit(txn);
        }
        catch (Exception e) {
            throw new EXistException("Failed to initialize '" + uri + "' : " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRootCollectionConfig(DBBroker broker) throws EXistException, PermissionDeniedException {
        String configuration = "<collection xmlns=\"http://exist-db.org/collection-config/1.0\">    <index>    </index></collection>";
        TransactionManager transact = broker.getDatabase().getTransactionManager();
        try (Txn txn = transact.beginTransaction();){
            Collection collection = null;
            try {
                collection = broker.openCollection(XmldbURI.ROOT_COLLECTION_URI, Lock.LockMode.READ_LOCK);
                if (collection == null) {
                    transact.abort(txn);
                    throw new EXistException("collection " + XmldbURI.ROOT_COLLECTION_URI + " not found!");
                }
                CollectionConfiguration conf = this.getConfiguration(broker, collection);
                if (conf != null && conf.getDocName() != null) {
                    transact.abort(txn);
                    return;
                }
            }
            finally {
                if (collection != null) {
                    collection.release(Lock.LockMode.READ_LOCK);
                }
            }
            this.addConfiguration(txn, broker, collection, "<collection xmlns=\"http://exist-db.org/collection-config/1.0\">    <index>    </index></collection>");
            transact.commit(txn);
            LOG.info("Configured '" + collection.getURI() + "'");
        }
        catch (CollectionConfigurationException e) {
            throw new EXistException(e.getMessage());
        }
    }
}

