/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections;

import org.exist.Indexer;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.triggers.DocumentTriggers;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Permission;
import org.exist.util.serializer.DOMStreamer;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class IndexInfo {
    private Indexer indexer;
    private DOMStreamer streamer;
    private DocumentTriggers docTriggers;
    private boolean creating = false;
    private Permission oldDocPermissions = null;
    private CollectionConfiguration collectionConfig;

    IndexInfo(Indexer indexer, CollectionConfiguration collectionConfig) {
        this.indexer = indexer;
        this.collectionConfig = collectionConfig;
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public void setTriggers(DocumentTriggers triggersVisitor) {
        this.docTriggers = triggersVisitor;
    }

    public DocumentTriggers getTriggers() {
        return this.docTriggers;
    }

    public void setCreating(boolean creating) {
        this.creating = creating;
    }

    public boolean isCreating() {
        return this.creating;
    }

    public void setOldDocPermissions(Permission oldDocPermissions) {
        this.oldDocPermissions = oldDocPermissions;
    }

    public Permission getOldDocPermissions() {
        return this.oldDocPermissions;
    }

    void setReader(XMLReader reader, EntityResolver entityResolver) throws SAXException {
        if (entityResolver != null) {
            reader.setEntityResolver(entityResolver);
        }
        ContentHandler lexicalHandler = this.docTriggers == null ? this.indexer : this.docTriggers;
        ContentHandler contentHandler = this.docTriggers == null ? this.indexer : this.docTriggers;
        reader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        reader.setContentHandler(contentHandler);
        reader.setErrorHandler(this.indexer);
    }

    void setDOMStreamer(DOMStreamer streamer) {
        this.streamer = streamer;
        if (this.docTriggers == null) {
            streamer.setContentHandler(this.indexer);
            streamer.setLexicalHandler(this.indexer);
        } else {
            streamer.setContentHandler(this.docTriggers);
            streamer.setLexicalHandler(this.docTriggers);
        }
    }

    public DOMStreamer getDOMStreamer() {
        return this.streamer;
    }

    public DocumentImpl getDocument() {
        return this.indexer.getDocument();
    }

    public CollectionConfiguration getCollectionConfig() {
        return this.collectionConfig;
    }
}

