/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.List;
import java.util.Map;
import org.exist.collections.Collection;
import org.exist.collections.triggers.Trigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.collections.triggers.TriggerProxy;
import org.exist.storage.DBBroker;

public abstract class AbstractTriggerProxy<T extends Trigger>
implements TriggerProxy<T> {
    private final Class<? extends T> clazz;
    private Map<String, List<? extends Object>> parameters;

    public AbstractTriggerProxy(Class<? extends T> clazz) {
        this.clazz = clazz;
    }

    public AbstractTriggerProxy(Class<? extends T> clazz, Map<String, List<? extends Object>> parameters) {
        this.clazz = clazz;
        this.parameters = parameters;
    }

    @Override
    public Class<? extends T> getClazz() {
        return this.clazz;
    }

    @Override
    public void setParameters(Map<String, List<? extends Object>> parameters) {
        this.parameters = parameters;
    }

    protected Map<String, List<? extends Object>> getParameters() {
        return this.parameters;
    }

    @Override
    public T newInstance(DBBroker broker, Collection collection) throws TriggerException {
        try {
            Trigger trigger = (Trigger)this.getClazz().newInstance();
            trigger.configure(broker, collection, this.getParameters());
            return (T)trigger;
        }
        catch (IllegalAccessException | InstantiationException ie) {
            throw new TriggerException("Unable to instantiate Trigger '" + this.getClazz().getName() + "': " + ie.getMessage(), ie);
        }
    }
}

