/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.exist.collections.Collection;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CSVExtractingTrigger
extends FilteringTrigger {
    private String separator;
    private Map<String, Extraction> extractions = new HashMap<String, Extraction>();
    private NodePath currentNodePath = new NodePath();
    private boolean capture = false;
    private StringBuilder charactersBuf = new StringBuilder();

    @Override
    public void configure(DBBroker broker, Collection parent, Map<String, List<?>> parameters) throws TriggerException {
        super.configure(broker, parent, parameters);
        List<?> separators = parameters.get("separator");
        if (separators == null || separators.size() != 1) {
            throw new TriggerException("A separator parameter must be provided to the CSVExtractingTrigger configuration");
        }
        this.separator = (String)separators.get(0);
        List<?> paths = parameters.get("path");
        for (Map path : paths) {
            List extracts;
            Extraction extraction;
            String pathExpr;
            List xpaths = (List)path.get("xpath");
            if (xpaths == null || xpaths.size() != 1) continue;
            String xpath = (String)xpaths.get(0);
            String attrPredicate = null;
            if (xpath.indexOf("[") > -1) {
                pathExpr = xpath.substring(0, xpath.indexOf("["));
                if (xpath.indexOf("[@") > -1) {
                    attrPredicate = xpath.substring(xpath.indexOf("[@") + 2, xpath.indexOf("]"));
                }
            } else {
                pathExpr = xpath;
            }
            if ((extraction = this.extractions.get(pathExpr)) == null) {
                extraction = new Extraction();
                if (attrPredicate != null) {
                    String[] attrNameValueMatch = attrPredicate.split(" eq ");
                    extraction.setMatchAttribute(attrNameValueMatch[0], attrNameValueMatch[1]);
                }
            }
            if ((extracts = (List)path.get("extract")) != null) {
                for (Properties extract : extracts) {
                    ExtractEntry extractEntry = new ExtractEntry(Integer.parseInt(extract.getProperty("index")), extract.getProperty("element-name"));
                    extraction.getExtractEntries().add(extractEntry);
                }
            }
            Collections.sort(extraction.getExtractEntries());
            this.extractions.put(pathExpr, extraction);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname, Attributes attributes) throws SAXException {
        if (this.capture) {
            this.capture = false;
            this.charactersBuf.delete(0, this.charactersBuf.length());
        }
        super.startElement(namespaceURI, localName, qname, attributes);
        this.currentNodePath.add(namespaceURI, localName);
        Extraction extraction = this.extractions.get(this.currentNodePath.toLocalPath());
        if (extraction != null) {
            if (extraction.mustMatchAttribute()) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!extraction.matchesAttribute(attributes.getLocalName(i), attributes.getValue(i))) continue;
                    this.capture = true;
                    break;
                }
            } else {
                this.capture = true;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.capture) {
            this.charactersBuf.append(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws SAXException {
        if (this.capture) {
            this.extractCSVValuesToElements();
            this.capture = false;
            this.charactersBuf.delete(0, this.charactersBuf.length());
        }
        super.endElement(namespaceURI, localName, qname);
        this.currentNodePath.removeLast();
    }

    private void extractCSVValuesToElements() throws SAXException {
        String[] seperatedValues = this.charactersBuf.toString().split(this.getEscapedSeparatorForRegExp());
        Extraction extraction = this.extractions.get(this.currentNodePath.toLocalPath());
        for (ExtractEntry extractEntry : extraction.getExtractEntries()) {
            int index = extractEntry.getIndex();
            if (index >= seperatedValues.length) continue;
            char[] seperatedValue = seperatedValues[index].toCharArray();
            String localName = extractEntry.getElementName();
            super.startElement("", localName, localName, new EmptyAttributes());
            super.characters(seperatedValue, 0, seperatedValue.length);
            super.endElement("", localName, localName);
        }
    }

    private String getEscapedSeparatorForRegExp() {
        if (this.separator.length() == 1 && ("|".equals(this.separator) || ",".equals(this.separator) || "$".equals(this.separator) || "^".equals(this.separator))) {
            return "\\" + this.separator;
        }
        return this.separator;
    }

    @Override
    public void beforeCreateDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
    }

    @Override
    public void afterCreateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void afterCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void afterMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeDeleteDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterDeleteDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    private static class EmptyAttributes
    implements Attributes {
        private EmptyAttributes() {
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public String getURI(int index) {
            return null;
        }

        @Override
        public String getLocalName(int index) {
            return null;
        }

        @Override
        public String getQName(int index) {
            return null;
        }

        @Override
        public String getType(int index) {
            return null;
        }

        @Override
        public String getValue(int index) {
            return null;
        }

        @Override
        public int getIndex(String uri, String localName) {
            return -1;
        }

        @Override
        public int getIndex(String qName) {
            return -1;
        }

        @Override
        public String getType(String uri, String localName) {
            return null;
        }

        @Override
        public String getType(String qName) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            return null;
        }

        @Override
        public String getValue(String qName) {
            return null;
        }
    }

    private static class ExtractEntry
    implements Comparable<ExtractEntry> {
        private final int index;
        private final String elementName;

        public ExtractEntry(int index, String elementName) {
            this.index = index;
            this.elementName = elementName;
        }

        public int getIndex() {
            return this.index;
        }

        public String getElementName() {
            return this.elementName;
        }

        @Override
        public int compareTo(ExtractEntry other) {
            if (other == null) {
                return -1;
            }
            return other.getIndex() - this.getIndex();
        }
    }

    private static class Extraction {
        private List<ExtractEntry> extractEntries = new ArrayList<ExtractEntry>();
        private String matchAttrName;
        private String matchAttrValue;

        private Extraction() {
        }

        public List<ExtractEntry> getExtractEntries() {
            return this.extractEntries;
        }

        public void setMatchAttribute(String attrName, String attrValue) {
            this.matchAttrName = attrName.trim();
            this.matchAttrValue = attrValue.replaceAll("\"", "").trim();
        }

        public boolean mustMatchAttribute() {
            return this.matchAttrName != null && this.matchAttrValue != null;
        }

        public boolean matchesAttribute(String attrName, String attrValue) {
            if (!this.mustMatchAttribute()) {
                return true;
            }
            return this.matchAttrName.equals(attrName) && this.matchAttrValue.equals(attrValue);
        }
    }

    private static class NodePath {
        private Stack<QName> pathSegments = new Stack();

        private NodePath() {
        }

        public void add(String namespaceUri, String localName) {
            this.pathSegments.push(new QName(namespaceUri, localName));
        }

        public void removeLast() {
            this.pathSegments.pop();
        }

        public int length() {
            return this.pathSegments.size();
        }

        public String toLocalPath() {
            StringBuilder localPath = new StringBuilder();
            localPath.append("/");
            for (int i = 0; i < this.pathSegments.size(); ++i) {
                localPath.append(((QName)this.pathSegments.get(i)).getLocalPart());
                if (i + 1 >= this.pathSegments.size()) continue;
                localPath.append("/");
            }
            return localPath.toString();
        }
    }
}

