/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.List;
import java.util.Map;
import org.exist.Indexer;
import org.exist.collections.Collection;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.storage.DBBroker;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public abstract class SAXTrigger
implements DocumentTrigger,
ContentHandler,
LexicalHandler,
ErrorHandler {
    private ContentHandler nextContentHandler = null;
    private LexicalHandler nextLexicalHandler = null;
    private ErrorHandler nextErrorHandler = null;
    private Collection collection = null;
    private boolean validating = true;

    protected Collection getCollection() {
        return this.collection;
    }

    public void configure(DBBroker broker, Collection collection, Map<String, List<?>> parameters) throws TriggerException {
        this.collection = collection;
    }

    @Override
    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    @Override
    public boolean isValidating() {
        return this.validating;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.endDocument();
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.startPrefixMapping(prefix, namespaceURI);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname, Attributes attributes) throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.startElement(namespaceURI, localName, qname, attributes);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.endElement(namespaceURI, localName, qname);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        if (this.nextContentHandler != null) {
            this.nextContentHandler.skippedEntity(arg0);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.nextLexicalHandler != null) {
            this.nextLexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.nextLexicalHandler != null) {
            this.nextLexicalHandler.endDTD();
        }
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
        if (this.nextLexicalHandler != null) {
            this.nextLexicalHandler.startEntity(arg0);
        }
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
        if (this.nextLexicalHandler != null) {
            this.nextLexicalHandler.endEntity(arg0);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.nextLexicalHandler != null) {
            this.nextLexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.nextLexicalHandler != null) {
            this.nextLexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.nextLexicalHandler != null) {
            this.nextLexicalHandler.comment(ch, start, length);
        }
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this.nextErrorHandler != null) {
            this.nextErrorHandler.warning(exception);
        }
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this.nextErrorHandler != null) {
            this.nextErrorHandler.error(exception);
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.nextErrorHandler != null) {
            this.nextErrorHandler.fatalError(exception);
        }
    }

    protected void next(SAXTrigger nextTrigger) {
        this.nextContentHandler = nextTrigger;
        this.nextLexicalHandler = nextTrigger;
        this.nextErrorHandler = nextTrigger;
    }

    protected void next(Indexer indexer) {
        this.nextContentHandler = indexer;
        this.nextLexicalHandler = indexer;
        this.nextErrorHandler = indexer;
    }
}

