/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;

@ThreadSafe
public class STXTemplatesCache {
    private static final Logger LOG = LogManager.getLogger(STXTemplatesCache.class);
    private static final STXTemplatesCache INSTANCE = new STXTemplatesCache();
    private final SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance("net.sf.joost.trax.TransformerFactoryImpl", this.getClass().getClassLoader());
    private final Cache<XmldbURI, CachedTemplate> cache = Caffeine.newBuilder().maximumSize(250L).build();

    private STXTemplatesCache() {
    }

    public static STXTemplatesCache getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Templates getOrUpdateTemplate(DBBroker broker, DocumentImpl stylesheet) throws TransformerConfigurationException, SAXException, LockException {
        try {
            stylesheet.getUpdateLock().acquire(Lock.LockMode.READ_LOCK);
            XmldbURI stylesheetUri = stylesheet.getURI();
            long lastModified = stylesheet.getMetadata().getLastModified();
            CachedTemplate cachedTemplate = (CachedTemplate)this.cache.getIfPresent((Object)stylesheetUri);
            if (cachedTemplate != null && lastModified > cachedTemplate.getLastUpdated()) {
                cachedTemplate = null;
                LOG.trace("Invalidating cached STX Template '" + stylesheetUri.toString() + "' as it is outdated.");
            } else {
                LOG.trace("Retrieved STX Template '" + stylesheetUri.toString() + "' from cache.");
            }
            if (cachedTemplate == null) {
                Templates compiled = this.compileTemplate(broker, stylesheet);
                cachedTemplate = new CachedTemplate(compiled, lastModified);
                this.cache.put((Object)stylesheetUri, (Object)cachedTemplate);
                LOG.trace("Compiled and cached STX Template '" + stylesheetUri.toString() + "'.");
            }
            Templates templates = cachedTemplate.templates;
            return templates;
        }
        finally {
            stylesheet.getUpdateLock().release(Lock.LockMode.READ_LOCK);
        }
    }

    private Templates compileTemplate(DBBroker broker, DocumentImpl stylesheet) throws TransformerConfigurationException, SAXException {
        Serializer serializer = broker.getSerializer();
        TemplatesHandler thandler = this.factory.newTemplatesHandler();
        serializer.setSAXHandlers(thandler, null);
        serializer.toSAX(stylesheet);
        return thandler.getTemplates();
    }

    private static class CachedTemplate {
        private final Templates templates;
        private final long lastUpdated;

        public CachedTemplate(Templates templates, long lastUpdated) {
            this.templates = templates;
            this.lastUpdated = lastUpdated;
        }

        private long getLastUpdated() {
            return this.lastUpdated;
        }

        private Templates getTemplate() {
            return this.templates;
        }
    }
}

