/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.SAXTrigger;
import org.exist.collections.triggers.STXTemplatesCache;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;

public class STXTransformerTrigger
extends SAXTrigger
implements DocumentTrigger {
    protected Logger LOG = LogManager.getLogger(this.getClass());
    private final SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance("net.sf.joost.trax.TransformerFactoryImpl", this.getClass().getClassLoader());
    private TransformerHandler handler = null;

    @Override
    public void configure(DBBroker broker, Collection parent, Map<String, List<?>> parameters) throws TriggerException {
        super.configure(broker, parent, parameters);
        String stylesheet = (String)parameters.get("src").get(0);
        if (stylesheet == null) {
            throw new TriggerException("STXTransformerTrigger requires an attribute 'src'");
        }
        XmldbURI stylesheetUri = null;
        try {
            stylesheetUri = XmldbURI.xmldbUriFor(stylesheet);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (stylesheetUri == null || stylesheet.indexOf(58) == -1) {
            stylesheetUri = parent.getURI().resolveCollectionPath(stylesheetUri);
            try {
                DocumentImpl doc = (DocumentImpl)broker.getXMLResource(stylesheetUri);
                if (doc == null) {
                    throw new TriggerException("stylesheet " + stylesheetUri + " not found in database");
                }
                if (doc instanceof BinaryDocument) {
                    throw new TriggerException("stylesheet " + stylesheetUri + " must be stored as an xml document and not a binary document!");
                }
                this.handler = this.factory.newTransformerHandler(STXTemplatesCache.getInstance().getOrUpdateTemplate(broker, doc));
            }
            catch (TransformerConfigurationException | PermissionDeniedException | LockException | SAXException e) {
                throw new TriggerException(e.getMessage(), e);
            }
        }
        try {
            this.LOG.debug("compiling stylesheet " + stylesheet);
            Templates template = this.factory.newTemplates(new StreamSource(stylesheet));
            this.handler = this.factory.newTransformerHandler(template);
        }
        catch (TransformerConfigurationException e) {
            throw new TriggerException(e.getMessage(), e);
        }
    }

    private void prepare() {
    }

    @Override
    public void beforeCreateDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
        this.prepare();
    }

    @Override
    public void afterCreateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
        this.prepare();
    }

    @Override
    public void afterUpdateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void beforeCopyDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        this.prepare();
    }

    @Override
    public void afterCopyDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeMoveDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        this.prepare();
    }

    @Override
    public void afterMoveDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void beforeDeleteDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
        this.prepare();
    }

    @Override
    public void afterDeleteDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    @Override
    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }
}

