/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.source.Source;
import org.exist.source.SourceFactory;
import org.exist.storage.DBBroker;
import org.exist.storage.StartupTrigger;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.Sequence;

public class XQueryStartupTrigger
implements StartupTrigger {
    protected static final Logger LOG = LogManager.getLogger(XQueryStartupTrigger.class);
    private static final String XQUERY = "xquery";
    private static final String AUTOSTART_COLLECTION = "/db/system/autostart";
    private static final String[] XQUERY_EXTENSIONS = new String[]{".xq", ".xquery", ".xqy"};
    private static final String REQUIRED_MIMETYPE = "application/xquery";

    @Override
    public void execute(DBBroker broker, Map<String, List<? extends Object>> params) {
        LOG.info("Starting Startup Trigger for stored XQueries");
        for (String path : this.getScriptsInStartupCollection(broker)) {
            this.executeQuery(broker, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getScriptsInStartupCollection(DBBroker broker) {
        ArrayList<String> paths = new ArrayList<String>();
        XmldbURI uri = XmldbURI.create(AUTOSTART_COLLECTION);
        Collection collection = null;
        try {
            collection = broker.openCollection(uri, Lock.LockMode.READ_LOCK);
            if (collection == null) {
                LOG.debug(String.format("Collection '%s' not found.", AUTOSTART_COLLECTION));
                this.createAutostartCollection(broker);
            } else {
                LOG.debug(String.format("Scanning collection '%s'.", AUTOSTART_COLLECTION));
                if (this.isPermissionsOK(collection)) {
                    Iterator<DocumentImpl> documents = collection.iteratorNoLock(broker);
                    while (documents.hasNext()) {
                        DocumentImpl document = documents.next();
                        String docPath = document.getURI().toString();
                        if (this.isPermissionsOK(document)) {
                            if (StringUtils.endsWithAny((CharSequence)docPath, (CharSequence[])XQUERY_EXTENSIONS)) {
                                paths.add("xmldb:exist://" + docPath);
                                continue;
                            }
                            LOG.error(String.format("Skipped document '%s', not an xquery script.", docPath));
                            continue;
                        }
                        LOG.error(String.format("Document %s should be owned by DBA, mode %s, mimetype %s", docPath, 504, REQUIRED_MIMETYPE));
                    }
                } else {
                    LOG.error(String.format("Collection %s should be owned by SYSTEM/DBA, mode %s.", AUTOSTART_COLLECTION, 504));
                }
            }
            LOG.debug(String.format("Found %s xquery scripts in '%s'.", paths.size(), AUTOSTART_COLLECTION));
        }
        catch (PermissionDeniedException ex) {
            LOG.error(ex.getMessage());
        }
        finally {
            if (collection != null) {
                collection.release(Lock.LockMode.READ_LOCK);
            }
        }
        return paths;
    }

    private boolean isPermissionsOK(Collection collection) {
        Permission perms = collection.getPermissions();
        return perms.getOwner().getName().equals("SYSTEM") && perms.getGroup().getName().equals("dba") && perms.getMode() == 504;
    }

    private boolean isPermissionsOK(DocumentImpl document) {
        Permission perms = document.getPermissions();
        return perms.getOwner().hasDbaRole() && perms.getGroup().getName().equals("dba") && perms.getMode() == 504 && document.getMetadata().getMimeType().equals(REQUIRED_MIMETYPE);
    }

    private List<String> getParameters(Map<String, List<? extends Object>> params) {
        ArrayList<String> paths = new ArrayList<String>();
        Set<Map.Entry<String, List<? extends Object>>> data = params.entrySet();
        for (Map.Entry<String, List<? extends Object>> entry : data) {
            if (!XQUERY.equals(entry.getKey())) continue;
            List<? extends Object> list = entry.getValue();
            for (Object object : list) {
                if (!(object instanceof String)) continue;
                String value = (String)object;
                if (value.startsWith("/")) {
                    value = "xmldb:exist://" + value;
                    if (paths.contains(value)) continue;
                    paths.add(value);
                    continue;
                }
                LOG.error(String.format("Path '%s' should start with a '/'", value));
            }
        }
        LOG.debug(String.format("Found %s 'xquery' entries.", paths.size()));
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery(DBBroker broker, String path) {
        BinaryValueManager context = null;
        try {
            Source source = SourceFactory.getSource(broker, null, path, false);
            if (source == null) {
                LOG.info(String.format("No Xquery found at '%s'", path));
            } else {
                XQuery service = broker.getBrokerPool().getXQueryService();
                context = new XQueryContext(broker.getBrokerPool());
                String moduleLoadPath = StringUtils.substringBeforeLast((String)path, (String)"/");
                ((XQueryContext)context).setModuleLoadPath(moduleLoadPath);
                CompiledXQuery compiledQuery = service.compile(broker, (XQueryContext)context, source);
                LOG.info(String.format("Starting Xquery at '%s'", path));
                ((XQueryContext)context).prepareForExecution();
                Sequence result = service.execute(broker, compiledQuery, null);
                LOG.info(String.format("Result xquery: '%s'", result.getStringValue()));
            }
        }
        catch (Throwable t) {
            LOG.error(String.format("An error occured during preparation/execution of the xquery script %s: %s", path, t.getMessage()), t);
        }
        finally {
            if (context != null) {
                context.runCleanupTasks();
            }
        }
    }

    private void createAutostartCollection(DBBroker broker) {
        LOG.info(String.format("Creating %s", AUTOSTART_COLLECTION));
        TransactionManager txnManager = broker.getBrokerPool().getTransactionManager();
        try (Txn txn = txnManager.beginTransaction();){
            XmldbURI newCollection = XmldbURI.create(AUTOSTART_COLLECTION, true);
            Collection created = broker.getOrCreateCollection(txn, newCollection);
            Permission perms = created.getPermissions();
            perms.setOwner(broker.getBrokerPool().getSecurityManager().getSystemSubject());
            perms.setGroup(broker.getBrokerPool().getSecurityManager().getDBAGroup());
            perms.setMode(504);
            broker.saveCollection(txn, created);
            broker.flush();
            txnManager.commit(txn);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished creation of collection");
            }
        }
        catch (Throwable ex) {
            LOG.error((Object)ex);
        }
    }
}

