/*
 * Decompiled with CFR 0.152.
 */
package org.exist.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.DeferrableFilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.ACLPermission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.PermissionFactory;
import org.exist.security.Principal;
import org.exist.security.SecurityManager;
import org.exist.security.utils.ConverterFrom1_0;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.sax.event.SAXEvent;
import org.exist.util.sax.event.contenthandler.Characters;
import org.exist.util.sax.event.contenthandler.Element;
import org.exist.util.sax.event.contenthandler.StartElement;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ConfigurationDocumentTrigger
extends DeferrableFilteringTrigger {
    private static final String ID_ATTR = "id";
    protected Logger LOG = LogManager.getLogger(this.getClass());
    private DBBroker broker = null;
    private final PreAllocatedIdReceiver preAllocatedId = new PreAllocatedIdReceiver();
    private boolean createOrUpdate = false;
    private boolean processingAccount = false;

    @Deprecated
    public void finish(int event, DBBroker broker, Txn txn, XmldbURI documentPath, DocumentImpl document) {
        switch (event) {
            case 8: {
                Configuration conf = Configurator.getConfigurtion(broker.getBrokerPool(), documentPath);
                if (conf == null) break;
                Configurator.unregister(conf);
                break;
            }
            default: {
                Configuration conf = Configurator.getConfigurtion(broker.getBrokerPool(), documentPath);
                if (conf != null) {
                    conf.checkForUpdates(document.getDocumentElement());
                }
                if (!documentPath.toString().equals("/db/system/users.xml")) break;
                try {
                    SecurityManager sm = broker.getBrokerPool().getSecurityManager();
                    ConverterFrom1_0.convert(broker, sm, document);
                    break;
                }
                catch (EXistException | PermissionDeniedException e) {
                    this.LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void checkForUpdates(DBBroker broker, XmldbURI uri, DocumentImpl document) {
        Configuration conf = Configurator.getConfigurtion(broker.getBrokerPool(), uri);
        if (conf != null) {
            conf.checkForUpdates(document.getDocumentElement());
        }
        if (uri.toString().equals("/db/system/users.xml")) {
            try {
                SecurityManager sm = broker.getBrokerPool().getSecurityManager();
                ConverterFrom1_0.convert(broker, sm, document);
            }
            catch (EXistException | PermissionDeniedException e) {
                this.LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void beforeCreateDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
        this.createOrUpdate = true;
        this.broker = broker;
    }

    @Override
    public void afterCreateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        if (Configurator.saving.contains(Configurator.getFullURI(broker.getBrokerPool(), document.getURI()))) {
            return;
        }
        this.checkForUpdates(broker, document.getURI(), document);
        XmldbURI uri = document.getCollection().getURI();
        if (uri.startsWith(SecurityManager.SECURITY_COLLECTION_URI)) {
            try {
                broker.getBrokerPool().getSecurityManager().processPramatter(broker, document);
            }
            catch (ConfigurationException e) {
                this.LOG.error("Configuration can't be processed [" + document.getURI() + "]", (Throwable)e);
            }
        }
        this.broker = null;
        this.createOrUpdate = false;
    }

    @Override
    public void beforeUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        this.createOrUpdate = true;
        this.broker = broker;
        if (Configurator.saving.contains(Configurator.getFullURI(broker.getBrokerPool(), document.getURI()))) {
            return;
        }
        XmldbURI uri = document.getCollection().getURI();
        if (uri.startsWith(SecurityManager.SECURITY_COLLECTION_URI)) {
            try {
                broker.getBrokerPool().getSecurityManager().processPramatterBeforeSave(broker, document);
            }
            catch (ConfigurationException e) {
                this.LOG.error("Configuration can't be processed [" + document.getURI() + "]", (Throwable)e);
            }
        }
    }

    @Override
    public void afterUpdateDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        if (Configurator.saving.contains(Configurator.getFullURI(broker.getBrokerPool(), document.getURI()))) {
            return;
        }
        this.checkForUpdates(broker, document.getURI(), document);
        XmldbURI uri = document.getCollection().getURI();
        if (uri.startsWith(SecurityManager.SECURITY_COLLECTION_URI)) {
            try {
                broker.getBrokerPool().getSecurityManager().processPramatter(broker, document);
            }
            catch (ConfigurationException e) {
                this.LOG.error("Configuration can't be processed [" + document.getURI() + "]", (Throwable)e);
            }
        }
        this.broker = null;
        this.createOrUpdate = false;
    }

    @Override
    public void beforeCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void afterCopyDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI oldUri) throws TriggerException {
        this.checkForUpdates(broker, document.getURI(), document);
    }

    @Override
    public void beforeMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI newUri) throws TriggerException {
    }

    @Override
    public void afterMoveDocument(DBBroker broker, Txn txn, DocumentImpl document, XmldbURI oldUri) throws TriggerException {
        this.checkForUpdates(broker, document.getURI(), document);
    }

    @Override
    public void beforeDeleteDocument(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
        Configuration conf = Configurator.getConfigurtion(broker.getBrokerPool(), document.getURI());
        if (conf != null) {
            Configurator.unregister(conf);
        }
    }

    @Override
    public void afterDeleteDocument(DBBroker broker, Txn txn, XmldbURI uri) throws TriggerException {
    }

    @Override
    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) {
    }

    @Override
    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) {
    }

    @Override
    public void configure(DBBroker broker, Collection parent, Map<String, List<?>> parameters) throws TriggerException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qname, Attributes attributes) throws SAXException {
        if (this.createOrUpdate && namespaceURI != null && namespaceURI.equals("http://exist-db.org/Configuration") && (localName.equals(PrincipalType.ACCOUNT.getElementName()) && attributes.getValue(ID_ATTR) != null || localName.equals(PrincipalType.GROUP.getElementName()) && !this.processingAccount)) {
            this.processingAccount = localName.equals(PrincipalType.ACCOUNT.getElementName());
            this.defer(true);
        }
        super.startElement(namespaceURI, localName, qname, attributes);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qname) throws SAXException {
        super.endElement(namespaceURI, localName, qname);
        if (this.createOrUpdate && namespaceURI != null && namespaceURI.equals("http://exist-db.org/Configuration") && (localName.equals(PrincipalType.ACCOUNT.getElementName()) || localName.equals(PrincipalType.GROUP.getElementName()) && !this.processingAccount)) {
            if (this.processingAccount) {
                this.processPrincipal(PrincipalType.fromElementName(localName));
            }
            this.defer(false);
            if (localName.equals(PrincipalType.ACCOUNT.getElementName())) {
                this.processingAccount = false;
            }
        }
    }

    private void processPrincipal(PrincipalType principalType) throws SAXException {
        int newId;
        SAXEvent firstEvent = (SAXEvent)this.deferred.peek();
        if (!(firstEvent instanceof StartElement)) {
            throw new SAXException("Unbalanced SAX Events");
        }
        StartElement start = (StartElement)firstEvent;
        if (start.namespaceURI == null || !start.namespaceURI.equals("http://exist-db.org/Configuration") || !start.localName.equals(principalType.getElementName())) {
            throw new SAXException("First element does not match ending '" + principalType.getElementName() + "' element");
        }
        SecurityManager sm = this.broker.getBrokerPool().getSecurityManager();
        AttributesImpl attrs = new AttributesImpl(this.migrateIdAttribute(sm, start.attributes, principalType));
        String principalName = this.findName();
        boolean principalExists = principalName != null && principalType.hasPrincipal(sm, principalName);
        Principal existingPrincipleByName = null;
        if (principalExists) {
            existingPrincipleByName = principalType.getPrincipal(sm, principalName);
        }
        if (existingPrincipleByName != null) {
            newId = existingPrincipleByName.getId();
        } else {
            Integer id = Integer.valueOf(attrs.getValue(ID_ATTR));
            boolean principalIdExists = principalType.hasPrincipal(sm, id);
            Principal existingPrincipalById = null;
            if (principalIdExists) {
                existingPrincipalById = principalType.getPrincipal(sm, id);
            }
            if (existingPrincipalById != null) {
                if (this.isValidating()) {
                    try {
                        principalType.preAllocateId(sm, this.preAllocatedId);
                    }
                    catch (EXistException | PermissionDeniedException e) {
                        throw new SAXException("Unable to pre-allocate principle id for " + principalType.getElementName() + ": " + principalName, e);
                    }
                }
                newId = this.preAllocatedId.getId();
                if (!this.isValidating()) {
                    this.preAllocatedId.clear();
                }
            } else {
                newId = id;
            }
        }
        attrs.setValue(attrs.getIndex(ID_ATTR), String.valueOf(newId));
        StartElement prevPrincipalStart = (StartElement)this.deferred.poll();
        this.deferred.addFirst(new StartElement(prevPrincipalStart.namespaceURI, prevPrincipalStart.localName, prevPrincipalStart.qname, attrs));
    }

    private Attributes migrateIdAttribute(SecurityManager sm, Attributes attrs, PrincipalType principalType) {
        Attributes newAttrs;
        boolean aclPermissionInUse = PermissionFactory.getDefaultResourcePermission(sm) instanceof ACLPermission;
        String strId = attrs.getValue(ID_ATTR);
        if (aclPermissionInUse && strId != null) {
            Integer id = Integer.parseInt(strId);
            Integer newId = principalType.migrateId(id);
            if (newId != null) {
                newAttrs = new AttributesImpl(attrs);
                ((AttributesImpl)newAttrs).setValue(newAttrs.getIndex(ID_ATTR), newId.toString());
            } else {
                newAttrs = attrs;
            }
        } else {
            newAttrs = attrs;
        }
        return newAttrs;
    }

    private String findName() {
        boolean inName = false;
        StringBuilder name = new StringBuilder();
        for (SAXEvent event : this.deferred) {
            if (event instanceof Element) {
                Element element = (Element)event;
                if (element.namespaceURI != null && element.namespaceURI.equals("http://exist-db.org/Configuration") && element.localName.equals("name")) {
                    boolean bl = inName = !inName;
                }
            }
            if (!inName || !(event instanceof Characters)) continue;
            name.append(((Characters)event).ch);
        }
        if (name.length() > 0) {
            return name.toString().trim();
        }
        return null;
    }

    private static class PreAllocatedIdReceiver
    implements SecurityManager.PrincipalIdReceiver {
        Integer id = null;

        private PreAllocatedIdReceiver() {
        }

        @Override
        public void allocate(int id) {
            this.id = id;
        }

        public int getId() throws IllegalStateException {
            if (this.id == null) {
                throw new IllegalStateException("Id has not been allocated");
            }
            return this.id;
        }

        public void clear() {
            this.id = null;
        }
    }

    private static enum PrincipalType {
        ACCOUNT("account", (Map<Integer, Integer>)new HashMap<Integer, Integer>(){
            {
                this.put(-1, 1048572);
                this.put(0, 1048575);
                this.put(1, 1048574);
                this.put(2, 1048573);
            }
        }),
        GROUP("group", (Map<Integer, Integer>)new HashMap<Integer, Integer>(){
            {
                this.put(-1, 1048573);
                this.put(1, 1048575);
                this.put(2, 1048574);
            }
        });

        private final String elementName;
        private final Map<Integer, Integer> idMigration;

        private PrincipalType(String elementName, Map<Integer, Integer> idMigration) {
            this.elementName = elementName;
            this.idMigration = idMigration;
        }

        public String getElementName() {
            return this.elementName;
        }

        public Integer migrateId(Integer oldId) {
            return this.idMigration.get(oldId);
        }

        public Principal getPrincipal(SecurityManager sm, String name) {
            switch (this) {
                case ACCOUNT: {
                    return sm.getAccount(name);
                }
                case GROUP: {
                    return sm.getGroup(name);
                }
            }
            return null;
        }

        public boolean hasPrincipal(SecurityManager sm, String name) {
            switch (this) {
                case ACCOUNT: {
                    return sm.hasAccount(name);
                }
                case GROUP: {
                    return sm.hasGroup(name);
                }
            }
            return false;
        }

        public Principal getPrincipal(SecurityManager sm, int id) {
            switch (this) {
                case ACCOUNT: {
                    return sm.getAccount(id);
                }
                case GROUP: {
                    return sm.getGroup(id);
                }
            }
            return null;
        }

        public boolean hasPrincipal(SecurityManager sm, int id) {
            switch (this) {
                case ACCOUNT: {
                    return sm.hasUser(id);
                }
                case GROUP: {
                    return sm.hasGroup(id);
                }
            }
            return false;
        }

        public void preAllocateId(SecurityManager sm, PreAllocatedIdReceiver receiver) throws PermissionDeniedException, EXistException {
            switch (this) {
                case ACCOUNT: {
                    sm.preAllocateAccountId(receiver);
                    break;
                }
                case GROUP: {
                    sm.preAllocateGroupId(receiver);
                }
            }
        }

        public static PrincipalType fromElementName(String elementName) {
            for (PrincipalType pt : PrincipalType.values()) {
                if (!pt.getElementName().equals(elementName)) continue;
                return pt;
            }
            throw new NoSuchElementException("No PrincipalType with element name: " + elementName);
        }
    }
}

