/*
 * Decompiled with CFR 0.152.
 */
package org.exist.config;

import com.evolvedbinary.j8fu.function.ConsumerE;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.LifeCycle;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.ConfigurationImpl;
import org.exist.config.Reference;
import org.exist.config.ReferenceImpl;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.config.annotation.ConfigurationFieldClassMask;
import org.exist.config.annotation.ConfigurationFieldSettings;
import org.exist.config.annotation.ConfigurationReferenceBy;
import org.exist.config.annotation.NewClass;
import org.exist.config.mapper.Constructor;
import org.exist.dom.QName;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.security.internal.RealmImpl;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.MimeType;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xmldb.FullXmldbURI;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Configurator {
    public static final Logger LOG = LogManager.getLogger(Configurator.class);
    private static final String EOL = System.getProperty("line.separator", "\n");
    protected static final ConcurrentMap<FullXmldbURI, Configuration> hotConfigs = new ConcurrentHashMap<FullXmldbURI, Configuration>();
    protected static final Set<FullXmldbURI> saving = new ConcurrentSkipListSet<FullXmldbURI>();

    protected static AFields getConfigurationAnnotatedFields(Class<?> clazz) {
        AFields fields = new AFields();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.isAnnotationPresent(ConfigurationFieldAsAttribute.class)) {
                fields.addAttribute(new AField<ConfigurationFieldAsAttribute>(field.getAnnotation(ConfigurationFieldAsAttribute.class), field));
                continue;
            }
            if (!field.isAnnotationPresent(ConfigurationFieldAsElement.class)) continue;
            fields.addElement(new AField<ConfigurationFieldAsElement>(field.getAnnotation(ConfigurationFieldAsElement.class), field));
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.isAnnotationPresent(ConfigurationClass.class)) {
            AFields superFields = Configurator.getConfigurationAnnotatedFields(superClass);
            fields.addAllAttributes(superFields.getAttributes());
            fields.addAllElements(superFields.getElements());
        }
        return fields;
    }

    protected static <T extends Annotation> T getAnnotation(Field field, Class<T> annotation) {
        if (field.isAnnotationPresent(annotation)) {
            return field.getAnnotation(annotation);
        }
        return null;
    }

    public static Method searchForGetMethod(Class<?> clazz, String property) {
        try {
            String methodName = ("get" + property).toLowerCase();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().toLowerCase().equals(methodName)) continue;
                return method;
            }
        }
        catch (NoClassDefFoundError | SecurityException e) {
            LOG.error(e.getMessage(), e);
        }
        return null;
    }

    public static Method searchForSetMethod(Class<?> clazz, Field field) {
        try {
            String methodName = ("set" + field.getName()).toLowerCase();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().toLowerCase().equals(methodName)) continue;
                return method;
            }
        }
        catch (NoClassDefFoundError | SecurityException e) {
            LOG.error(e.getMessage(), e);
        }
        return null;
    }

    public static Method searchForAddMethod(Class<?> clazz, String property) {
        try {
            String methodName = ("add" + property).toLowerCase();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().toLowerCase().equals(methodName) || method.getParameterTypes().length != 1 || !String.class.getName().equals(method.getParameterTypes()[0].getName())) continue;
                return method;
            }
        }
        catch (NoClassDefFoundError | SecurityException e) {
            LOG.error(e.getMessage(), e);
        }
        return null;
    }

    public static Method searchForInsertMethod(Class<?> clazz, String property) {
        try {
            String methodName = ("insert" + property).toLowerCase();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().toLowerCase().equals(methodName) || method.getParameterTypes().length != 2 || !Integer.TYPE.getName().equals(method.getParameterTypes()[0].getName()) || !String.class.getName().equals(method.getParameterTypes()[1].getName())) continue;
                return method;
            }
        }
        catch (NoClassDefFoundError | SecurityException e) {
            LOG.error(e.getMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration configure(Configurable instance, Configuration configuration) {
        Configuration impl;
        if (configuration == null) {
            return null;
        }
        Class<?> clazz = instance.getClass();
        if (!clazz.isAnnotationPresent(ConfigurationClass.class)) {
            LOG.warn("Instance '" + instance + "' is missing annotation '@org.exist.config.annotation.ConfigurationClass'");
            return null;
        }
        String configName = clazz.getAnnotation(ConfigurationClass.class).value();
        Configuration config = configuration.getConfiguration(configName);
        if (config == null) {
            LOG.warn("No configuration [" + configName + "] found for [" + clazz.getName() + "]");
            return null;
        }
        if (config instanceof ConfigurationImpl) {
            impl = (ConfigurationImpl)config;
            Configurable configurable = null;
            if (impl.configuredObjectReference != null) {
                configurable = (Configurable)impl.configuredObjectReference.get();
            }
            if (configurable != null) {
                if (configurable != instance) {
                    throw new IllegalArgumentException("Configuration can't be used by " + instance + ", because already in use by " + configurable);
                }
            } else {
                impl.configuredObjectReference = new WeakReference<Configurable>(instance);
            }
        }
        try {
            impl = Configurator.configureByCurrent(instance, config);
            return impl;
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
            if (config instanceof ConfigurationImpl) {
                ConfigurationImpl impl2 = (ConfigurationImpl)config;
                impl2.configuredObjectReference = null;
            }
        }
        finally {
            config.clearCache();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Configuration configureByCurrent(Configurable instance, Configuration configuration) throws ConfigurationException {
        AFields annotatedFields = Configurator.getConfigurationAnnotatedFields(instance.getClass());
        Set<String> properties = configuration.getProperties();
        if (properties.isEmpty()) {
            return configuration;
        }
        for (String string : properties) {
            String msg;
            AField aField = annotatedFields.findByAnnotationValue(string);
            if (aField == null) {
                LOG.warn("Unused property " + string + " @" + configuration.getName());
                continue;
            }
            Field field = aField.getField();
            field.setAccessible(true);
            Object value = null;
            Class<?> fieldType = field.getType();
            try {
                block61: {
                    NewClass newClass = Configurator.getAnnotation(field, NewClass.class);
                    if (newClass != null) {
                        value = Constructor.load(newClass, instance, configuration.getConfiguration(string));
                    } else if (String.class == fieldType) {
                        value = configuration.getProperty(string);
                    } else if (Integer.TYPE == fieldType || Integer.class == fieldType) {
                        if (field.isAnnotationPresent(ConfigurationFieldSettings.class)) {
                            String settings = field.getAnnotation(ConfigurationFieldSettings.class).value();
                            ConfigurationFieldSettings.SettingKey settingKey = ConfigurationFieldSettings.SettingKey.forSettings(settings);
                            try {
                                if (settingKey == ConfigurationFieldSettings.SettingKey.RADIX) {
                                    int radix = Integer.valueOf(settingKey.extractValueFromSettings(settings));
                                    value = Integer.valueOf(configuration.getProperty(string), radix);
                                    break block61;
                                } else {
                                    value = settingKey == ConfigurationFieldSettings.SettingKey.OCTAL_STRING ? Integer.valueOf(configuration.getProperty(string), 8) : Integer.valueOf(configuration.getProperty(string));
                                }
                                break block61;
                            }
                            catch (NumberFormatException e) {
                                LOG.error(e.getMessage(), (Throwable)e);
                                continue;
                            }
                        }
                        value = configuration.getPropertyInteger(string);
                    } else if (Long.TYPE == fieldType || Long.class == fieldType) {
                        value = configuration.getPropertyLong(string);
                    } else if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                        value = configuration.getPropertyBoolean(string);
                    } else if (Map.class == fieldType) {
                        value = configuration.getPropertyMap(string);
                    } else if (List.class != fieldType) {
                        if (XmldbURI.class == fieldType) {
                            value = XmldbURI.create(configuration.getProperty(string));
                        } else {
                            Configuration conf2 = configuration.getConfiguration(string);
                            if (conf2 == null) {
                                conf2 = configuration;
                            }
                            if ((value = Configurator.create(conf2, instance, fieldType)) == null) {
                                value = configuration.getProperty(string);
                            }
                        }
                    }
                }
                if (value == null || value.equals(field.get(instance))) continue;
                Method method = Configurator.searchForSetMethod(instance.getClass(), field);
                if (method != null) {
                    try {
                        method.invoke((Object)instance, value);
                    }
                    catch (InvocationTargetException e) {
                        LOG.warn((Object)e);
                        method = null;
                    }
                }
                if (method != null) continue;
                field.set(instance, value);
            }
            catch (IllegalArgumentException iae) {
                msg = "Configuration error: " + EOL + " config: " + configuration.getName() + EOL + " property: " + string + EOL + " message: " + iae.getMessage();
                LOG.error(msg, (Throwable)iae);
                throw new ConfigurationException(msg, iae);
            }
            catch (IllegalAccessException iae) {
                msg = "Security error: " + EOL + " config: " + configuration.getName() + EOL + " property: " + string + EOL + " message: " + iae.getMessage();
                LOG.error(msg, (Throwable)iae);
                throw new ConfigurationException(msg, iae);
            }
        }
        Field field = null;
        try {
            for (AField<ConfigurationFieldAsElement> aField : annotatedFields.getElements()) {
                Optional<Object> referenceBy;
                List<Configuration> confs;
                field = aField.getField();
                Class<?> fieldType = field.getType();
                if (List.class != fieldType) continue;
                String confName = aField.getAnnotation().value();
                field.setAccessible(true);
                ArrayList<Object> list = (ArrayList<Object>)field.get(instance);
                if (field.isAnnotationPresent(ConfigurationReferenceBy.class)) {
                    confs = configuration.getConfigurations(confName);
                    referenceBy = Optional.ofNullable(field.getAnnotation(ConfigurationReferenceBy.class).value());
                } else {
                    confs = configuration.getConfigurations(confName);
                    referenceBy = Optional.empty();
                }
                if (list == null) {
                    list = new ArrayList<Object>(confs.size());
                    field.set(instance, list);
                }
                if (confs == null) continue;
                HashMap<String, Integer> removed = new HashMap<String, Integer>();
                for (int i = 0; i < list.size(); ++i) {
                    List<Configuration> applicableConfs;
                    Configuration current_conf;
                    Object obj;
                    block62: {
                        block64: {
                            obj = list.get(i);
                            current_conf = null;
                            if (!(obj instanceof Configurable)) {
                                list.remove(i);
                                continue;
                            }
                            if (!(obj instanceof Reference)) break block64;
                            if (!referenceBy.isPresent()) {
                                LOG.error("illegal design '" + configuration.getName() + "' [" + field + "]");
                                list.remove(i);
                                continue;
                            }
                            String name = ((Reference)obj).getName();
                            applicableConfs = Configurator.filter(confs, conf -> Optional.ofNullable(conf.getPropertyBoolean((String)referenceBy.get())).map(value -> !value.equals(name)).orElse(true));
                            if (applicableConfs.size() == confs.size()) {
                                LOG.debug("Configuration was removed, will attempt to replace object [" + obj + "].");
                                Field referee = Configurator.getFieldRecursive(Optional.of(list.get(i).getClass()), (String)referenceBy.get());
                                if (referee != null) {
                                    referee.setAccessible(true);
                                    removed.put((String)referee.get(list.remove(i)), i);
                                    break block62;
                                } else {
                                    LOG.error("Could not lookup referenced field: " + (String)referenceBy.get() + " against: " + list.get(i).getClass().getName());
                                    list.remove(i);
                                }
                                break block62;
                            } else {
                                confs = applicableConfs;
                            }
                            break block62;
                        }
                        current_conf = ((Configurable)obj).getConfiguration();
                    }
                    if (current_conf == null) {
                        Field referee;
                        if (obj instanceof RealmImpl || list.size() <= i) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No configured instance of [" + obj + "], will attempt to replace object...");
                        }
                        if ((referee = Configurator.getFieldRecursive(Optional.of(list.get(i).getClass()), (String)referenceBy.get())) != null) {
                            referee.setAccessible(true);
                            removed.put((String)referee.get(list.remove(i)), i);
                            continue;
                        }
                        LOG.error("Could not lookup referenced field: " + (String)referenceBy.get() + " against: " + list.get(i).getClass().getName());
                        list.remove(i);
                        continue;
                    }
                    Configuration final_current_conf = current_conf;
                    applicableConfs = Configurator.filter(confs, conf -> !final_current_conf.equals(conf, referenceBy));
                    if (applicableConfs.size() == confs.size()) {
                        Configurable old;
                        String key;
                        LOG.debug("Configuration was removed, will attempt to replace [" + obj + "].");
                        if (list.size() <= i || (key = (old = (Configurable)list.remove(i)).getConfiguration().getProperty((String)referenceBy.orElse("id"))) == null) continue;
                        removed.put(key, i);
                        continue;
                    }
                    confs = applicableConfs;
                }
                for (Configuration conf3 : confs) {
                    block63: {
                        String value;
                        block65: {
                            if (!referenceBy.isPresent()) break block65;
                            String value2 = conf3.getProperty((String)referenceBy.get());
                            if (value2 == null) break block63;
                            Optional<ConsumerE<String, ReflectiveOperationException>> updateFn = Configurator.updateListFn(instance, confName, removed, value2);
                            if (!updateFn.isPresent()) {
                                LOG.error("Could not insert configured object");
                                break block63;
                            } else {
                                try {
                                    updateFn.get().accept((Object)value2);
                                    continue;
                                }
                                catch (ReflectiveOperationException e) {
                                    LOG.warn("Could not update " + instance.getClass().getName() + " for configuration '" + conf3.getName() + "' referenceBy '" + (String)referenceBy.get() + "' for value '" + value2 + "'", (Throwable)e);
                                    break block63;
                                }
                            }
                        }
                        Type genericType = field.getGenericType();
                        if (genericType != null && "java.util.List<java.lang.String>".equals(genericType.toString()) && (value = conf3.getValue()) != null) {
                            Optional<ConsumerE<String, ReflectiveOperationException>> updateFn = Configurator.updateListFn(instance, confName, removed, value);
                            if (!updateFn.isPresent()) {
                                LOG.error("Could not insert configured object");
                            } else {
                                try {
                                    updateFn.get().accept((Object)value);
                                    continue;
                                }
                                catch (ReflectiveOperationException e) {
                                    LOG.warn("Could not update " + instance.getClass().getName() + " for configuration '" + conf3.getName() + "' for value '" + value + "'", (Throwable)e);
                                }
                            }
                        }
                    }
                    ConfigurationFieldClassMask annotation = Configurator.getAnnotation(field, ConfigurationFieldClassMask.class);
                    if (annotation == null) {
                        NewClass newClass = Configurator.getAnnotation(field, NewClass.class);
                        if (newClass != null) {
                            Object obj = Constructor.load(newClass, instance, conf3);
                            if (obj == null) continue;
                            list.add(obj);
                            continue;
                        }
                        LOG.error("Field '" + field.getName() + "' must have '@org.exist.config.annotation.ConfigurationFieldClassMask' annotation [" + conf3.getName() + "], skipping instance creation.");
                        continue;
                    }
                    String id = conf3.getProperty("id");
                    Object[] objs = id == null ? new Object[]{"", ""} : new Object[]{id.toLowerCase(), id};
                    String clazzName = String.format(annotation.value(), objs);
                    Configurable obj = Configurator.create(conf3, instance, clazzName);
                    if (obj == null) continue;
                    list.add(obj);
                }
            }
            return configuration;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "Configuration error: " + EOL + " config: " + configuration.getName() + EOL + " field: " + field + EOL + " message: " + illegalArgumentException.getMessage();
            LOG.error(string, (Throwable)illegalArgumentException);
            throw new ConfigurationException(string, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = "Security error: " + EOL + " config: " + configuration.getName() + EOL + " field: " + field + EOL + " message: " + illegalAccessException.getMessage();
            LOG.error(string, (Throwable)illegalAccessException);
            throw new ConfigurationException(string, illegalAccessException);
        }
    }

    private static Optional<ConsumerE<String, ReflectiveOperationException>> updateListFn(Configurable instance, String confName, Map<String, Integer> removed, String value) {
        return Optional.ofNullable(removed.get(value)).map(removedIdx -> Optional.ofNullable(Configurator.searchForInsertMethod(instance.getClass(), confName)).map(insertMethod -> v -> insertMethod.invoke((Object)instance, removedIdx, v))).orElse(Optional.ofNullable(Configurator.searchForAddMethod(instance.getClass(), confName)).map(addMethod -> v -> addMethod.invoke((Object)instance, v)));
    }

    private static Field getFieldRecursive(Optional<Class> maybeClazz, String name) {
        return maybeClazz.map(clazz -> Stream.of(clazz.getDeclaredFields()).filter(field -> field.getName().equals(name)).findFirst().orElse(Configurator.getFieldRecursive(Optional.ofNullable(clazz.getSuperclass()), name))).orElse(null);
    }

    private static List<Configuration> filter(List<Configuration> configurations, Predicate<Configuration> predicate) {
        return configurations.stream().filter(predicate).collect(Collectors.toList());
    }

    private static Configurable create(Configuration conf, Configurable instance, String clazzName) {
        Configurable configurable;
        try {
            Class<?> clazz = Class.forName(clazzName);
            configurable = Configurator.create(conf, instance, clazz);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.error("Class [" + clazzName + "] not found, skip instance creation.");
            configurable = null;
        }
        return configurable;
    }

    private static Configurable create(Configuration conf, Configurable instance, Class<?> clazz) {
        try {
            Configurable obj = null;
            try {
                java.lang.reflect.Constructor<?> constructor = clazz.getConstructor(instance.getClass(), Configuration.class);
                obj = (Configurable)constructor.newInstance(instance, conf);
            }
            catch (NoSuchMethodException e) {
                LOG.debug("Unable to invoke Constructor on Configurable instance '" + e.getMessage() + "', so creating new Constructor...");
                java.lang.reflect.Constructor<?> constructor = clazz.getConstructor(Configuration.class);
                obj = (Configurable)constructor.newInstance(conf);
            }
            if (obj == null) {
                return null;
            }
            if (obj instanceof LifeCycle) {
                BrokerPool db = null;
                try {
                    db = BrokerPool.getInstance();
                }
                catch (EXistException e) {
                    LOG.warn("Unable to start lifecycle object: {}", (Object)obj.getClass().getName());
                }
                if (db != null) {
                    try (DBBroker broker = db.getBroker();){
                        ((LifeCycle)((Object)obj)).start(broker);
                    }
                }
            }
            return obj;
        }
        catch (SecurityException se) {
            LOG.warn("Security exception on class [" + clazz + "] creation '" + se.getMessage() + "' ,skipping instance creation.");
            LOG.debug(se.getMessage(), (Throwable)se);
        }
        catch (NoSuchMethodException nsme) {
            LOG.warn(clazz + " constructor (" + instance.getClass().getName() + ", " + Configuration.class.getName() + ") or (" + Configuration.class.getName() + ")not found '" + nsme.getMessage() + "', skipping instance creation.");
            LOG.debug(nsme.getMessage(), (Throwable)nsme);
        }
        catch (InstantiationException ie) {
            LOG.warn("Instantiation exception on " + clazz + " creation '" + ie.getMessage() + "', skipping instance creation.");
            LOG.debug(ie.getMessage(), (Throwable)ie);
        }
        catch (InvocationTargetException ite) {
            LOG.warn("Invocation target exception on " + clazz + " creation '" + ite.getMessage() + "', skipping instance creation.");
            LOG.debug(ite.getMessage(), (Throwable)ite);
        }
        catch (EXistException ee) {
            LOG.warn("Database exception on " + clazz + " startup '" + ee.getMessage() + "', skipping instance creation.");
            LOG.debug(ee.getMessage(), (Throwable)ee);
        }
        catch (IllegalAccessException iae) {
            LOG.warn(iae.getMessage());
            LOG.debug(iae.getMessage(), (Throwable)iae);
        }
        return null;
    }

    public static Configuration parse(File file) throws ConfigurationException {
        try {
            return Configurator.parse(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
    }

    public static Configuration parse(InputStream is) throws ConfigurationException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(is);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter();
            reader.setContentHandler(adapter);
            reader.parse(src);
            return new ConfigurationImpl(adapter.getDocument().getDocumentElement());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ConfigurationException(e);
        }
    }

    private static Boolean implementsInterface(Class<?> object, Class<?> iface) {
        for (Class<?> c : object.getInterfaces()) {
            if (!c.equals(iface)) continue;
            return true;
        }
        return false;
    }

    protected static void serializeByReference(Configurable instance, SAXSerializer serializer, String fieldAsElementName, String referenceBy) throws SAXException {
        String value = ((ReferenceImpl)instance).getName();
        QName qnConfig = new QName(fieldAsElementName, "http://exist-db.org/Configuration");
        if (value == null) {
            String comment = "<" + qnConfig + " " + referenceBy + "=''/>";
            char[] ch = comment.toCharArray();
            serializer.characters(EOL.toCharArray(), 0, EOL.length());
            serializer.comment(ch, 0, ch.length);
        } else {
            serializer.startElement(qnConfig, null);
            serializer.attribute(new QName(referenceBy, null), value.toString());
            serializer.endElement(qnConfig);
        }
    }

    protected static void serialize(Configurable instance, SAXSerializer serializer, String fieldAsElementName, String referenceBy) throws SAXException {
        String value;
        if (instance instanceof ReferenceImpl) {
            Configurator.serializeByReference(instance, serializer, fieldAsElementName, referenceBy);
            return;
        }
        Class<?> clazz = instance.getClass();
        instance.getClass().getAnnotations();
        if (!clazz.isAnnotationPresent(ConfigurationClass.class)) {
            return;
        }
        AFields annotatedFields = Configurator.getConfigurationAnnotatedFields(instance.getClass());
        AField annotatedField = annotatedFields.findByAnnotationValue(referenceBy);
        if (annotatedField == null) {
            return;
        }
        Field field = annotatedField.getField();
        if (field == null) {
            LOG.error("Reference field '" + referenceBy + "' can't be found for class '" + clazz + "'");
            return;
        }
        field.setAccessible(true);
        try {
            value = Configurator.extractFieldValue(field, instance);
        }
        catch (IllegalAccessException | IllegalArgumentException iae) {
            LOG.error(iae.getMessage(), (Throwable)iae);
            return;
        }
        QName qnConfig = new QName(fieldAsElementName, "http://exist-db.org/Configuration");
        if (value == null) {
            String comment = "<" + qnConfig + " " + referenceBy + "=''/>";
            char[] ch = comment.toCharArray();
            serializer.characters(EOL.toCharArray(), 0, EOL.length());
            serializer.comment(ch, 0, ch.length);
        } else {
            serializer.startElement(qnConfig, null);
            serializer.attribute(new QName(referenceBy, null), value);
            serializer.endElement(qnConfig);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractFieldValue(Field field, Configurable instance) throws IllegalArgumentException, IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (String.class == fieldType) {
            return field.get(instance).toString();
        }
        if (Integer.TYPE == fieldType || Integer.class == fieldType) {
            if (!field.isAnnotationPresent(ConfigurationFieldSettings.class)) return field.get(instance).toString();
            String settings = field.getAnnotation(ConfigurationFieldSettings.class).value();
            ConfigurationFieldSettings.SettingKey settingKey = ConfigurationFieldSettings.SettingKey.forSettings(settings);
            if (settingKey != ConfigurationFieldSettings.SettingKey.RADIX) {
                if (settingKey != ConfigurationFieldSettings.SettingKey.OCTAL_STRING) return Integer.toString((Integer)field.get(instance));
                return "0" + Integer.toString((Integer)field.get(instance), 8);
            }
            try {
                int radix = Integer.valueOf(settingKey.extractValueFromSettings(settings));
                return Integer.toString((Integer)field.get(instance), radix);
            }
            catch (Exception e) {
                LOG.error((Object)e);
                return null;
            }
        }
        if (Long.TYPE == fieldType) return field.get(instance).toString();
        if (Long.class == fieldType) {
            return field.get(instance).toString();
        }
        if (Boolean.TYPE == fieldType) return Boolean.valueOf(field.get(instance).toString()).toString();
        if (Boolean.class == fieldType) {
            return Boolean.valueOf(field.get(instance).toString()).toString();
        }
        if (XmldbURI.class != fieldType) return null;
        return field.get(instance).toString();
    }

    protected static void serialize(Configurable instance, SAXSerializer serializer) throws ConfigurationException {
        Class<?> clazz = instance.getClass();
        instance.getClass().getAnnotations();
        if (!clazz.isAnnotationPresent(ConfigurationClass.class)) {
            return;
        }
        String configName = clazz.getAnnotation(ConfigurationClass.class).value();
        try {
            QName qnConfig = new QName(configName, "http://exist-db.org/Configuration");
            serializer.startElement(qnConfig, null);
            boolean simple = true;
            AFields annotatedFields = Configurator.getConfigurationAnnotatedFields(instance.getClass());
            try {
                Field field;
                for (AField<ConfigurationFieldAsAttribute> aField : annotatedFields.getAttributes()) {
                    field = aField.getField();
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(ConfigurationFieldAsElement.class) || field.get(instance) == null) continue;
                    String value = Configurator.extractFieldValue(field, instance);
                    serializer.attribute(new QName(aField.getAnnotation().value(), null), value);
                }
                for (AField<Annotation> aField : annotatedFields.getElements()) {
                    simple = true;
                    field = aField.getField();
                    field.setAccessible(true);
                    if (!field.isAnnotationPresent(ConfigurationFieldAsElement.class) || field.isAnnotationPresent(NewClass.class)) continue;
                    String referenceBy = null;
                    if (field.isAnnotationPresent(ConfigurationReferenceBy.class)) {
                        referenceBy = field.getAnnotation(ConfigurationReferenceBy.class).value();
                    }
                    if (field.get(instance) == null) {
                        String tagName = ((ConfigurationFieldAsElement)aField.getAnnotation()).value();
                        String comment = "<" + tagName;
                        comment = referenceBy != null ? comment + " " + referenceBy + "=\"\"/>" : comment + "></" + tagName + ">";
                        serializer.characters(EOL.toCharArray(), 0, EOL.length());
                        char[] ch = comment.toCharArray();
                        serializer.comment(ch, 0, ch.length);
                        continue;
                    }
                    String value = null;
                    String typeName = field.getType().getName();
                    if ("java.util.List".equals(typeName)) {
                        Configurator.serializeList(instance, aField, serializer);
                        continue;
                    }
                    if (Configurator.implementsInterface(field.getType(), Configurable.class).booleanValue()) {
                        Configurable subInstance = (Configurable)field.get(instance);
                        Configurator.serialize(subInstance, serializer);
                        continue;
                    }
                    if ("java.util.Map".equals(typeName)) {
                        Configurator.serializeMap(((ConfigurationFieldAsElement)aField.getAnnotation()).value(), (Map)field.get(instance), serializer);
                        continue;
                    }
                    value = Configurator.extractFieldValue(field, instance);
                    if (value == null) {
                        LOG.error("field '" + field.getName() + "' has unsupported type [" + typeName + "] - skipped");
                    }
                    if (value != null && value.length() > 0) {
                        if (simple) {
                            QName qnSimple = new QName(((ConfigurationFieldAsElement)aField.getAnnotation()).value(), "http://exist-db.org/Configuration");
                            serializer.startElement(qnSimple, null);
                            serializer.characters(value);
                            serializer.endElement(new QName(((ConfigurationFieldAsElement)aField.getAnnotation()).value(), null));
                            continue;
                        }
                        serializer.characters(value);
                        continue;
                    }
                    String tagName = ((ConfigurationFieldAsElement)aField.getAnnotation()).value();
                    String comment = "<" + tagName;
                    comment = referenceBy != null ? comment + " " + referenceBy + "=\"\"/>" : comment + "></" + tagName + ">";
                    serializer.characters(EOL.toCharArray(), 0, EOL.length());
                    char[] ch = comment.toCharArray();
                    serializer.comment(ch, 0, ch.length);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            serializer.endElement(qnConfig);
        }
        catch (SAXException saxe) {
            throw new ConfigurationException(saxe.getMessage(), saxe);
        }
    }

    private static void serializeList(Configurable instance, AField<ConfigurationFieldAsElement> element, SAXSerializer serializer) throws ConfigurationException, IllegalArgumentException, IllegalAccessException, SAXException {
        Field field = element.getField();
        field.setAccessible(true);
        Type fieldGenericType = field.getGenericType();
        if (fieldGenericType instanceof ParameterizedType) {
            Type[] genericTypeArgs = ((ParameterizedType)fieldGenericType).getActualTypeArguments();
            if (genericTypeArgs != null && genericTypeArgs.length == 1) {
                Type genericListType = genericTypeArgs[0];
                if (genericListType.equals(String.class)) {
                    Configurator.serializeStringList((List)field.get(instance), element, serializer);
                } else {
                    Configurator.serializeConfigurableList((List)field.get(instance), field, element, serializer);
                }
            }
        } else {
            Configurator.serializeConfigurableList((List)field.get(instance), field, element, serializer);
        }
    }

    private static void serializeStringList(List<String> list, AField<ConfigurationFieldAsElement> element, SAXSerializer serializer) throws SAXException {
        String fieldAsElementName = element.getAnnotation().value();
        QName qnConfig = new QName(fieldAsElementName, "http://exist-db.org/Configuration");
        for (String listItem : list) {
            serializer.startElement(qnConfig, null);
            serializer.characters(listItem);
            serializer.endElement(qnConfig);
        }
    }

    private static void serializeConfigurableList(List<Configurable> list, Field field, AField<ConfigurationFieldAsElement> element, SAXSerializer serializer) throws ConfigurationException, SAXException {
        String referenceBy = null;
        if (field.isAnnotationPresent(ConfigurationReferenceBy.class)) {
            referenceBy = field.getAnnotation(ConfigurationReferenceBy.class).value();
        }
        for (Configurable el : list) {
            if (referenceBy == null) {
                Configurator.serialize(el, serializer);
                continue;
            }
            Configurator.serialize(el, serializer, element.getAnnotation().value(), referenceBy);
        }
    }

    private static void serializeMap(String mapName, Map<String, String> map, SAXSerializer serializer) throws SAXException {
        if (map != null) {
            QName mapQName = new QName(mapName, "http://exist-db.org/Configuration");
            QName attrQName = new QName("key", "");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                serializer.startElement(mapQName, null);
                serializer.attribute(attrQName, entry.getKey());
                serializer.characters(entry.getValue());
                serializer.endElement(mapQName);
            }
        }
    }

    public static FullXmldbURI getFullURI(BrokerPool pool, XmldbURI uri) {
        if (uri instanceof FullXmldbURI) {
            return (FullXmldbURI)uri;
        }
        StringBuilder accessor = new StringBuilder("xmldb:");
        accessor.append(pool.getId());
        accessor.append("://");
        accessor.append("");
        return (FullXmldbURI)XmldbURI.create(accessor.toString(), uri.toString());
    }

    public static Configuration parse(Configurable instance, DBBroker broker, Collection collection, XmldbURI fileURL) throws ConfigurationException {
        DocumentImpl document;
        FullXmldbURI key = Configurator.getFullURI(broker.getBrokerPool(), collection.getURI().append(fileURL));
        Configuration conf = (Configuration)hotConfigs.get(key);
        if (conf != null) {
            return conf;
        }
        try {
            document = collection.getDocument(broker, fileURL);
        }
        catch (PermissionDeniedException pde) {
            throw new ConfigurationException(pde.getMessage(), pde);
        }
        if (document == null) {
            if (broker.isReadOnly()) {
                try {
                    StringWriter writer = new StringWriter();
                    SAXSerializer serializer = new SAXSerializer(writer, null);
                    serializer.startDocument();
                    Configurator.serialize(instance, serializer);
                    serializer.endDocument();
                    String data = writer.toString();
                    if (data == null || data.length() == 0) {
                        return null;
                    }
                    return Configurator.parse(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));
                }
                catch (SAXException saxe) {
                    throw new ConfigurationException(saxe.getMessage(), saxe);
                }
            }
            try {
                document = Configurator.save(instance, broker, collection, fileURL);
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        if (document == null) {
            return null;
        }
        Element confElement = document.getDocumentElement();
        if (confElement == null) {
            return null;
        }
        conf = new ConfigurationImpl(confElement);
        hotConfigs.put(key, conf);
        return conf;
    }

    public static Configuration parse(BrokerPool pool, DocumentImpl document) {
        if (document == null) {
            return null;
        }
        FullXmldbURI key = Configurator.getFullURI(pool, document.getURI());
        Configuration conf = (Configuration)hotConfigs.get(key);
        if (conf != null) {
            return conf;
        }
        Element confElement = document.getDocumentElement();
        if (confElement == null) {
            return null;
        }
        conf = new ConfigurationImpl(confElement);
        hotConfigs.put(key, conf);
        return conf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentImpl save(Configurable instance, XmldbURI uri) throws IOException {
        BrokerPool database;
        try {
            database = BrokerPool.getInstance();
        }
        catch (EXistException e) {
            throw new IOException(e);
        }
        try (DBBroker broker = database.getBroker();){
            DocumentImpl documentImpl = Configurator.save(broker, instance, uri);
            return documentImpl;
        }
        catch (EXistException e) {
            throw new IOException(e);
        }
    }

    public static DocumentImpl save(DBBroker broker, Configurable instance, XmldbURI uri) throws IOException {
        try {
            Collection collection = broker.getCollection(uri.removeLastSegment());
            if (collection == null) {
                throw new IOException("Collection URI = " + uri.removeLastSegment() + " not found.");
            }
            return Configurator.save(instance, broker, collection, uri.lastSegment());
        }
        catch (EXistException | PermissionDeniedException pde) {
            throw new IOException(pde);
        }
    }

    public static DocumentImpl save(Configurable instance, DBBroker broker, Collection collection, XmldbURI uri) throws IOException, ConfigurationException {
        DocumentImpl documentImpl;
        StringWriter writer = new StringWriter();
        SAXSerializer serializer = new SAXSerializer(writer, null);
        try {
            serializer.startDocument();
            Configurator.serialize(instance, serializer);
            serializer.endDocument();
        }
        catch (SAXException saxe) {
            throw new ConfigurationException(saxe.getMessage(), saxe);
        }
        String data = writer.toString();
        if (data == null || data.length() == 0) {
            return null;
        }
        FullXmldbURI fullURI = null;
        BrokerPool pool = broker.getBrokerPool();
        TransactionManager transact = pool.getTransactionManager();
        Txn txn = null;
        LOG.info("Storing configuration " + collection.getURI() + "/" + uri);
        try {
            broker.pushSubject(pool.getSecurityManager().getSystemSubject());
            txn = transact.beginTransaction();
            txn.acquireLock(collection.getLock(), Lock.LockMode.WRITE_LOCK);
            IndexInfo info = collection.validateXMLResource(txn, broker, uri, data);
            DocumentImpl doc = info.getDocument();
            doc.getMetadata().setMimeType(MimeType.XML_TYPE.getName());
            doc.getPermissions().setMode(504);
            fullURI = Configurator.getFullURI(pool, doc.getURI());
            saving.add(fullURI);
            collection.store(txn, broker, info, data);
            broker.saveCollection(txn, doc.getCollection());
            transact.commit(txn);
            saving.remove(fullURI);
            broker.flush();
            broker.sync(Sync.MAJOR);
            documentImpl = collection.getDocument(broker, uri.lastSegment());
            transact.close(txn);
            broker.popSubject();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)e);
                if (fullURI != null) {
                    saving.remove(fullURI);
                }
                if (txn != null) {
                    transact.abort(txn);
                }
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                transact.close(txn);
                broker.popSubject();
                throw throwable;
            }
        }
        return documentImpl;
    }

    public static synchronized void clear(Database db) {
        for (Map.Entry entry : hotConfigs.entrySet()) {
            Configuration conf;
            FullXmldbURI uri = (FullXmldbURI)entry.getKey();
            if (uri.getInstanceName().equals(db.getId()) && (conf = (Configuration)entry.getValue()) instanceof ConfigurationImpl) {
                ((ConfigurationImpl)conf).configuredObjectReference = null;
            }
            hotConfigs.remove(uri);
        }
    }

    public static void unregister(Configuration configuration) {
        if (configuration == null) {
            return;
        }
        if (hotConfigs.containsValue(configuration)) {
            for (Map.Entry entry : hotConfigs.entrySet()) {
                if (entry.getValue() != configuration) continue;
                hotConfigs.remove(entry.getKey());
                return;
            }
        }
    }

    public static Configuration getConfigurtion(BrokerPool db, XmldbURI uri) {
        return (Configuration)hotConfigs.get(Configurator.getFullURI(db, uri));
    }

    private static class AField<T> {
        private final T annotation;
        private final Field field;

        public AField(T annotation, Field field) {
            this.annotation = annotation;
            this.field = field;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public Field getField() {
            return this.field;
        }
    }

    private static class AFields
    implements Iterable<AField> {
        private List<AField<ConfigurationFieldAsAttribute>> attributes = new ArrayList<AField<ConfigurationFieldAsAttribute>>();
        private List<AField<ConfigurationFieldAsElement>> elements = new ArrayList<AField<ConfigurationFieldAsElement>>();

        private AFields() {
        }

        public void addAttribute(AField<ConfigurationFieldAsAttribute> attribute) {
            this.attributes.add(attribute);
        }

        public void addAllAttributes(List<AField<ConfigurationFieldAsAttribute>> attributes) {
            this.attributes.addAll(attributes);
        }

        public void addElement(AField<ConfigurationFieldAsElement> element) {
            this.elements.add(element);
        }

        public void addAllElements(List<AField<ConfigurationFieldAsElement>> elements) {
            this.elements.addAll(elements);
        }

        public List<AField<ConfigurationFieldAsAttribute>> getAttributes() {
            return this.attributes;
        }

        public List<AField<ConfigurationFieldAsElement>> getElements() {
            return this.elements;
        }

        public AField findByAnnotationValue(String value) {
            for (AField<ConfigurationFieldAsAttribute> aField : this.attributes) {
                if (!aField.getAnnotation().value().equals(value)) continue;
                return aField;
            }
            for (AField<Annotation> aField : this.elements) {
                if (!((ConfigurationFieldAsElement)aField.getAnnotation()).value().equals(value)) continue;
                return aField;
            }
            return null;
        }

        @Override
        public Iterator<AField> iterator() {
            return new Iterator<AField>(){
                private final Iterator<AField<ConfigurationFieldAsAttribute>> itAttributes;
                private final Iterator<AField<ConfigurationFieldAsElement>> itElements;
                {
                    this.itAttributes = attributes.iterator();
                    this.itElements = elements.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.itAttributes.hasNext() | this.itElements.hasNext();
                }

                @Override
                public AField next() {
                    if (this.itAttributes.hasNext()) {
                        return this.itAttributes.next();
                    }
                    if (this.itElements.hasNext()) {
                        return this.itElements.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
        }
    }
}

