/*
 * Decompiled with CFR 0.152.
 */
package org.exist.config.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface ConfigurationFieldSettings {
    public static final String OCTAL_STRING_KEY = "octalString";
    public static final String RADIX_KEY = "radix";
    public static final String KEY_VALUE_SEP = "=";

    public String value();

    public static enum SettingKey {
        OCTAL_STRING("octalString"),
        RADIX("radix");

        private final String key;

        private SettingKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String extractValueFromSettings(String settings) {
            return settings.substring(this.getKey().length() + ConfigurationFieldSettings.KEY_VALUE_SEP.length());
        }

        public static SettingKey forSettings(String settings) {
            if (settings.contains(ConfigurationFieldSettings.KEY_VALUE_SEP)) {
                return SettingKey.forKey(settings.substring(0, settings.indexOf(ConfigurationFieldSettings.KEY_VALUE_SEP)));
            }
            return SettingKey.forKey(settings);
        }

        public static SettingKey forKey(String key) {
            for (SettingKey settingKey : SettingKey.values()) {
                if (!settingKey.getKey().equals(key)) continue;
                return settingKey;
            }
            throw new IllegalArgumentException("No such Setting for key: " + key);
        }
    }
}

