/*
 * Decompiled with CFR 0.152.
 */
package org.exist.config.mapper;

import java.lang.reflect.Method;
import org.exist.config.Configuration;
import org.exist.config.Configurator;

public class CallMethod {
    private Object obj = null;
    private Configuration conf = null;
    private Object value = null;
    private String name = null;
    private String attribute = null;
    private String element = null;

    public CallMethod(Object obj, Configuration conf) {
        this.obj = obj;
        this.conf = conf;
    }

    public void set(String name, String value) {
        if ("name".equals(name)) {
            this.name = value;
        } else if ("attribute".equals(name)) {
            this.attribute = value;
        } else if ("element".equals(name)) {
            this.element = value;
        }
    }

    public boolean eval() throws Exception {
        Method[] methods;
        if (this.name == null) {
            Configurator.LOG.error("'callMethod' element must have 'name' attribute, skip instance creation.");
            return false;
        }
        if (this.attribute == null && this.element == null) {
            Configurator.LOG.error("'callMethod' element must have 'attribute' or 'element' attribute, skip instance creation.");
            return false;
        }
        for (Method method : methods = this.obj.getClass().getMethods()) {
            Class<?>[] types;
            if (!method.getName().equals(this.name) || (types = method.getParameterTypes()).length != 1) continue;
            String typeName = types[0].getName();
            if (this.element != null) {
                if (!typeName.equals(this.value.getClass().getName())) continue;
                method.invoke(this.obj, this.value);
                return true;
            }
            if ("java.lang.String".equals(typeName)) {
                method.invoke(this.obj, this.conf.getElement().getAttribute(this.attribute));
                return true;
            }
            if (!"int".equals(typeName) && !"java.lang.Integer".equals(typeName)) continue;
            method.invoke(this.obj, Integer.valueOf(this.conf.getElement().getAttribute(this.attribute)));
            return true;
        }
        Configurator.LOG.error("'callMethod' element '" + this.name + "' method can not be found, skip instance creation.");
        return false;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Configuration getConfiguration() {
        if (this.element != null) {
            return this.conf.getConfiguration(this.element);
        }
        return this.conf;
    }
}

