/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractCharacterData
extends NodeImpl
implements CharacterData {
    public AbstractCharacterData(DocumentImpl doc, int nodeNumber) {
        super(doc, nodeNumber);
    }

    @Override
    public int getLength() {
        return this.document.alphaLen[this.nodeNumber];
    }

    @Override
    public String getData() throws DOMException {
        return new String(this.document.characters, this.document.alpha[this.nodeNumber], this.document.alphaLen[this.nodeNumber]);
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        if (offset < 0 || count < 0) {
            throw new DOMException(1, "offset is out of bounds");
        }
        int length = this.document.alphaLen[this.nodeNumber];
        int inDocOffset = this.document.alpha[this.nodeNumber];
        if (offset > length) {
            throw new DOMException(1, "offset is out of bounds");
        }
        if (offset + count > length) {
            return new String(this.document.characters, inDocOffset + offset, length - offset);
        }
        return new String(this.document.characters, inDocOffset + offset, length);
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        if (offset < 0 || count < 0) {
            throw new DOMException(1, "offset is out of bounds");
        }
        int existingDataLen = this.document.alphaLen[this.nodeNumber];
        if (offset > existingDataLen) {
            throw new DOMException(1, "offset is out of bounds");
        }
        if (offset + count > existingDataLen) {
            count = existingDataLen - offset;
        }
        int len = arg.length();
        int existingCharactersLen = this.document.characters.length;
        int existingDataOffset = this.document.alpha[this.nodeNumber];
        int change = len - count;
        int newCharactersLength = existingCharactersLen + change;
        char[] newCharacters = new char[newCharactersLength];
        System.arraycopy(this.document.characters, 0, newCharacters, 0, existingDataOffset + offset);
        System.arraycopy(arg.toCharArray(), 0, newCharacters, existingDataOffset + offset, len);
        int remainingExistingCharacters = len > 0 && existingDataLen < len ? existingCharactersLen - count : existingCharactersLen - existingDataOffset - offset - count;
        System.arraycopy(this.document.characters, existingDataOffset + offset + count, newCharacters, existingDataOffset + offset + len, remainingExistingCharacters);
        this.document.characters = newCharacters;
        this.document.alphaLen[this.nodeNumber] = existingDataLen + change;
        for (int i = this.nodeNumber + 1; i < this.document.alpha.length; ++i) {
            if (this.document.alpha[i] <= -1) continue;
            int n = i;
            this.document.alpha[n] = this.document.alpha[n] + change;
        }
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        if (offset < 0) {
            throw new DOMException(1, "offset is out of bounds");
        }
        int existingDataLen = this.document.alphaLen[this.nodeNumber];
        if (offset > existingDataLen) {
            throw new DOMException(1, "offset is out of bounds");
        }
        int len = arg.length();
        int existingDataOffset = this.document.alpha[this.nodeNumber];
        int existingCharactersLen = this.document.characters.length;
        int extraRequired = len;
        int newCharactersLen = existingCharactersLen + extraRequired;
        char[] newCharacters = new char[newCharactersLen];
        System.arraycopy(this.document.characters, 0, newCharacters, 0, existingDataOffset + offset);
        System.arraycopy(arg.toCharArray(), 0, newCharacters, existingDataOffset + offset, len);
        int remainingExistingCharacters = existingCharactersLen - (existingDataOffset + existingDataLen);
        System.arraycopy(this.document.characters, existingDataOffset + offset, newCharacters, existingDataOffset + offset + len, remainingExistingCharacters);
        this.document.characters = newCharacters;
        this.document.alphaLen[this.nodeNumber] = existingDataLen + len;
        int i = this.nodeNumber + 1;
        while (i < this.document.alpha.length) {
            int n = i++;
            this.document.alpha[n] = this.document.alpha[n] + extraRequired;
        }
    }

    @Override
    public void appendData(String arg) throws DOMException {
        if (arg == null || arg.length() == 0) {
            return;
        }
        int len = arg.length();
        int existingDataOffset = this.document.alpha[this.nodeNumber];
        int existingDataLen = this.document.alphaLen[this.nodeNumber];
        int existingCharactersLen = this.document.characters.length;
        int extraRequired = len;
        int newCharactersLen = existingCharactersLen + extraRequired;
        char[] newCharacters = new char[newCharactersLen];
        System.arraycopy(this.document.characters, 0, newCharacters, 0, existingDataOffset + existingDataLen);
        System.arraycopy(arg.toCharArray(), 0, newCharacters, existingDataOffset + existingDataLen, len);
        int remainingExistingCharacters = existingCharactersLen - (existingDataOffset + existingDataLen);
        System.arraycopy(this.document.characters, existingDataOffset + existingDataLen, newCharacters, existingDataOffset + existingDataLen + len, remainingExistingCharacters);
        this.document.characters = newCharacters;
        this.document.alphaLen[this.nodeNumber] = existingDataLen + len;
        int i = this.nodeNumber + 1;
        while (i < this.document.alpha.length) {
            int n = i++;
            this.document.alpha[n] = this.document.alpha[n] + extraRequired;
        }
    }

    @Override
    public void setData(String data) throws DOMException {
        if (data == null) {
            data = "";
        }
        int len = data.length();
        int existingDataOffset = this.document.alpha[this.nodeNumber];
        int existingDataLen = this.document.alphaLen[this.nodeNumber];
        if (len <= existingDataLen) {
            System.arraycopy(data.toCharArray(), 0, this.document.characters, existingDataOffset, len);
            this.document.alphaLen[this.nodeNumber] = len;
        } else {
            int existingCharactersLen = this.document.characters.length;
            int extraRequired = len - existingDataLen;
            int newCharactersLen = existingCharactersLen + extraRequired;
            char[] newCharacters = new char[newCharactersLen];
            System.arraycopy(this.document.characters, 0, newCharacters, 0, existingDataOffset);
            System.arraycopy(data.toCharArray(), 0, newCharacters, existingDataOffset, len);
            int remainingExistingCharacters = existingCharactersLen - (existingDataOffset + existingDataLen);
            System.arraycopy(this.document.characters, existingDataOffset + existingDataLen, newCharacters, existingDataOffset + len, remainingExistingCharacters);
            this.document.characters = newCharacters;
            this.document.alphaLen[this.nodeNumber] = len;
            int i = this.nodeNumber + 1;
            while (i < this.document.alpha.length) {
                int n = i++;
                this.document.alpha[n] = this.document.alpha[n] + extraRequired;
            }
        }
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        this.replaceData(offset, count, "");
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.setData(nodeValue);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    @Override
    public String getStringValue() {
        return this.getData();
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public void selectAttributes(NodeTest test, Sequence result) throws XPathException {
    }

    @Override
    public void selectChildren(NodeTest test, Sequence result) throws XPathException {
    }

    @Override
    public void selectDescendantAttributes(NodeTest test, Sequence result) throws XPathException {
    }
}

