/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NodeImpl;
import org.exist.numbering.NodeId;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class AttrImpl
extends NodeImpl
implements Attr {
    public static final int ATTR_CDATA_TYPE = 0;
    public static final int ATTR_ID_TYPE = 1;
    public static final int ATTR_IDREF_TYPE = 2;
    public static final int ATTR_IDREFS_TYPE = 3;

    public AttrImpl(DocumentImpl doc, int nodeNumber) {
        super(doc, nodeNumber);
    }

    @Override
    public NodeId getNodeId() {
        return this.document.attrNodeId[this.nodeNumber];
    }

    @Override
    public String getName() {
        return this.getQName().getStringValue();
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getBaseURI() {
        NodeImpl parent = this.document.getNode(this.document.attrParent[this.nodeNumber]);
        if (parent == null) {
            return null;
        }
        return parent.getBaseURI();
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public String getValue() {
        return this.document.attrValue[this.nodeNumber];
    }

    @Override
    public void setValue(String value) throws DOMException {
        this.document.attrValue[this.nodeNumber] = value;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.setValue(nodeValue);
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.document.attrValue[this.nodeNumber];
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    @Override
    public Element getOwnerElement() {
        return (Element)((Object)this.document.getNode(this.document.attrParent[this.nodeNumber]));
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public void selectDescendantAttributes(NodeTest test, Sequence result) throws XPathException {
        if (test.matches(this)) {
            result.add(this);
        }
    }

    @Override
    public Node selectParentNode() {
        return this.getOwnerElement();
    }

    @Override
    public void selectAncestors(boolean includeSelf, NodeTest test, Sequence result) throws XPathException {
        if (test.matches(this)) {
            result.add(this);
        }
        ((NodeImpl)((Object)this.getOwnerElement())).selectAncestors(true, test, result);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean isId() {
        return this.document.attrType[this.nodeNumber] == 1;
    }

    @Override
    public int getItemType() {
        return 2;
    }

    public String toString() {
        return "in-memory#attribute {" + this.getQName().getStringValue() + "} {" + this.getValue() + "} ";
    }

    @Override
    public void selectAttributes(NodeTest test, Sequence result) throws XPathException {
    }

    @Override
    public void selectChildren(NodeTest test, Sequence result) throws XPathException {
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof AttrImpl) {
            AttrImpl other = (AttrImpl)obj;
            return other.getQName().equals(this.getQName()) && other.document.attrValue[this.nodeNumber].equals(this.document.attrValue[this.nodeNumber]);
        }
        return false;
    }
}

