/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.dom.NodeListImpl;
import org.exist.dom.QName;
import org.exist.dom.memtree.AttrImpl;
import org.exist.dom.memtree.CDATASectionImpl;
import org.exist.dom.memtree.CommentImpl;
import org.exist.dom.memtree.DOMImplementationImpl;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.DocumentFragmentImpl;
import org.exist.dom.memtree.ElementImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NamespaceNode;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.memtree.ProcessingInstructionImpl;
import org.exist.dom.memtree.ReferenceNode;
import org.exist.dom.memtree.TextImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.NodeId;
import org.exist.numbering.NodeIdFactory;
import org.exist.storage.BrokerPool;
import org.exist.storage.serializers.Serializer;
import org.exist.util.hashtable.NamePool;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class DocumentImpl
extends NodeImpl<DocumentImpl>
implements Document {
    private static final int NODE_SIZE = 16;
    private static final int ATTR_SIZE = 8;
    private static final int CHAR_BUF_SIZE = 256;
    private static final int REF_SIZE = 8;
    private static long nextDocId = 0L;
    protected short[] nodeKind = null;
    protected short[] treeLevel;
    protected int[] next;
    protected QName[] nodeName;
    protected NodeId[] nodeId;
    protected int[] alpha;
    protected int[] alphaLen;
    protected char[] characters = null;
    protected int nextChar = 0;
    protected QName[] attrName;
    protected int[] attrType;
    protected NodeId[] attrNodeId;
    protected int[] attrParent;
    protected String[] attrValue;
    protected int nextAttr = 0;
    protected int[] namespaceParent = null;
    protected QName[] namespaceCode = null;
    protected int nextNamespace = 0;
    protected int size = 1;
    protected int documentRootNode = -1;
    protected String documentURI = null;
    protected NodeProxy[] references = null;
    protected int nextReferenceIdx = 0;
    protected XQueryContext context;
    protected final boolean explicitlyCreated;
    protected final long docId;
    private Database db = null;
    protected NamePool namePool;
    boolean replaceAttribute = false;

    public DocumentImpl(XQueryContext context, boolean explicitlyCreated) {
        super(null, 0);
        this.context = context;
        this.explicitlyCreated = explicitlyCreated;
        this.docId = DocumentImpl.createDocId();
        if (context == null) {
            this.namePool = new NamePool();
        } else {
            this.db = context.getDatabase();
            this.namePool = context.getSharedNamePool();
        }
    }

    private Database getDatabase() {
        if (this.db == null) {
            try {
                this.db = BrokerPool.getInstance();
            }
            catch (EXistException e) {
                throw new RuntimeException(e);
            }
        }
        return this.db;
    }

    private static long createDocId() {
        return nextDocId++;
    }

    private void init() {
        this.nodeKind = new short[16];
        this.treeLevel = new short[16];
        this.next = new int[16];
        Arrays.fill(this.next, -1);
        this.nodeName = new QName[16];
        this.nodeId = new NodeId[16];
        this.alpha = new int[16];
        this.alphaLen = new int[16];
        Arrays.fill(this.alphaLen, -1);
        this.attrName = new QName[8];
        this.attrParent = new int[8];
        this.attrValue = new String[8];
        this.attrType = new int[8];
        this.attrNodeId = new NodeId[16];
        this.treeLevel[0] = 0;
        this.nodeKind[0] = 9;
        this.document = this;
    }

    public void reset() {
        this.size = 0;
        this.nextChar = 0;
        this.nextAttr = 0;
        this.nextReferenceIdx = 0;
        this.references = null;
    }

    public int getSize() {
        return this.size;
    }

    public int addNode(short kind, short level, QName qname) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.size == this.nodeKind.length) {
            this.grow();
        }
        this.nodeKind[this.size] = kind;
        this.treeLevel[this.size] = level;
        this.nodeName[this.size] = qname != null ? this.namePool.getSharedName(qname) : null;
        this.alpha[this.size] = -1;
        this.next[this.size] = -1;
        return this.size++;
    }

    public void addChars(int nodeNum, char[] ch, int start, int len) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.characters == null) {
            this.characters = new char[len > 256 ? len : 256];
        } else if (this.nextChar + len >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alpha[nodeNum] = this.nextChar;
        this.alphaLen[nodeNum] = len;
        System.arraycopy(ch, start, this.characters, this.nextChar, len);
        this.nextChar += len;
    }

    public void addChars(int nodeNum, CharSequence s) {
        int len;
        if (this.nodeKind == null) {
            this.init();
        }
        int n = len = s == null ? 0 : s.length();
        if (this.characters == null) {
            this.characters = new char[len > 256 ? len : 256];
        } else if (this.nextChar + len >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alpha[nodeNum] = this.nextChar;
        this.alphaLen[nodeNum] = len;
        for (int i = 0; i < len; ++i) {
            this.characters[this.nextChar++] = s.charAt(i);
        }
    }

    public void appendChars(int nodeNum, char[] ch, int start, int len) {
        if (this.characters == null) {
            this.characters = new char[len > 256 ? len : 256];
        } else if (this.nextChar + len >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alphaLen[nodeNum] = this.alphaLen[nodeNum] + len;
        System.arraycopy(ch, start, this.characters, this.nextChar, len);
        this.nextChar += len;
    }

    public void appendChars(int nodeNum, CharSequence s) {
        int len = s.length();
        if (this.characters == null) {
            this.characters = new char[len > 256 ? len : 256];
        } else if (this.nextChar + len >= this.characters.length) {
            int newLen = this.characters.length * 3 / 2;
            if (newLen < this.nextChar + len) {
                newLen = this.nextChar + len;
            }
            char[] nc = new char[newLen];
            System.arraycopy(this.characters, 0, nc, 0, this.characters.length);
            this.characters = nc;
        }
        this.alphaLen[nodeNum] = this.alphaLen[nodeNum] + len;
        for (int i = 0; i < len; ++i) {
            this.characters[this.nextChar++] = s.charAt(i);
        }
    }

    public void addReferenceNode(int nodeNum, NodeProxy proxy) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.references == null || this.nextReferenceIdx == this.references.length) {
            this.growReferences();
        }
        this.references[this.nextReferenceIdx] = proxy;
        ++this.nextReferenceIdx;
    }

    public boolean hasReferenceNodes() {
        return this.references != null && this.references[0] != null;
    }

    public void replaceReferenceNode(int nodeNum, CharSequence ch) {
        this.nodeKind[nodeNum] = 3;
        this.references[this.alpha[nodeNum]] = null;
        this.addChars(nodeNum, ch);
    }

    public int addAttribute(int nodeNum, QName qname, String value, int type) throws DOMException {
        if (this.nodeKind == null) {
            this.init();
        }
        if (nodeNum > 0 && this.nodeKind[nodeNum] != 1 && this.nodeKind[nodeNum] != 101) {
            throw new DOMException(10, "err:XQTY0024: An attribute node cannot follow a node that is not an attribute node.");
        }
        int prevAttr = this.nextAttr - 1;
        while (nodeNum > 0 && prevAttr > -1 && this.attrParent[prevAttr] == nodeNum) {
            int attrN;
            QName prevQn;
            if (!(prevQn = this.attrName[attrN = prevAttr--]).equals(qname)) continue;
            if (this.replaceAttribute) {
                this.attrValue[attrN] = value;
                this.attrType[attrN] = type;
                return attrN;
            }
            throw new DOMException(10, "err:XQDY0025: element has more than one attribute '" + qname + "'");
        }
        if (this.nextAttr == this.attrName.length) {
            this.growAttributes();
        }
        QName attrQname = new QName(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix(), 1);
        this.attrParent[this.nextAttr] = nodeNum;
        this.attrName[this.nextAttr] = this.namePool.getSharedName(attrQname);
        this.attrValue[this.nextAttr] = value;
        this.attrType[this.nextAttr] = type;
        if (this.alpha[nodeNum] < 0) {
            this.alpha[nodeNum] = this.nextAttr;
        }
        return this.nextAttr++;
    }

    public int addNamespace(int nodeNum, QName qname) {
        if (this.nodeKind == null) {
            this.init();
        }
        if (this.namespaceCode == null || this.nextNamespace == this.namespaceCode.length) {
            this.growNamespaces();
        }
        this.namespaceCode[this.nextNamespace] = this.namePool.getSharedName(qname);
        this.namespaceParent[this.nextNamespace] = nodeNum;
        if (this.alphaLen[nodeNum] < 0) {
            this.alphaLen[nodeNum] = this.nextNamespace;
        }
        return this.nextNamespace++;
    }

    public short getTreeLevel(int nodeNum) {
        return this.treeLevel[nodeNum];
    }

    public int getLastNode() {
        return this.size - 1;
    }

    public short getNodeType(int nodeNum) {
        if (this.nodeKind == null || nodeNum < 0) {
            return -1;
        }
        return this.nodeKind[nodeNum];
    }

    @Override
    public String getStringValue() {
        if (this.document == null) {
            return "";
        }
        return super.getStringValue();
    }

    private void grow() {
        int newSize = this.size * 3 / 2;
        short[] newNodeKind = new short[newSize];
        System.arraycopy(this.nodeKind, 0, newNodeKind, 0, this.size);
        this.nodeKind = newNodeKind;
        short[] newTreeLevel = new short[newSize];
        System.arraycopy(this.treeLevel, 0, newTreeLevel, 0, this.size);
        this.treeLevel = newTreeLevel;
        int[] newNext = new int[newSize];
        Arrays.fill(newNext, -1);
        System.arraycopy(this.next, 0, newNext, 0, this.size);
        this.next = newNext;
        QName[] newNodeName = new QName[newSize];
        System.arraycopy(this.nodeName, 0, newNodeName, 0, this.size);
        this.nodeName = newNodeName;
        NodeId[] newNodeId = new NodeId[newSize];
        System.arraycopy(this.nodeId, 0, newNodeId, 0, this.size);
        this.nodeId = newNodeId;
        int[] newAlpha = new int[newSize];
        System.arraycopy(this.alpha, 0, newAlpha, 0, this.size);
        this.alpha = newAlpha;
        int[] newAlphaLen = new int[newSize];
        Arrays.fill(newAlphaLen, -1);
        System.arraycopy(this.alphaLen, 0, newAlphaLen, 0, this.size);
        this.alphaLen = newAlphaLen;
    }

    private void growAttributes() {
        int size = this.attrName.length;
        int newSize = size * 3 / 2;
        QName[] newAttrName = new QName[newSize];
        System.arraycopy(this.attrName, 0, newAttrName, 0, size);
        this.attrName = newAttrName;
        int[] newAttrParent = new int[newSize];
        System.arraycopy(this.attrParent, 0, newAttrParent, 0, size);
        this.attrParent = newAttrParent;
        String[] newAttrValue = new String[newSize];
        System.arraycopy(this.attrValue, 0, newAttrValue, 0, size);
        this.attrValue = newAttrValue;
        int[] newAttrType = new int[newSize];
        System.arraycopy(this.attrType, 0, newAttrType, 0, size);
        this.attrType = newAttrType;
        NodeId[] newNodeId = new NodeId[newSize];
        System.arraycopy(this.attrNodeId, 0, newNodeId, 0, size);
        this.attrNodeId = newNodeId;
    }

    private void growReferences() {
        if (this.references == null) {
            this.references = new NodeProxy[8];
        } else {
            int size = this.references.length;
            int newSize = size * 3 / 2;
            NodeProxy[] newReferences = new NodeProxy[newSize];
            System.arraycopy(this.references, 0, newReferences, 0, size);
            this.references = newReferences;
        }
    }

    private void growNamespaces() {
        if (this.namespaceCode == null) {
            this.namespaceCode = new QName[5];
            this.namespaceParent = new int[5];
        } else {
            int size = this.namespaceCode.length;
            int newSize = size * 3 / 2;
            QName[] newCodes = new QName[newSize];
            System.arraycopy(this.namespaceCode, 0, newCodes, 0, size);
            this.namespaceCode = newCodes;
            int[] newParents = new int[newSize];
            System.arraycopy(this.namespaceParent, 0, newParents, 0, size);
            this.namespaceParent = newParents;
        }
    }

    public NodeImpl getAttribute(int nodeNum) throws DOMException {
        return new AttrImpl(this, nodeNum);
    }

    public NodeImpl getNamespaceNode(int nodeNum) throws DOMException {
        return new NamespaceNode(this, nodeNum);
    }

    public NodeImpl getNode(int nodeNum) throws DOMException {
        NodeImpl node;
        if (nodeNum == 0) {
            return this;
        }
        if (nodeNum >= this.size) {
            throw new DOMException(3, "node not found");
        }
        switch (this.nodeKind[nodeNum]) {
            case 1: {
                node = new ElementImpl(this, nodeNum);
                break;
            }
            case 3: {
                node = new TextImpl(this, nodeNum);
                break;
            }
            case 8: {
                node = new CommentImpl(this, nodeNum);
                break;
            }
            case 7: {
                node = new ProcessingInstructionImpl(this, nodeNum);
                break;
            }
            case 4: {
                node = new CDATASectionImpl(this, nodeNum);
                break;
            }
            case 100: {
                node = new ReferenceNode(this, nodeNum);
                break;
            }
            default: {
                throw new DOMException(8, "node not found");
            }
        }
        return node;
    }

    public NodeImpl getLastAttr() {
        if (this.nextAttr == 0) {
            return null;
        }
        return new AttrImpl(this, this.nextAttr - 1);
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public DocumentType getDoctype() {
        return null;
    }

    @Override
    public DOMImplementation getImplementation() {
        return new DOMImplementationImpl();
    }

    @Override
    public Element getDocumentElement() {
        if (this.size == 1) {
            return null;
        }
        int nodeNum = 1;
        while (this.nodeKind[nodeNum] != 1) {
            if (this.next[nodeNum] < nodeNum) {
                return null;
            }
            nodeNum = this.next[nodeNum];
        }
        return (Element)((Object)this.getNode(nodeNum));
    }

    @Override
    public Node getFirstChild() {
        if (this.size > 1) {
            return this.getNode(1);
        }
        return null;
    }

    @Override
    public Node getLastChild() {
        return this.getFirstChild();
    }

    public int getAttributesCountFor(int nodeNumber) {
        int count = 0;
        int attr = this.alpha[nodeNumber];
        if (-1 < attr) {
            while (attr < this.nextAttr && this.attrParent[attr++] == nodeNumber) {
                ++count;
            }
        }
        return count;
    }

    public int getNamespacesCountFor(int nodeNumber) {
        int count = 0;
        int ns = this.alphaLen[nodeNumber];
        if (-1 < ns) {
            while (ns < this.nextNamespace && this.namespaceParent[ns++] == nodeNumber) {
                ++count;
            }
        }
        return count;
    }

    public int getChildCountFor(int nr) {
        int count = 0;
        int nextNode = this.getFirstChildFor(nr);
        while (nextNode > nr) {
            ++count;
            nextNode = this.next[nextNode];
        }
        return count;
    }

    public int getFirstChildFor(int nodeNumber) {
        short level = this.treeLevel[nodeNumber];
        int nextNode = nodeNumber + 1;
        if (nextNode < this.size && this.treeLevel[nextNode] > level) {
            return nextNode;
        }
        return -1;
    }

    public int getNextSiblingFor(int nodeNumber) {
        int nextNr = this.next[nodeNumber];
        return nextNr < nodeNumber ? -1 : nextNr;
    }

    public int getParentNodeFor(int nodeNumber) {
        int nextNode = this.next[nodeNumber];
        while (nextNode > nodeNumber) {
            nextNode = this.next[nextNode];
        }
        return nextNode;
    }

    @Override
    public void selectChildren(NodeTest test, Sequence result) throws XPathException {
        if (this.size == 1) {
            return;
        }
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            if (!test.matches(next)) continue;
            result.add(next);
        }
    }

    @Override
    public void selectDescendants(boolean includeSelf, NodeTest test, Sequence result) throws XPathException {
        if (includeSelf && test.matches(this)) {
            result.add(this);
        }
        if (this.size == 1) {
            return;
        }
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            if (test.matches(next)) {
                result.add(next);
            }
            next.selectDescendants(includeSelf, test, result);
        }
    }

    @Override
    public void selectDescendantAttributes(NodeTest test, Sequence result) throws XPathException {
        if (this.size == 1) {
            return;
        }
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            if (test.matches(next)) {
                result.add(next);
            }
            next.selectDescendantAttributes(test, result);
        }
    }

    public NodeImpl selectById(String id) {
        if (this.size == 1) {
            return null;
        }
        ElementImpl root = (ElementImpl)this.getDocumentElement();
        if (this.hasIdAttribute(root.getNodeNumber(), id)) {
            return root;
        }
        short treeLevel = this.treeLevel[root.getNodeNumber()];
        int nextNode = root.getNodeNumber();
        while (++nextNode < this.document.size && this.document.treeLevel[nextNode] > treeLevel) {
            if (this.document.nodeKind[nextNode] != 1 || !this.hasIdAttribute(nextNode, id)) continue;
            return this.getNode(nextNode);
        }
        return null;
    }

    public NodeImpl selectByIdref(String id) {
        if (this.size == 1) {
            return null;
        }
        ElementImpl root = (ElementImpl)this.getDocumentElement();
        AttrImpl attr = this.getIdrefAttribute(root.getNodeNumber(), id);
        if (attr != null) {
            return attr;
        }
        short treeLevel = this.treeLevel[root.getNodeNumber()];
        int nextNode = root.getNodeNumber();
        while (++nextNode < this.document.size && this.document.treeLevel[nextNode] > treeLevel) {
            if (this.document.nodeKind[nextNode] != 1 || (attr = this.getIdrefAttribute(nextNode, id)) == null) continue;
            return attr;
        }
        return null;
    }

    private boolean hasIdAttribute(int nodeNumber, String id) {
        int attr = this.document.alpha[nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == nodeNumber) {
                if (this.document.attrType[attr] == 1 && id.equals(this.document.attrValue[attr])) {
                    return true;
                }
                ++attr;
            }
        }
        return false;
    }

    private AttrImpl getIdrefAttribute(int nodeNumber, String id) {
        int attr = this.document.alpha[nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == nodeNumber) {
                if (this.document.attrType[attr] == 2 && id.equals(this.document.attrValue[attr])) {
                    return new AttrImpl(this, attr);
                }
                ++attr;
            }
        }
        return null;
    }

    @Override
    public boolean matchChildren(NodeTest test) throws XPathException {
        if (this.size == 1) {
            return false;
        }
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            if (!test.matches(next)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchDescendants(boolean includeSelf, NodeTest test) throws XPathException {
        if (includeSelf && test.matches(this)) {
            return true;
        }
        if (this.size == 1) {
            return true;
        }
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            if (test.matches(next)) {
                return true;
            }
            if (!next.matchDescendants(includeSelf, test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchDescendantAttributes(NodeTest test) throws XPathException {
        if (this.size == 1) {
            return false;
        }
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            if (test.matches(next)) {
                return true;
            }
            if (!next.matchDescendantAttributes(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        QName qname;
        try {
            qname = this.getContext() != null ? QName.parse(this.getContext(), tagName) : new QName(tagName);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, e.getMessage());
        }
        if (qname.isValid(false) != QName.Validity.VALID.val) {
            throw new DOMException(5, "name is invalid");
        }
        int nodeNum = this.addNode((short)1, (short)1, qname);
        return new ElementImpl(this, nodeNum);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        QName qname;
        try {
            qname = this.getContext() != null ? QName.parse(this.getContext(), qualifiedName, namespaceURI) : QName.parse(namespaceURI, qualifiedName);
        }
        catch (QName.IllegalQNameException e) {
            int errCode = e.getValidity() == QName.Validity.ILLEGAL_FORMAT.val || (e.getValidity() & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val ? 14 : 5;
            throw new DOMException((short)errCode, "qualified name is invalid");
        }
        byte validity = qname.isValid(false);
        if ((validity & QName.Validity.INVALID_LOCAL_PART.val) == QName.Validity.INVALID_LOCAL_PART.val) {
            throw new DOMException(5, "qualified name is invalid");
        }
        if ((validity & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val) {
            throw new DOMException(14, "qualified name is invalid");
        }
        int nodeNum = this.addNode((short)1, (short)1, qname);
        return new ElementImpl(this, nodeNum);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DocumentFragmentImpl();
    }

    @Override
    public Text createTextNode(String data) {
        return null;
    }

    @Override
    public Comment createComment(String data) {
        return null;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return null;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        QName qname;
        try {
            qname = this.getContext() != null ? QName.parse(this.getContext(), name) : new QName(name);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, e.getMessage());
        }
        if (qname.isValid(false) != QName.Validity.VALID.val) {
            throw new DOMException(5, "name is invalid");
        }
        throw this.unsupported();
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        QName qname;
        try {
            qname = this.getContext() != null ? QName.parse(this.getContext(), qualifiedName, namespaceURI) : QName.parse(namespaceURI, qualifiedName);
        }
        catch (QName.IllegalQNameException e) {
            int errCode = e.getValidity() == QName.Validity.ILLEGAL_FORMAT.val || (e.getValidity() & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val ? 14 : 5;
            throw new DOMException((short)errCode, "qualified name is invalid");
        }
        byte validity = qname.isValid(false);
        if ((validity & QName.Validity.INVALID_LOCAL_PART.val) == QName.Validity.INVALID_LOCAL_PART.val) {
            throw new DOMException(5, "qualified name is invalid");
        }
        if ((validity & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val) {
            throw new DOMException(14, "qualified name is invalid");
        }
        throw this.unsupported();
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        QName qname;
        if (tagname != null && tagname.equals("*")) {
            return this.getElementsByTagName(new QName.WildcardLocalPartQName(""));
        }
        try {
            qname = this.document.getContext() != null ? QName.parse(this.document.context, tagname) : new QName(tagname);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, e.getMessage());
        }
        return this.getElementsByTagName(qname);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        QName qname;
        boolean wildcardLocalPart;
        boolean wildcardNS = namespaceURI != null && namespaceURI.equals("*");
        boolean bl = wildcardLocalPart = localName != null && localName.equals("*");
        if (wildcardNS && wildcardLocalPart) {
            return this.getElementsByTagName(QName.WildcardQName.getInstance());
        }
        if (wildcardNS) {
            return this.getElementsByTagName(new QName.WildcardNamespaceURIQName(localName));
        }
        if (wildcardLocalPart) {
            return this.getElementsByTagName(new QName.WildcardLocalPartQName(namespaceURI));
        }
        if (this.document.getContext() != null) {
            try {
                qname = QName.parse(this.document.context, localName, namespaceURI);
            }
            catch (QName.IllegalQNameException e) {
                throw new DOMException(5, e.getMessage());
            }
        } else {
            qname = new QName(localName, namespaceURI);
        }
        return this.getElementsByTagName(qname);
    }

    private NodeList getElementsByTagName(QName qname) {
        NodeListImpl nl = new NodeListImpl();
        for (int i = 1; i < this.size; ++i) {
            QName qn;
            if (this.nodeKind[i] != 1 || !(qn = this.nodeName[i]).matches(qname)) continue;
            nl.add(this.getNode(i));
        }
        return nl;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return null;
    }

    @Override
    public Element getElementById(String elementId) {
        return null;
    }

    @Override
    public DocumentImpl getOwnerDocument() {
        return null;
    }

    public void copyTo(NodeImpl node, DocumentBuilderReceiver receiver) throws SAXException {
        this.copyTo(node, receiver, false);
    }

    protected void copyTo(NodeImpl node, DocumentBuilderReceiver receiver, boolean expandRefs) throws SAXException {
        NodeImpl top = node;
        while (node != null) {
            this.copyStartNode(node, receiver, expandRefs);
            NodeImpl nextNode = node instanceof ReferenceNode ? null : (NodeImpl)node.getFirstChild();
            while (nextNode == null) {
                this.copyEndNode(node, receiver);
                if (top != null && top.nodeNumber == node.nodeNumber) break;
                nextNode = (NodeImpl)node.getNextSibling();
                if (nextNode != null || (node = (NodeImpl)node.getParentNode()) != null && (top == null || top.nodeNumber != node.nodeNumber)) continue;
                this.copyEndNode(node, receiver);
                break;
            }
            node = nextNode;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void copyStartNode(NodeImpl node, DocumentBuilderReceiver receiver, boolean expandRefs) throws SAXException {
        nr = node.nodeNumber;
        switch (node.getNodeType()) {
            case 1: {
                nodeName = this.document.nodeName[nr];
                receiver.startElement(nodeName, null);
                if (-1 < attr) {
                    for (attr = this.document.alpha[nr]; attr < this.document.nextAttr && this.document.attrParent[attr] == nr; ++attr) {
                        attrQName = this.document.attrName[attr];
                        receiver.attribute(attrQName, this.attrValue[attr]);
                    }
                }
                if (-1 >= (ns = this.document.alphaLen[nr])) break;
                while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr) {
                    nsQName = this.document.namespaceCode[ns];
                    receiver.addNamespaceNode(nsQName);
                    ++ns;
                }
                break;
            }
            case 3: {
                receiver.characters(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 4: {
                receiver.cdataSection(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 2: {
                attrQName = this.document.attrName[nr];
                receiver.attribute(attrQName, this.attrValue[nr]);
                break;
            }
            case 8: {
                receiver.comment(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 7: {
                piQName = this.document.nodeName[nr];
                data = new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                receiver.processingInstruction(piQName.getLocalPart(), data);
                break;
            }
            case 101: {
                receiver.addNamespaceNode(this.document.namespaceCode[nr]);
                break;
            }
            case 100: {
                if (!expandRefs) ** GOTO lbl78
                try {
                    broker = this.getDatabase().getBroker();
                    var9_15 = null;
                    serializer = broker.getSerializer();
                    serializer.reset();
                    serializer.setProperty("sax-document-events", "false");
                    serializer.setReceiver(receiver);
                    serializer.toReceiver(this.document.references[this.document.alpha[nr]], false, false);
                    if (broker == null) break;
                    if (var9_15 == null) ** GOTO lbl58
                    try {
                        broker.close();
                    }
                    catch (Throwable var10_17) {
                        var9_15.addSuppressed(var10_17);
                    }
                    break;
lbl58:
                    // 1 sources

                    broker.close();
                    ** break;
                    catch (Throwable var10_18) {
                        try {
                            var9_15 = var10_18;
                            throw var10_18;
                        }
                        catch (Throwable var11_19) {
                            if (broker != null) {
                                if (var9_15 != null) {
                                    try {
                                        broker.close();
                                    }
                                    catch (Throwable var12_20) {
                                        var9_15.addSuppressed(var12_20);
                                    }
                                } else {
                                    broker.close();
                                }
                            }
                            throw var11_19;
lbl75:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (EXistException e) {
                    throw new SAXException(e);
                }
lbl78:
                // 1 sources

                receiver.addReferenceNode(this.document.references[this.document.alpha[nr]]);
            }
        }
    }

    private void copyEndNode(NodeImpl node, DocumentBuilderReceiver receiver) throws SAXException {
        if (node.getNodeType() == 1) {
            receiver.endElement(node.getQName());
        }
    }

    @Override
    public void expand() throws DOMException {
        if (this.size == 0) {
            return;
        }
        DocumentImpl newDoc = this.expandRefs(null);
        this.copyDocContents(newDoc);
    }

    public DocumentImpl expandRefs(NodeImpl rootNode) throws DOMException {
        try {
            if (this.nextReferenceIdx == 0) {
                this.computeNodeIds();
                return this;
            }
            MemTreeBuilder builder = new MemTreeBuilder(this.context);
            DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
            try {
                NodeImpl node;
                builder.startDocument();
                NodeImpl nodeImpl = node = rootNode == null ? (NodeImpl)this.getFirstChild() : rootNode;
                while (node != null) {
                    this.copyTo(node, receiver, true);
                    node = (NodeImpl)node.getNextSibling();
                }
                receiver.endDocument();
            }
            catch (SAXException e) {
                throw new DOMException(11, e.getMessage());
            }
            DocumentImpl newDoc = builder.getDocument();
            newDoc.computeNodeIds();
            return newDoc;
        }
        catch (EXistException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    public NodeImpl getNodeById(NodeId id) {
        this.expand();
        for (int i = 0; i < this.size; ++i) {
            if (!id.equals(this.nodeId[i])) continue;
            return this.getNode(i);
        }
        return null;
    }

    private void computeNodeIds() throws EXistException {
        if (this.nodeId[0] != null) {
            return;
        }
        NodeIdFactory nodeFactory = this.getDatabase().getNodeFactory();
        this.nodeId[0] = nodeFactory.documentNodeId();
        if (this.size == 1) {
            return;
        }
        NodeId nextId = nodeFactory.createInstance();
        NodeImpl next = (NodeImpl)this.getFirstChild();
        while (next != null) {
            this.computeNodeIds(nextId, next.nodeNumber);
            next = (NodeImpl)next.getNextSibling();
            nextId = nextId.nextSibling();
        }
    }

    private void computeNodeIds(NodeId id, int nodeNum) {
        this.nodeId[nodeNum] = id;
        if (this.nodeKind[nodeNum] == 1) {
            NodeId nextId = id.newChild();
            int attr = this.document.alpha[nodeNum];
            if (-1 < attr) {
                while (attr < this.document.nextAttr && this.document.attrParent[attr] == nodeNum) {
                    this.attrNodeId[attr] = nextId;
                    nextId = nextId.nextSibling();
                    ++attr;
                }
            }
            int nextNode = this.getFirstChildFor(nodeNum);
            while (nextNode > nodeNum) {
                this.computeNodeIds(nextId, nextNode);
                if ((nextNode = this.document.next[nextNode]) <= nodeNum) continue;
                nextId = nextId.nextSibling();
            }
        }
    }

    private void copyDocContents(DocumentImpl newDoc) {
        this.namePool = newDoc.namePool;
        this.nodeKind = newDoc.nodeKind;
        this.treeLevel = newDoc.treeLevel;
        this.next = newDoc.next;
        this.nodeName = newDoc.nodeName;
        this.nodeId = newDoc.nodeId;
        this.alpha = newDoc.alpha;
        this.alphaLen = newDoc.alphaLen;
        this.characters = newDoc.characters;
        this.nextChar = newDoc.nextChar;
        this.attrName = newDoc.attrName;
        this.attrNodeId = newDoc.attrNodeId;
        this.attrParent = newDoc.attrParent;
        this.attrValue = newDoc.attrValue;
        this.nextAttr = newDoc.nextAttr;
        this.namespaceParent = newDoc.namespaceParent;
        this.namespaceCode = newDoc.namespaceCode;
        this.nextNamespace = newDoc.nextNamespace;
        this.size = newDoc.size;
        this.documentRootNode = newDoc.documentRootNode;
        this.references = newDoc.references;
        this.nextReferenceIdx = newDoc.nextReferenceIdx;
    }

    public void streamTo(Serializer serializer, NodeImpl node, Receiver receiver) throws SAXException {
        NodeImpl top = node;
        while (node != null) {
            this.startNode(serializer, node, receiver);
            NodeImpl nextNode = node instanceof ReferenceNode ? null : (NodeImpl)node.getFirstChild();
            while (nextNode == null) {
                this.endNode(node, receiver);
                if (top != null && top.nodeNumber == node.nodeNumber) break;
                nextNode = (NodeImpl)node.getNextSibling();
                if (nextNode != null || (node = (NodeImpl)node.getParentNode()) != null && (top == null || top.nodeNumber != node.nodeNumber)) continue;
                this.endNode(node, receiver);
                break;
            }
            node = nextNode;
        }
    }

    private void startNode(Serializer serializer, NodeImpl node, Receiver receiver) throws SAXException {
        int nr = node.nodeNumber;
        switch (node.getNodeType()) {
            case 1: {
                int ns;
                QName nodeName = this.document.nodeName[nr];
                if (ns > -1) {
                    for (ns = this.document.alphaLen[nr]; ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr; ++ns) {
                        QName nsQName = this.document.namespaceCode[ns];
                        if ("xmlns".equals(nsQName.getLocalPart())) {
                            receiver.startPrefixMapping("", nsQName.getNamespaceURI());
                            continue;
                        }
                        receiver.startPrefixMapping(nsQName.getLocalPart(), nsQName.getNamespaceURI());
                    }
                }
                AttrList attribs = null;
                int attr = this.document.alpha[nr];
                if (attr > -1) {
                    attribs = new AttrList();
                    while (attr < this.document.nextAttr && this.document.attrParent[attr] == nr) {
                        QName attrQName = this.document.attrName[attr];
                        attribs.addAttribute(attrQName, this.attrValue[attr]);
                        ++attr;
                    }
                }
                receiver.startElement(nodeName, attribs);
                break;
            }
            case 3: {
                receiver.characters(new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]));
                break;
            }
            case 2: {
                QName attrQName = this.document.attrName[nr];
                receiver.attribute(attrQName, this.attrValue[nr]);
                break;
            }
            case 8: {
                receiver.comment(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 7: {
                QName qn = this.document.nodeName[nr];
                String data = new String(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                receiver.processingInstruction(qn.getLocalPart(), data);
                break;
            }
            case 4: {
                receiver.cdataSection(this.document.characters, this.document.alpha[nr], this.document.alphaLen[nr]);
                break;
            }
            case 100: {
                serializer.toReceiver(this.document.references[this.document.alpha[nr]], true, false);
            }
        }
    }

    private void endNode(NodeImpl node, Receiver receiver) throws SAXException {
        if (node.getNodeType() == 1) {
            int ns;
            receiver.endElement(node.getQName());
            int nr = node.nodeNumber;
            if (ns > -1) {
                for (ns = this.document.alphaLen[nr]; ns < this.document.nextNamespace && this.document.namespaceParent[ns] == nr; ++ns) {
                    QName nsQName = this.document.namespaceCode[ns];
                    if ("xmlns".equals(nsQName.getLocalPart())) {
                        receiver.endPrefixMapping("");
                        continue;
                    }
                    receiver.endPrefixMapping(nsQName.getLocalPart());
                }
            }
        }
    }

    public org.exist.dom.persistent.DocumentImpl makePersistent() throws XPathException {
        if (this.size <= 1) {
            return null;
        }
        return this.context.storeTemporaryDoc(this);
    }

    public int getChildCount() {
        int top;
        int count = 0;
        int n = top = this.size > 1 ? 1 : -1;
        while (top > 0) {
            ++count;
            top = this.getNextSiblingFor(top);
        }
        return count;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getChildCount() > 0;
    }

    @Override
    public NodeList getChildNodes() {
        NodeListImpl nl = new NodeListImpl(this.getChildCount());
        Element el = this.getDocumentElement();
        if (el != null) {
            nl.add(el);
        }
        return nl;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public String getXmlVersion() {
        return "1.0";
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    public void setContext(XQueryContext context) {
        this.context = context;
    }

    public XQueryContext getContext() {
        return this.context;
    }

    @Override
    public String getBaseURI() {
        String baseURI;
        Element el = this.getDocumentElement();
        if (el != null && (baseURI = this.getDocumentElement().getAttributeNS("http://www.w3.org/XML/1998/namespace", "base")) != null) {
            return baseURI;
        }
        String docURI = this.getDocumentURI();
        if (docURI != null) {
            return docURI;
        }
        if (this.context.isBaseURIDeclared()) {
            try {
                return this.context.getBaseURI().getStringValue();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return XmldbURI.EMPTY_URI.toString();
    }

    @Override
    public int getItemType() {
        return 6;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("in-memory#");
        result.append("document {");
        if (this.size != 1) {
            int nodeNum = 1;
            while (true) {
                result.append(this.getNode(nodeNum).toString());
                if (this.next[nodeNum] < nodeNum) break;
                nodeNum = this.next[nodeNum];
            }
        }
        result.append("} ");
        return result.toString();
    }

    @Override
    public void selectAttributes(NodeTest test, Sequence result) throws XPathException {
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        if (newChild.getNodeType() != 9 && newChild.getOwnerDocument() != this) {
            throw new DOMException(4, "Owning document IDs do not match");
        }
        if (newChild == this) {
            throw new DOMException(3, "Cannot append a document to itself");
        }
        if (newChild.getNodeType() == 9) {
            throw new DOMException(3, "A Document Node may not be appended to a Document Node");
        }
        if (newChild.getNodeType() == 1 && this.getDocumentElement() != null) {
            throw new DOMException(3, "A Document Node may only have a single document element");
        }
        if (newChild.getNodeType() == 10 && this.getDoctype() != null) {
            throw new DOMException(3, "A Document Node may only have a single document type");
        }
        throw this.unsupported();
    }
}

