/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.exist.dom.NamedNodeMapImpl;
import org.exist.dom.NodeListImpl;
import org.exist.dom.QName;
import org.exist.dom.memtree.AttrImpl;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.NamespaceNode;
import org.exist.dom.memtree.NodeImpl;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class ElementImpl
extends NodeImpl
implements Element {
    public ElementImpl(DocumentImpl doc, int nodeNumber) {
        super(doc, nodeNumber);
    }

    @Override
    public String getTagName() {
        return this.getNodeName();
    }

    @Override
    public boolean hasChildNodes() {
        return this.nodeNumber + 1 < this.document.size && this.document.treeLevel[this.nodeNumber + 1] > this.document.treeLevel[this.nodeNumber];
    }

    @Override
    public Node getFirstChild() {
        short level = this.document.treeLevel[this.nodeNumber];
        int nextNode = this.nodeNumber + 1;
        if (nextNode < this.document.size && this.document.treeLevel[nextNode] > level) {
            return this.document.getNode(nextNode);
        }
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        NodeListImpl nl = new NodeListImpl();
        int nextNode = this.document.getFirstChildFor(this.nodeNumber);
        while (nextNode > this.nodeNumber) {
            NodeImpl n = this.document.getNode(nextNode);
            if (n.getNodeType() != 2) {
                nl.add(n);
            }
            nextNode = this.document.next[nextNode];
        }
        return nl;
    }

    private int getChildCount() {
        return this.document.getChildCountFor(this.nodeNumber);
    }

    @Override
    public boolean hasAttributes() {
        return this.document.alpha[this.nodeNumber] > -1 || this.document.alphaLen[this.nodeNumber] > -1;
    }

    @Override
    public String getAttribute(String name) {
        int ns;
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName attrQName = this.document.attrName[attr];
                if (attrQName.getStringValue().equals(name)) {
                    return this.document.attrValue[attr];
                }
                ++attr;
            }
        }
        if (name.startsWith("xmlns:") && -1 < (ns = this.document.alphaLen[this.nodeNumber])) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = this.document.namespaceCode[ns];
                if (nsQName.getStringValue().equals(name)) {
                    return nsQName.getNamespaceURI();
                }
                ++ns;
            }
        }
        return null;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        QName qname;
        try {
            qname = this.document.context != null ? QName.parse(this.document.context, name) : new QName(name);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, e.getMessage());
        }
        if (qname.isValid(false) != QName.Validity.VALID.val) {
            throw new DOMException(5, "name is invalid");
        }
        this.setAttribute(qname, value, qn -> this.getAttributeNode(qn.getLocalPart()));
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        QName qname;
        try {
            qname = this.document.context != null ? QName.parse(this.document.context, qualifiedName, namespaceURI) : QName.parse(namespaceURI, qualifiedName);
        }
        catch (QName.IllegalQNameException e) {
            int errCode = e.getValidity() == QName.Validity.ILLEGAL_FORMAT.val || (e.getValidity() & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val ? 14 : 5;
            throw new DOMException((short)errCode, "qualified name is invalid");
        }
        byte validity = qname.isValid(false);
        if ((validity & QName.Validity.INVALID_LOCAL_PART.val) == QName.Validity.INVALID_LOCAL_PART.val) {
            throw new DOMException(5, "qualified name is invalid");
        }
        if ((validity & QName.Validity.INVALID_NAMESPACE.val) == QName.Validity.INVALID_NAMESPACE.val) {
            throw new DOMException(14, "qualified name is invalid");
        }
        this.setAttribute(qname, value, qn -> this.getAttributeNodeNS(qn.getNamespaceURI(), qn.getLocalPart()));
    }

    private void setAttribute(QName name, String value, Function<QName, Attr> getFn) {
        Attr existingAttr = getFn.apply(name);
        if (existingAttr != null) {
            existingAttr.setValue(value);
        } else {
            int lastNode = this.document.getLastNode();
            this.document.addAttribute(lastNode, name, value, 0);
        }
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
    }

    @Override
    public NamedNodeMap getAttributes() {
        int ns;
        NamedNodeMapImpl map = new NamedNodeMapImpl(this.document, true);
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                map.setNamedItem(new AttrImpl(this.document, attr));
                ++attr;
            }
        }
        if ((ns = this.document.alphaLen[this.nodeNumber]) < 0) {
            return map;
        }
        while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
            NamespaceNode node = new NamespaceNode(this.document, ns);
            map.setNamedItem(node);
            ++ns;
        }
        return map;
    }

    @Override
    public Attr getAttributeNode(String name) {
        int ns;
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName attrQName = this.document.attrName[attr];
                if (attrQName.getStringValue().equals(name)) {
                    return new AttrImpl(this.document, attr);
                }
                ++attr;
            }
        }
        if (name.startsWith("xmlns:") && -1 < (ns = this.document.alphaLen[this.nodeNumber])) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = this.document.namespaceCode[ns];
                if (nsQName.getStringValue().equals(name)) {
                    return new NamespaceNode(this.document, ns);
                }
                ++ns;
            }
        }
        return null;
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr, qname -> this.getAttributeNode(qname.getLocalPart()));
    }

    private Attr setAttributeNode(Attr newAttr, Function<QName, Attr> getFn) {
        QName attrName = new QName(newAttr.getLocalName(), newAttr.getNamespaceURI(), newAttr.getPrefix(), 1);
        Attr existingAttr = getFn.apply(attrName);
        if (existingAttr != null) {
            if (existingAttr.equals(newAttr)) {
                return newAttr;
            }
            existingAttr.setValue(newAttr.getValue());
            return existingAttr;
        }
        int lastNode = this.document.getLastNode();
        int attrNodeNum = this.document.addAttribute(lastNode, attrName, newAttr.getValue(), 0);
        return new AttrImpl(this.document, attrNodeNum);
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return null;
    }

    @Override
    public void selectAttributes(NodeTest test, Sequence result) throws XPathException {
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                AttrImpl attrib = new AttrImpl(this.document, attr);
                if (test.matches(attrib)) {
                    result.add(attrib);
                }
                ++attr;
            }
        }
    }

    @Override
    public void selectDescendantAttributes(NodeTest test, Sequence result) throws XPathException {
        short treeLevel = this.document.treeLevel[this.nodeNumber];
        int nextNode = this.nodeNumber;
        NodeImpl n = this.document.getNode(nextNode);
        n.selectAttributes(test, result);
        while (++nextNode < this.document.size && this.document.treeLevel[nextNode] > treeLevel) {
            n = this.document.getNode(nextNode);
            if (n.getNodeType() != 1) continue;
            n.selectAttributes(test, result);
        }
    }

    @Override
    public void selectChildren(NodeTest test, Sequence result) throws XPathException {
        int nextNode = this.document.getFirstChildFor(this.nodeNumber);
        while (nextNode > this.nodeNumber) {
            NodeImpl n = this.document.getNode(nextNode);
            if (test.matches(n)) {
                result.add(n);
            }
            nextNode = this.document.next[nextNode];
        }
    }

    public NodeImpl getFirstChild(NodeTest test) throws XPathException {
        ValueSequence seq = new ValueSequence();
        this.selectChildren(test, seq);
        return seq.isEmpty() ? null : seq.get(0);
    }

    @Override
    public void selectDescendants(boolean includeSelf, NodeTest test, Sequence result) throws XPathException {
        NodeImpl n;
        short treeLevel = this.document.treeLevel[this.nodeNumber];
        int nextNode = this.nodeNumber;
        if (includeSelf && test.matches(n = this.document.getNode(nextNode))) {
            result.add(n);
        }
        while (++nextNode < this.document.size && this.document.treeLevel[nextNode] > treeLevel) {
            n = this.document.getNode(nextNode);
            if (!test.matches(n)) continue;
            result.add(n);
        }
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        QName qname;
        if (name != null && name.equals("*")) {
            return this.getElementsByTagName(new QName.WildcardLocalPartQName(""));
        }
        try {
            qname = this.document.getContext() != null ? QName.parse(this.document.context, name) : new QName(name);
        }
        catch (QName.IllegalQNameException e) {
            throw new DOMException(5, e.getMessage());
        }
        return this.getElementsByTagName(qname);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        QName qname;
        boolean wildcardLocalPart;
        boolean wildcardNS = namespaceURI != null && namespaceURI.equals("*");
        boolean bl = wildcardLocalPart = localName != null && localName.equals("*");
        if (wildcardNS && wildcardLocalPart) {
            return this.getElementsByTagName(QName.WildcardQName.getInstance());
        }
        if (wildcardNS) {
            return this.getElementsByTagName(new QName.WildcardNamespaceURIQName(localName));
        }
        if (wildcardLocalPart) {
            return this.getElementsByTagName(new QName.WildcardLocalPartQName(namespaceURI));
        }
        if (this.document.getContext() != null) {
            try {
                qname = QName.parse(this.document.context, localName, namespaceURI);
            }
            catch (QName.IllegalQNameException e) {
                throw new DOMException(5, e.getMessage());
            }
        } else {
            qname = new QName(localName, namespaceURI);
        }
        return this.getElementsByTagName(qname);
    }

    private NodeList getElementsByTagName(QName qname) {
        NodeListImpl nl = new NodeListImpl();
        int nextNode = this.nodeNumber;
        short treeLevel = this.document.treeLevel[this.nodeNumber];
        while (++nextNode < this.document.size && this.document.treeLevel[nextNode] > treeLevel) {
            QName qn;
            if (this.document.nodeKind[nextNode] != 1 || !qname.matches(qn = this.document.nodeName[nextNode])) continue;
            nl.add(this.document.getNode(nextNode));
        }
        return nl;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        int ns;
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName name = this.document.attrName[attr];
                if (name.getLocalPart().equals(localName) && name.getNamespaceURI().equals(namespaceURI)) {
                    return this.document.attrValue[attr];
                }
                ++attr;
            }
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI) && -1 < (ns = this.document.alphaLen[this.nodeNumber])) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = this.document.namespaceCode[ns];
                if (nsQName.getLocalPart().equals(localName)) {
                    return nsQName.getNamespaceURI();
                }
                ++ns;
            }
        }
        return null;
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        int ns;
        int attr = this.document.alpha[this.nodeNumber];
        if (-1 < attr) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName name = this.document.attrName[attr];
                if (name.getLocalPart().equals(localName) && name.getNamespaceURI().equals(namespaceURI)) {
                    return new AttrImpl(this.document, attr);
                }
                ++attr;
            }
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI) && -1 < (ns = this.document.alphaLen[this.nodeNumber])) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = this.document.namespaceCode[ns];
                if (nsQName.getLocalPart().equals(localName)) {
                    return new NamespaceNode(this.document, ns);
                }
                ++ns;
            }
        }
        return null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr, qname -> this.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart()));
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return this.getAttributeNS(namespaceURI, localName) != null;
    }

    public Set<String> getPrefixes() {
        HashSet<String> set = new HashSet<String>();
        int ns = this.document.alphaLen[this.nodeNumber];
        if (-1 < ns) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = this.document.namespaceCode[ns];
                set.add(nsQName.getStringValue());
                ++ns;
            }
        }
        return set;
    }

    public boolean declaresNamespacePrefixes() {
        return this.document.getNamespacesCountFor(this.nodeNumber) > 0;
    }

    public Map<String, String> getNamespaceMap() {
        return this.getNamespaceMap(new HashMap<String, String>());
    }

    public Map<String, String> getNamespaceMap(Map<String, String> map) {
        int attr;
        int ns = this.document.alphaLen[this.nodeNumber];
        if (-1 < ns) {
            while (ns < this.document.nextNamespace && this.document.namespaceParent[ns] == this.nodeNumber) {
                QName nsQName = this.document.namespaceCode[ns];
                map.put(nsQName.getLocalPart(), nsQName.getNamespaceURI());
                ++ns;
            }
        }
        if (-1 < (attr = this.document.alpha[this.nodeNumber])) {
            while (attr < this.document.nextAttr && this.document.attrParent[attr] == this.nodeNumber) {
                QName qname = this.document.attrName[attr];
                if (qname.getPrefix() != null && !qname.getPrefix().isEmpty()) {
                    map.put(qname.getPrefix(), qname.getNamespaceURI());
                }
                ++attr;
            }
        }
        return map;
    }

    @Override
    public int getItemType() {
        return 1;
    }

    @Override
    public String getBaseURI() {
        XmldbURI baseURI = this.calculateBaseURI();
        if (baseURI != null) {
            return baseURI.toString();
        }
        return "";
    }

    private XmldbURI calculateBaseURI() {
        XmldbURI baseURI = null;
        String nodeBaseURI = this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        if (nodeBaseURI != null && (baseURI = XmldbURI.create(nodeBaseURI, false)).isAbsolute()) {
            return baseURI;
        }
        int parent = -1;
        int test = this.document.getParentNodeFor(this.nodeNumber);
        if (this.document.nodeKind[test] != 9) {
            parent = test;
        }
        if (parent != -1) {
            if (nodeBaseURI == null) {
                baseURI = ((ElementImpl)this.document.getNode(parent)).calculateBaseURI();
            } else {
                XmldbURI parentsBaseURI = ((ElementImpl)this.document.getNode(parent)).calculateBaseURI();
                baseURI = nodeBaseURI.isEmpty() ? parentsBaseURI : parentsBaseURI.append(baseURI);
            }
        } else {
            if (nodeBaseURI == null) {
                return XmldbURI.create(this.getOwnerDocument().getBaseURI(), false);
            }
            if (this.nodeNumber != 1) {
                String docBaseURI = this.getOwnerDocument().getBaseURI();
                if (docBaseURI.endsWith("/")) {
                    baseURI = XmldbURI.create(this.getOwnerDocument().getBaseURI(), false);
                    baseURI.append(baseURI);
                } else {
                    baseURI = XmldbURI.create(this.getOwnerDocument().getBaseURI(), false);
                    baseURI = baseURI.removeLastSegment();
                    baseURI.append(baseURI);
                }
            }
        }
        return baseURI;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        int nodeNr = this.document.addNode((short)3, (short)(this.document.getTreeLevel(this.nodeNumber) + 1), null);
        this.document.addChars(nodeNr, textContent.toCharArray(), 0, textContent.length());
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("in-memory#");
        result.append("element {");
        result.append(this.getQName().getStringValue());
        result.append("} {");
        NamedNodeMap theAttrs = this.getAttributes();
        if (theAttrs != null) {
            for (i = 0; i < theAttrs.getLength(); ++i) {
                if (i > 0) {
                    result.append(" ");
                }
                Node natt = theAttrs.item(i);
                result.append(natt.toString());
            }
        }
        for (i = 0; i < this.getChildCount(); ++i) {
            if (i > 0) {
                result.append(" ");
            }
            Node child = this.getChildNodes().item(i);
            result.append(child.toString());
        }
        result.append("} ");
        return result.toString();
    }

    @Override
    public String getTextContent() throws DOMException {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChildNodes().item(i);
            if (!(child instanceof Text)) continue;
            if (i > 0) {
                result.append(" ");
            }
            result.append(((Text)child).getData());
        }
        return result.toString();
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        short treeLevel;
        short newChildTreeLevel;
        if (newChild.getNodeType() != 9 && newChild.getOwnerDocument() != this.document) {
            throw new DOMException(4, "Owning document IDs do not match");
        }
        if (newChild == this) {
            throw new DOMException(3, "Cannot append an element to itself");
        }
        if (newChild.getNodeType() == 9) {
            throw new DOMException(3, "A Document Node may not be appended to an element");
        }
        if (newChild.getNodeType() == 10) {
            throw new DOMException(3, "A Document Type Node may not be appended to an element");
        }
        if (newChild instanceof NodeImpl && (newChildTreeLevel = this.document.treeLevel[((NodeImpl)newChild).nodeNumber]) < (treeLevel = this.document.treeLevel[this.nodeNumber])) {
            throw new DOMException(3, "The node to append is one of this node's ancestors");
        }
        throw this.unsupported();
    }
}

