/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.memtree;

import java.util.HashMap;
import java.util.Map;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.xquery.XQueryContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXAdapter
implements ContentHandler,
LexicalHandler {
    private MemTreeBuilder builder;
    private Map<String, String> namespaces = null;
    private boolean replaceAttributeFlag;

    public SAXAdapter() {
        this.setBuilder(new MemTreeBuilder());
    }

    public SAXAdapter(XQueryContext context) {
        this.setBuilder(new MemTreeBuilder(context));
    }

    protected final void setBuilder(MemTreeBuilder builder) {
        this.builder = builder;
    }

    public DocumentImpl getDocument() {
        return this.builder.getDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.builder.endDocument();
    }

    @Override
    public void startDocument() throws SAXException {
        this.builder.startDocument();
        if (this.replaceAttributeFlag) {
            this.builder.setReplaceAttributeFlag(this.replaceAttributeFlag);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.builder.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.builder.characters(ch, start, length);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.builder.processingInstruction(target, data);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
        }
        this.namespaces.put(prefix, uri);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.builder.endElement();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.builder.startElement(namespaceURI, localName, qName, atts);
        if (this.namespaces != null) {
            for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
                this.builder.namespaceNode(entry.getKey(), entry.getValue());
            }
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!atts.getQName(i).startsWith("xmlns")) continue;
            String prefix = null;
            String uri = atts.getValue(i);
            if (this.namespaces != null && this.namespaces.containsKey(prefix)) continue;
            this.builder.namespaceNode(prefix, uri);
        }
        this.namespaces = null;
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.builder.comment(ch, start, length);
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void setReplaceAttributeFlag(boolean replaceAttributeFlag) {
        this.replaceAttributeFlag = replaceAttributeFlag;
    }
}

