/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import org.exist.dom.persistent.AbstractNodeSet;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.VirtualNodeSet;
import org.exist.xquery.value.Item;
import org.w3c.dom.Node;

public abstract class AbstractArrayNodeSet
extends AbstractNodeSet
implements DocumentSet {
    protected static final int INITIAL_SIZE = 64;
    protected int size = 0;
    protected boolean isSorted = false;
    protected boolean hasOne = false;
    protected int state = 0;
    private NodeProxy lastAdded = null;
    protected int itemType = 12;

    public abstract void reset();

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean hasOne() {
        return this.hasOne;
    }

    @Override
    public void add(NodeProxy proxy) {
        this.add(proxy, -1);
    }

    @Override
    public void add(NodeProxy proxy, int sizeHint) {
        if (this.size > 0) {
            if (this.hasOne) {
                this.hasOne = this.isSorted ? this.get(proxy) != null : this.lastAdded == null || this.lastAdded.compareTo(proxy) == 0;
            }
        } else {
            this.hasOne = true;
        }
        this.addInternal(proxy, sizeHint);
        this.isSorted = false;
        this.setHasChanged();
        this.checkItemType(proxy.getType());
        this.lastAdded = proxy;
    }

    protected abstract void addInternal(NodeProxy var1, int var2);

    @Override
    public void addAll(NodeSet other) {
        if (other.isEmpty()) {
            return;
        }
        if (other.hasOne()) {
            this.add((NodeProxy)other.itemAt(0));
        } else {
            for (NodeProxy node : other) {
                this.add(node);
            }
        }
    }

    @Override
    public int getItemType() {
        return this.itemType;
    }

    private void checkItemType(int type) {
        if (this.itemType == -1 || this.itemType == type) {
            return;
        }
        this.itemType = this.itemType == 12 ? type : -1;
    }

    private void setHasChanged() {
        this.state = this.state == Integer.MAX_VALUE ? 0 : this.state + 1;
    }

    @Override
    public int getLength() {
        if (!this.isSorted()) {
            this.sort();
        }
        return this.size;
    }

    @Override
    public int getItemCount() {
        return this.getLength();
    }

    @Override
    public Node item(int pos) {
        this.sortInDocumentOrder();
        NodeProxy p = this.get(pos);
        return p == null ? null : p.getNode();
    }

    @Override
    public Item itemAt(int pos) {
        this.sortInDocumentOrder();
        return this.get(pos);
    }

    @Override
    public NodeSet selectParentChild(NodeSet al, int mode, int contextId) {
        this.sort();
        if (al instanceof VirtualNodeSet) {
            return super.selectParentChild(al, mode, contextId);
        }
        return this.getDescendantsInSet(al, true, false, mode, contextId, true);
    }

    @Override
    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId, boolean copyMatches) {
        this.sort();
        if (al instanceof VirtualNodeSet) {
            return super.selectAncestorDescendant(al, mode, includeSelf, contextId, copyMatches);
        }
        return this.getDescendantsInSet(al, false, includeSelf, mode, contextId, copyMatches);
    }

    @Override
    public NodeSet selectAncestors(NodeSet al, boolean includeSelf, int contextId) {
        this.sort();
        return super.selectAncestors(al, includeSelf, contextId);
    }

    protected abstract NodeSet getDescendantsInSet(NodeSet var1, boolean var2, boolean var3, int var4, int var5, boolean var6);

    @Override
    public DocumentSet getDocumentSet() {
        return this;
    }

    protected boolean isSorted() {
        return this.isSorted;
    }

    public void mergeDuplicates() {
        this.sort(true);
    }

    public void sortInDocumentOrder() {
        this.sort(false);
    }

    public void sort() {
        this.sort(false);
    }

    public abstract void sort(boolean var1);

    @Override
    public boolean hasChanged(int previousState) {
        return this.state != previousState;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public String toString() {
        return "ArrayNodeSet#" + super.toString();
    }
}

