/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import org.exist.dom.persistent.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.btree.Value;
import org.exist.util.UTF8;
import org.exist.util.XMLString;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class AbstractCharacterData
extends StoredNode
implements CharacterData {
    protected XMLString cdata = null;

    public AbstractCharacterData(short nodeType) {
        super(nodeType);
    }

    public AbstractCharacterData(short nodeType, NodeId nodeId) {
        super(nodeType, nodeId);
    }

    public AbstractCharacterData(short nodeType, NodeId nodeId, String data) {
        super(nodeType, nodeId);
        this.cdata = new XMLString(data.toCharArray());
    }

    public AbstractCharacterData(short nodeType, String data) {
        super(nodeType);
        this.cdata = new XMLString(data.toCharArray());
    }

    public AbstractCharacterData(short nodeType, char[] data, int start, int howmany) {
        super(nodeType);
        this.cdata = new XMLString(data, start, howmany);
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public final Node getFirstChild() {
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.cdata.reset();
    }

    @Override
    public void appendData(String arg) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(arg.toCharArray());
        } else {
            this.cdata.append(arg);
        }
    }

    @Override
    public void deleteData(int offset, int count) throws DOMException {
        if (offset < 0 || count < 0) {
            throw new DOMException(1, "offset is out of bounds");
        }
        if (this.cdata != null) {
            if (offset > this.cdata.length()) {
                throw new DOMException(1, "offset is out of bounds");
            }
            if (offset + count > this.cdata.length()) {
                this.cdata.delete(offset, this.cdata.length() - offset);
            } else {
                this.cdata.delete(offset, count);
            }
        }
    }

    @Override
    public String getData() throws DOMException {
        if (this.cdata == null) {
            return null;
        }
        return this.cdata.toString();
    }

    public XMLString getXMLString() {
        return this.cdata;
    }

    @Override
    public int getLength() {
        return this.cdata.length();
    }

    @Override
    public String getNodeValue() {
        return this.cdata.toString();
    }

    @Override
    public void setNodeValue(String value) throws DOMException {
        this.setData(value);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getNodeValue();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    @Override
    public void insertData(int offset, String arg) throws DOMException {
        if (offset < 0) {
            throw new DOMException(1, "offset is out of bounds");
        }
        if (this.cdata == null) {
            this.cdata = new XMLString(arg.toCharArray());
        } else {
            if (offset > this.cdata.length()) {
                throw new DOMException(1, "offset is out of bounds");
            }
            this.cdata.insert(offset, arg);
        }
    }

    @Override
    public void replaceData(int offset, int count, String arg) throws DOMException {
        if (offset < 0 || count < 0) {
            throw new DOMException(1, "offset is out of bounds");
        }
        if (this.cdata == null) {
            throw new DOMException(2, "string index out of bounds");
        }
        if (offset > this.cdata.length()) {
            throw new DOMException(1, "offset is out of bounds");
        }
        if (offset + count > this.cdata.length()) {
            count = this.cdata.length() - offset;
        }
        this.cdata.replace(offset, count, arg);
    }

    @Override
    public void setData(String data) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(data.toCharArray());
        } else {
            this.cdata.setData(data.toCharArray(), 0, data.length());
        }
    }

    public void setData(XMLString data) throws DOMException {
        this.cdata = data;
    }

    public void setData(char[] data, int start, int howmany) throws DOMException {
        if (this.cdata == null) {
            this.cdata = new XMLString(data, start, howmany);
        } else {
            this.cdata.setData(data, start, howmany);
        }
    }

    @Override
    public String substringData(int offset, int count) throws DOMException {
        if (offset < 0 || count < 0) {
            throw new DOMException(1, "offset is out of bounds");
        }
        if (this.cdata == null) {
            throw new DOMException(2, "string index out of bounds");
        }
        if (offset > this.cdata.length()) {
            throw new DOMException(1, "offset is out of bounds");
        }
        if (offset + count > this.cdata.length()) {
            count = this.cdata.length() - offset;
        }
        return this.cdata.substring(offset, count);
    }

    @Override
    public String toString() {
        if (this.cdata == null) {
            return "";
        }
        return this.cdata.toString();
    }

    @Override
    public void release() {
        this.cdata.release();
        super.release();
    }

    public static XMLString readData(NodeId nodeId, Value value, XMLString string) {
        int nodeIdLen = nodeId.size();
        UTF8.decode(value.data(), value.start() + 3 + nodeIdLen, value.getLength() - 3 - nodeIdLen, string);
        return string;
    }

    public static int getStringLength(NodeId nodeId, Value value) {
        int nodeIdLen = nodeId.size();
        return value.getLength() - 3 - nodeIdLen;
    }
}

