/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.persistent.AVLTreeNodeSet;
import org.exist.dom.persistent.ContextItem;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtArrayNodeSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.NodeSetHelper;
import org.exist.dom.persistent.NodeSetIterator;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public abstract class AbstractNodeSet
extends AbstractSequence
implements NodeSet {
    protected static final Logger LOG = LogManager.getLogger(AbstractNodeSet.class);
    protected int indexType = 12;
    private boolean isCached = false;
    private boolean processInReverseOrder = false;
    private boolean trackMatches = true;

    protected AbstractNodeSet() {
        this.isEmpty = true;
    }

    @Override
    public abstract NodeSetIterator iterator();

    @Override
    public int getItemType() {
        return -1;
    }

    @Override
    public void add(Item item) throws XPathException {
        if (!Type.subTypeOf(item.getType(), -1)) {
            throw new XPathException("item has wrong type");
        }
        this.add((NodeProxy)item);
    }

    @Override
    public void add(NodeProxy proxy, int sizeHint) {
        this.add(proxy);
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
        if (!other.isEmpty() && !Type.subTypeOf(other.getItemType(), -1)) {
            throw new XPathException("sequence argument is not a node sequence");
        }
        if (Type.subTypeOf(other.getItemType(), -1)) {
            this.addAll((NodeSet)other);
        }
        SequenceIterator i = other.iterate();
        while (i.hasNext()) {
            this.add(i.nextItem());
        }
    }

    @Override
    public NodeSet copy() {
        NewArrayNodeSet set = new NewArrayNodeSet();
        set.addAll(this);
        return set;
    }

    @Override
    public void setIsCached(boolean cached) {
        this.isCached = cached;
    }

    @Override
    public boolean isCached() {
        return this.isCached;
    }

    @Override
    public void removeDuplicates() {
    }

    @Override
    public DocumentSet getDocumentSet() {
        DefaultDocumentSet ds = new DefaultDocumentSet();
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            ds.add(((NodeProxy)i.next()).getOwnerDocument());
        }
        return ds;
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return new CollectionIterator();
    }

    @Override
    public NodeSet selectParentChild(NodeSet al, int mode) {
        return this.selectParentChild(al, mode, -1);
    }

    @Override
    public NodeSet selectParentChild(NodeSet al, int mode, int contextId) {
        return NodeSetHelper.selectParentChild(this, al, mode, contextId);
    }

    @Override
    public boolean matchParentChild(NodeSet al, int mode, int contextId) {
        return NodeSetHelper.matchParentChild(this, al, mode, contextId);
    }

    @Override
    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId, boolean copyMatches) {
        return NodeSetHelper.selectAncestorDescendant(this, al, mode, includeSelf, contextId);
    }

    @Override
    public boolean matchAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId, boolean copyMatches) {
        return NodeSetHelper.matchAncestorDescendant(this, al, mode, includeSelf, contextId);
    }

    @Override
    public NodeSet selectAncestors(NodeSet descendants, boolean includeSelf, int contextId) {
        return NodeSetHelper.selectAncestors(this, descendants, includeSelf, contextId);
    }

    public boolean matchAncestors(NodeSet descendants, boolean includeSelf, int contextId) {
        return NodeSetHelper.matchAncestors(this, descendants, includeSelf, contextId);
    }

    @Override
    public NodeSet selectFollowing(NodeSet fl, int contextId) throws XPathException {
        return NodeSetHelper.selectFollowing(fl, this);
    }

    @Override
    public NodeSet selectFollowing(NodeSet following, int position, int contextId) throws XPathException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeSet selectPreceding(NodeSet pl, int contextId) throws XPathException {
        return NodeSetHelper.selectPreceding(pl, this);
    }

    @Override
    public NodeSet selectPreceding(NodeSet preceding, int nth, int contextId) throws XPathException, UnsupportedOperationException {
        throw new UnsupportedOperationException("selectPreceding is not implemented on AbstractNodeSet");
    }

    @Override
    public NodeSet selectPrecedingSiblings(NodeSet siblings, int contextId) {
        return NodeSetHelper.selectPrecedingSiblings(this, siblings, contextId);
    }

    @Override
    public NodeSet selectFollowingSiblings(NodeSet siblings, int contextId) {
        return NodeSetHelper.selectFollowingSiblings(this, siblings, contextId);
    }

    @Override
    public NodeSet directSelectAttribute(DBBroker broker, NodeTest qname, int contextId) {
        return NodeSetHelper.directSelectAttributes(broker, this, qname, contextId);
    }

    @Override
    public boolean directMatchAttribute(DBBroker broker, NodeTest qname, int contextId) {
        return NodeSetHelper.directMatchAttributes(broker, this, qname, contextId);
    }

    @Override
    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
        NodeProxy temp = this.get(doc, nodeId);
        if (includeSelf && temp != null) {
            return temp;
        }
        for (nodeId = nodeId.getParentId(); nodeId != null; nodeId = nodeId.getParentId()) {
            temp = this.get(doc, nodeId);
            if (temp != null) {
                return temp;
            }
            if (!directParent) continue;
            return null;
        }
        return null;
    }

    @Override
    public NodeProxy parentWithChild(NodeProxy proxy, boolean directParent, boolean includeSelf, int level) {
        return this.parentWithChild(proxy.getOwnerDocument(), proxy.getNodeId(), directParent, includeSelf);
    }

    @Override
    public NodeSet getParents(int contextId) {
        NewArrayNodeSet parents = new NewArrayNodeSet();
        NodeProxy parent = null;
        for (NodeProxy current : this) {
            NodeId parentID = current.getNodeId().getParentId();
            if (parentID == null || parentID.getTreeLevel() == 1 && current.getOwnerDocument().getCollection().isTempCollection()) continue;
            if (parent == null || parent.getOwnerDocument().getDocId() != current.getOwnerDocument().getDocId() || !parent.getNodeId().equals(parentID)) {
                parent = parentID != NodeId.DOCUMENT_NODE ? new NodeProxy(current.getOwnerDocument(), parentID, 1, -1L) : new NodeProxy(current.getOwnerDocument(), parentID, 9, -1L);
            }
            if (-1 != contextId) {
                parent.addContextNode(contextId, current);
            } else {
                parent.copyContext(current);
            }
            parent.addMatches(current);
            parents.add(parent);
        }
        return parents;
    }

    @Override
    public NodeSet getAncestors(int contextId, boolean includeSelf) {
        ExtArrayNodeSet ancestors = new ExtArrayNodeSet();
        for (NodeProxy current : this) {
            if (includeSelf) {
                if (-1 != contextId) {
                    current.addContextNode(contextId, current);
                }
                ancestors.add(current);
            }
            for (NodeId parentID = current.getNodeId().getParentId(); parentID != null; parentID = parentID.getParentId()) {
                if (parentID == NodeId.DOCUMENT_NODE || parentID.getTreeLevel() == 1 && current.getOwnerDocument().getCollection().isTempCollection()) continue;
                NodeProxy parent = new NodeProxy(current.getOwnerDocument(), parentID, 1);
                if (-1 != contextId) {
                    parent.addContextNode(contextId, current);
                } else {
                    parent.copyContext(current);
                }
                ancestors.add(parent);
            }
        }
        ancestors.mergeDuplicates();
        return ancestors;
    }

    @Override
    public int getSizeHint(DocumentImpl doc) {
        return -1;
    }

    @Override
    public NodeSet intersection(NodeSet other) {
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        for (NodeProxy l : this) {
            NodeProxy p = other.get(l);
            if (p == null) continue;
            l.addMatches(p);
            r.add(l);
        }
        return r;
    }

    @Override
    public NodeSet deepIntersection(NodeSet other) {
        NodeProxy p;
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        for (NodeProxy l : this) {
            p = other.parentWithChild(l, false, true, -1);
            if (p == null) continue;
            if (p.getNodeId().equals(l.getNodeId())) {
                p.addMatches(l);
            }
            r.add(p);
        }
        for (NodeProxy l : other) {
            NodeProxy q = this.parentWithChild(l, false, true, -1);
            if (q == null) continue;
            p = r.get(q);
            if (p != null) {
                p.addMatches(l);
                continue;
            }
            r.add(l);
        }
        return r;
    }

    @Override
    public NodeSet except(NodeSet other) {
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        for (NodeProxy l : this) {
            if (other.contains(l)) continue;
            r.add(l);
        }
        return r;
    }

    @Override
    public NodeSet filterDocuments(NodeSet otherSet) {
        DocumentSet docs = otherSet.getDocumentSet();
        NewArrayNodeSet newSet = new NewArrayNodeSet();
        for (NodeProxy p : this) {
            if (!docs.contains(p.getOwnerDocument().getDocId())) continue;
            newSet.add(p);
        }
        return newSet;
    }

    @Override
    public void setProcessInReverseOrder(boolean inReverseOrder) {
        this.processInReverseOrder = inReverseOrder;
    }

    @Override
    public boolean getProcessInReverseOrder() {
        return this.processInReverseOrder;
    }

    @Override
    public NodeSet union(NodeSet other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        NewArrayNodeSet result = new NewArrayNodeSet();
        result.addAll(other);
        for (NodeProxy p : this) {
            NodeProxy c = other.get(p);
            if (c != null) {
                c.addMatches(p);
                continue;
            }
            result.add(p);
        }
        return result;
    }

    @Override
    public NodeSet getContextNodes(int contextId) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        DocumentImpl lastDoc = null;
        for (NodeProxy current : this) {
            for (ContextItem contextNode = current.getContext(); contextNode != null; contextNode = contextNode.getNextDirect()) {
                if (contextNode.getContextId() != contextId) continue;
                NodeProxy context = contextNode.getNode();
                context.addMatches(current);
                if (-1 != contextId) {
                    context.addContextNode(contextId, context);
                }
                if (lastDoc != null && lastDoc.getDocId() != context.getOwnerDocument().getDocId()) {
                    lastDoc = context.getOwnerDocument();
                    result.add(context, this.getSizeHint(lastDoc));
                    continue;
                }
                result.add(context);
            }
        }
        return result;
    }

    @Override
    public NodeSet toNodeSet() throws XPathException {
        return this;
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        return null;
    }

    @Override
    public int getState() {
        return 1;
    }

    @Override
    public boolean hasChanged(int previousState) {
        return false;
    }

    @Override
    public void setTrackMatches(boolean track) {
        this.trackMatches = track;
    }

    @Override
    public boolean getTrackMatches() {
        return this.trackMatches;
    }

    @Override
    public int getIndexType() {
        if (this.indexType == 12) {
            for (NodeProxy node : this) {
                if (node.getOwnerDocument().getCollection().isTempCollection()) {
                    this.indexType = 11;
                    break;
                }
                int nodeIndexType = node.getIndexType();
                if (this.indexType == 12) {
                    this.indexType = nodeIndexType;
                    continue;
                }
                if (this.indexType == nodeIndexType) continue;
                this.indexType = 11;
            }
        }
        return this.indexType;
    }

    @Override
    public void clearContext(int contextId) throws XPathException {
        for (NodeProxy p : this) {
            p.clearContext(contextId);
        }
    }

    @Override
    public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
        NodeProxy p = this.get((DocumentImpl)newNode.getOwnerDocument(), oldNodeId);
        if (p != null) {
            p.nodeMoved(oldNodeId, newNode);
        }
    }

    @Override
    public boolean isPersistentSet() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("NodeSet(");
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            NodeProxy p = this.get(i);
            result.append("[").append(p.getOwnerDocument().getDocId()).append(":").append(p.getNodeId()).append("]");
        }
        result.append(")");
        return result.toString();
    }

    private final class CollectionIterator
    implements Iterator<Collection> {
        private Collection nextCollection = null;
        private final NodeSetIterator nodeIterator = AbstractNodeSet.this.iterator();

        private CollectionIterator() {
            if (this.nodeIterator.hasNext()) {
                NodeProxy p = (NodeProxy)this.nodeIterator.next();
                this.nextCollection = p.getOwnerDocument().getCollection();
            }
        }

        @Override
        public final boolean hasNext() {
            return this.nextCollection != null;
        }

        @Override
        public final Collection next() {
            Collection oldCollection = this.nextCollection;
            this.nextCollection = null;
            while (this.nodeIterator.hasNext()) {
                NodeProxy p = (NodeProxy)this.nodeIterator.next();
                if (p.getOwnerDocument().getCollection().equals(oldCollection)) continue;
                this.nextCollection = p.getOwnerDocument().getCollection();
                break;
            }
            return oldCollection;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove is not implemented for CollectionIterator");
        }
    }
}

