/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.IOException;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentMetadata;
import org.exist.storage.BrokerPool;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.xmldb.XmldbURI;

public class BinaryDocument
extends DocumentImpl {
    private long pageNr = -1L;
    private long realSize = 0L;

    public BinaryDocument(BrokerPool pool) {
        super(pool);
    }

    public BinaryDocument(BrokerPool pool, Collection collection, XmldbURI fileURI) {
        super(pool, collection, fileURI);
    }

    @Override
    public byte getResourceType() {
        return 1;
    }

    public void setPage(long page) {
        this.pageNr = page;
    }

    public long getPage() {
        return this.pageNr;
    }

    @Override
    public long getContentLength() {
        return this.realSize;
    }

    public void setContentLength(long length) {
        this.realSize = length;
    }

    @Override
    public void write(VariableByteOutputStream ostream) throws IOException {
        ostream.writeInt(this.getDocId());
        ostream.writeUTF(this.getFileURI().toString());
        ostream.writeLong(this.pageNr);
        this.getPermissions().write(ostream);
        ostream.writeLong(this.realSize);
        this.getMetadata().write(this.getBrokerPool().getSymbols(), ostream);
    }

    @Override
    public void read(VariableByteInput istream) throws IOException {
        this.setDocId(istream.readInt());
        this.setFileURI(XmldbURI.create(istream.readUTF()));
        this.pageNr = istream.readLong();
        this.getPermissions().read(istream);
        this.realSize = istream.readLong();
        DocumentMetadata metadata = new DocumentMetadata();
        metadata.read(this.getBrokerPool().getSymbols(), istream);
        this.setMetadata(metadata);
    }
}

