/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.nio.charset.StandardCharsets;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.util.ByteConversion;
import org.exist.util.pool.NodePool;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Comment;

public class CommentImpl
extends AbstractCharacterData
implements Comment {
    public CommentImpl() {
        super((short)8);
    }

    public CommentImpl(String data) {
        super((short)8, data);
    }

    public CommentImpl(char[] data, int start, int howmany) {
        super((short)8, data, start, howmany);
    }

    @Override
    public String toString() {
        return "<!-- " + this.cdata.toString() + " -->";
    }

    @Override
    public byte[] serialize() {
        String s;
        try {
            s = StringValue.expand(this.cdata);
        }
        catch (XPathException e) {
            LOG.warn((Object)e);
            s = this.cdata.toString();
        }
        byte[] cd = s.getBytes(StandardCharsets.UTF_8);
        int nodeIdLen = this.nodeId.size();
        byte[] data = new byte[3 + nodeIdLen + cd.length];
        int pos = 0;
        data[pos] = 96;
        ByteConversion.shortToByte((short)this.nodeId.units(), data, ++pos);
        this.nodeId.serialize(data, pos += 2);
        System.arraycopy(cd, 0, data, pos += nodeIdLen, cd.length);
        return data;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        int pos = start;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        int nodeIdLen = dln.size();
        String cdata = new String(data, pos += nodeIdLen, len - (pos - start), StandardCharsets.UTF_8);
        CommentImpl comment = pooled ? (CommentImpl)NodePool.getInstance().borrowNode((short)8) : new CommentImpl();
        comment.setNodeId(dln);
        comment.appendData(cdata);
        return comment;
    }
}

