/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.IOException;
import org.exist.ResourceMetadata;
import org.exist.dom.persistent.DocumentTypeImpl;
import org.exist.dom.persistent.LockToken;
import org.exist.dom.persistent.SymbolTable;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.util.MimeType;
import org.w3c.dom.DocumentType;

public class DocumentMetadata
implements ResourceMetadata {
    public static final byte NO_DOCTYPE = 0;
    public static final byte HAS_DOCTYPE = 1;
    public static final byte NO_LOCKTOKEN = 0;
    public static final byte HAS_LOCKTOKEN = 2;
    private String mimeType = MimeType.XML_TYPE.getName();
    private long created = 0L;
    private long lastModified = 0L;
    private int pageCount = 0;
    private int userLock = 0;
    private DocumentType docType = null;
    private LockToken lockToken = null;
    protected transient int splitCount = 0;
    private boolean isReferenced = false;

    public DocumentMetadata() {
    }

    public DocumentMetadata(DocumentMetadata other) {
        this.mimeType = other.mimeType;
        this.created = other.created;
        this.lastModified = other.lastModified;
    }

    public void copyOf(DocumentMetadata other) {
        this.setCreated(other.getCreated());
        this.setLastModified(other.getLastModified());
        this.setMimeType(other.getMimeType());
        this.setDocType(other.getDocType());
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
        if (this.lastModified == 0L) {
            this.lastModified = created;
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public void incPageCount() {
        ++this.pageCount;
    }

    public void decPageCount() {
        --this.pageCount;
    }

    public void write(SymbolTable symbolTable, VariableByteOutputStream ostream) throws IOException {
        ostream.writeLong(this.created);
        ostream.writeLong(this.lastModified);
        ostream.writeInt(symbolTable.getMimeTypeId(this.mimeType));
        ostream.writeInt(this.pageCount);
        ostream.writeInt(this.userLock);
        if (this.docType != null) {
            ostream.writeByte((byte)1);
            ((DocumentTypeImpl)this.docType).write(ostream);
        } else {
            ostream.writeByte((byte)0);
        }
        if (this.lockToken != null) {
            ostream.writeByte((byte)2);
            this.lockToken.write(ostream);
        } else {
            ostream.writeByte((byte)0);
        }
    }

    public void read(SymbolTable symbolTable, VariableByteInput istream) throws IOException {
        this.created = istream.readLong();
        this.lastModified = istream.readLong();
        int mimeTypeSymbolsIndex = istream.readInt();
        this.mimeType = symbolTable.getMimeType(mimeTypeSymbolsIndex);
        this.pageCount = istream.readInt();
        this.userLock = istream.readInt();
        if (istream.readByte() == 1) {
            this.docType = new DocumentTypeImpl();
            ((DocumentTypeImpl)this.docType).read(istream);
        } else {
            this.docType = null;
        }
        if (istream.readByte() == 2) {
            this.lockToken = new LockToken();
            this.lockToken.read(istream);
        } else {
            this.lockToken = null;
        }
    }

    public int getUserLock() {
        return this.userLock;
    }

    public void setUserLock(int userLock) {
        this.userLock = userLock;
    }

    public LockToken getLockToken() {
        return this.lockToken;
    }

    public void setLockToken(LockToken token) {
        this.lockToken = token;
    }

    public DocumentType getDocType() {
        return this.docType;
    }

    public void setDocType(DocumentType docType) {
        this.docType = docType;
    }

    public void incSplitCount() {
        ++this.splitCount;
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public void setSplitCount(int count) {
        this.splitCount = count;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }

    public void setReferenced(boolean referenced) {
        this.isReferenced = referenced;
    }
}

