/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom.persistent;

import java.io.IOException;
import org.exist.dom.persistent.StoredNode;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;

public class DocumentTypeImpl
extends StoredNode
implements DocumentType {
    protected String publicId = null;
    protected String systemId = null;
    protected String name = null;

    public DocumentTypeImpl() {
        super((short)10);
    }

    public DocumentTypeImpl(String name, String publicId, String systemId) {
        super((short)10);
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    @Override
    public void clear() {
        super.clear();
        this.publicId = null;
        this.systemId = null;
        this.name = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public NamedNodeMap getEntities() {
        return null;
    }

    @Override
    public NamedNodeMap getNotations() {
        return null;
    }

    @Override
    public String getInternalSubset() {
        return null;
    }

    protected void write(VariableByteOutputStream ostream) throws IOException {
        ostream.writeUTF(this.name);
        ostream.writeUTF(this.systemId != null ? this.systemId : "");
        ostream.writeUTF(this.publicId != null ? this.publicId : "");
    }

    protected void read(VariableByteInput istream) throws IOException {
        this.name = istream.readUTF();
        this.systemId = istream.readUTF();
        if (this.systemId.length() == 0) {
            this.systemId = null;
        }
        this.publicId = istream.readUTF();
        if (this.publicId.length() == 0) {
            this.publicId = null;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<!DOCTYPE ").append(this.name);
        if (this.publicId != null) {
            builder.append(" PUBLIC \"").append(this.publicId).append("\"");
        }
        if (this.systemId != null) {
            if (this.publicId == null) {
                builder.append(" SYSTEM");
            }
            builder.append(" \"").append(this.systemId).append("\"");
        }
        builder.append(" >");
        return builder.toString();
    }
}

